/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.security;

import com.sun.enterprise.security.store.IdentityManager;
import com.sun.enterprise.util.OS;
import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NssStore {
    private static Logger _logger = null;
    private static NssStore _instance = null;
    private static ArrayList keyStores = new ArrayList();
    private static ArrayList trustStores = new ArrayList();
    private static ArrayList tokenNames = null;
    private static ArrayList tokenInfoList = null;
    private static String _password = null;
    private static boolean useCaseExact = true;

    public static String getNssDbPassword() {
        if (_password == null) {
            _password = System.getProperty("com.sun.appserv.nss.db.password");
        }
        return _password;
    }

    private NssStore(String dbDir, boolean initJKS, String password) throws Exception {
        _password = password;
        if (dbDir == null) {
            dbDir = System.getProperty("com.sun.appserv.nss.db");
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "NssStore.initNSSNative ...");
        }
        this.initNSSNative(dbDir);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "NssStore.initSlotNative");
        }
        this.initSlotNative(null, NssStore.getNssDbPassword());
        String[] tokNames = this.getTokenNamesAsArray();
        Map name2PwdMap = IdentityManager.getMap();
        if (tokNames != null && tokNames.length > 0) {
            for (int i = 0; i < tokNames.length; ++i) {
                String tokenName = tokNames[i];
                this.initSlotNative(tokenName, (String)name2PwdMap.get(tokenName));
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "NssStore.initSlotNative Done");
        }
        if (initJKS) {
            this.initStores();
        }
    }

    public static synchronized NssStore getInstance() throws Exception {
        return NssStore.getInstance(null, true);
    }

    public static synchronized NssStore getInstance(String dbDir, boolean initJKS) throws Exception {
        return NssStore.getInstance(dbDir, initJKS, null);
    }

    public static synchronized NssStore getInstance(String dbDir, boolean initJKS, String password) throws Exception {
        if (_instance == null) {
            _instance = new NssStore(dbDir, initJKS, password);
        }
        return _instance;
    }

    public static synchronized void closeInstance() {
        if (_instance != null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "NssStore.close");
            }
            _instance.close();
            _instance = null;
            _password = null;
        }
    }

    private native void initNSSNative(String var1) throws Exception;

    private native void initSlotNative(String var1, String var2) throws Exception;

    private native void getKeysAndCertificatesNative(HashMap var1, HashMap var2, String var3, String var4) throws Exception;

    private native void getCACertificatesNative(HashMap var1, String var2) throws Exception;

    private native ArrayList getTokenNamesNative() throws Exception;

    private native ArrayList getTokenInfoListNative() throws Exception;

    public native void changePassword(String var1, String var2) throws Exception;

    private native void close();

    List getKeyStores() throws Exception {
        return (ArrayList)keyStores.clone();
    }

    List getTrustStores() throws Exception {
        return (ArrayList)trustStores.clone();
    }

    List getTokenNames() throws Exception {
        if (tokenNames == null) {
            tokenNames = this.getTokenNamesNative();
        }
        if (tokenNames == null) {
            tokenNames = new ArrayList();
        }
        return (List)tokenNames.clone();
    }

    public String[] getTokenNamesAsArray() throws Exception {
        if (tokenNames == null) {
            tokenNames = (ArrayList)this.getTokenNames();
        }
        return tokenNames.toArray(new String[tokenNames.size()]);
    }

    List getTokenInfoList() throws Exception {
        if (tokenInfoList == null && (tokenInfoList = this.getTokenInfoListNative()) == null) {
            tokenInfoList = new ArrayList();
        }
        return (List)tokenInfoList.clone();
    }

    private void initStores() throws Exception {
        String[] tokNames = this.getTokenNamesAsArray();
        Map name2PwdMap = IdentityManager.getMap();
        if (tokNames != null && tokNames.length > 0) {
            for (int i = 0; i < tokNames.length; ++i) {
                String tName = tokNames[i];
                this.initStore(tName, (String)name2PwdMap.get(tName));
            }
        }
        this.initStore(null, NssStore.getNssDbPassword());
        this.initCAStore(NssStore.getNssDbPassword());
    }

    private KeyStore getJavaKeyStore() throws KeyStoreException {
        if (useCaseExact) {
            try {
                return KeyStore.getInstance("CaseExactJKS");
            }
            catch (KeyStoreException kex) {
                useCaseExact = false;
            }
        }
        return KeyStore.getInstance("JKS");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initStore(String tokenName, String password) throws Exception {
        KeyStore keyStore = this.getJavaKeyStore();
        KeyStore trustStore = this.getJavaKeyStore();
        keyStore.load(null, password.toCharArray());
        trustStore.load(null, password.toCharArray());
        KeyStore ks = KeyStore.getInstance("PKCS12");
        HashMap keyMap = new HashMap();
        HashMap certMap = new HashMap();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "NssStore.getKeysAndCertificatesNative ...");
        }
        this.getKeysAndCertificatesNative(keyMap, certMap, tokenName, password);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "NssStore.getKeysAndCertificatesNative Done");
        }
        Iterator keyAliasIter = keyMap.keySet().iterator();
        while (keyAliasIter.hasNext()) {
            String alias;
            block12: {
                Exception ex2;
                Object var13_14;
                alias = (String)keyAliasIter.next();
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "NssStore.keyAlias = " + alias);
                }
                byte[] pkcs12bs = (byte[])keyMap.get(alias);
                BufferedInputStream bufInput = null;
                try {
                    if (pkcs12bs != null && pkcs12bs.length > 0) {
                        bufInput = new BufferedInputStream(new ByteArrayInputStream(pkcs12bs));
                    }
                    ks.load(bufInput, password.toCharArray());
                    var13_14 = null;
                    if (bufInput == null) break block12;
                }
                catch (Throwable throwable) {
                    var13_14 = null;
                    if (bufInput == null) throw throwable;
                    try {
                        bufInput.close();
                        throw throwable;
                    }
                    catch (Exception ex2) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (Exception ex2) {}
                bufInput.close();
            }
            Key key = ks.getKey(alias, password.toCharArray());
            Certificate[] chain = ks.getCertificateChain(alias);
            keyStore.setKeyEntry(alias, key, password.toCharArray(), chain);
        }
        this.processCertificates(certMap, trustStore);
        Enumeration<String> keyAlias = keyStore.aliases();
        while (true) {
            if (!keyAlias.hasMoreElements()) {
                keyStores.add(keyStore);
                trustStores.add(trustStore);
                return;
            }
            String alias = keyAlias.nextElement();
            trustStore.setCertificateEntry(alias, keyStore.getCertificate(alias));
        }
    }

    void initCAStore(String password) throws Exception {
        KeyStore trustStore = this.getJavaKeyStore();
        trustStore.load(null, password.toCharArray());
        HashMap certMap = new HashMap();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "NssStore.getCACertificatesNative ...");
        }
        this.getCACertificatesNative(certMap, password);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "NssStore.getCACertificatesNative Done");
        }
        this.processCertificates(certMap, trustStore);
        trustStores.add(trustStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void processCertificates(HashMap certMap, KeyStore trustStore) throws Exception {
        certAliasIter = certMap.keySet().iterator();
        certFactory = CertificateFactory.getInstance("X.509");
        while (certAliasIter.hasNext()) {
            block17: {
                alias = (String)certAliasIter.next();
                if (NssStore._logger.isLoggable(Level.FINE)) {
                    NssStore._logger.log(Level.FINE, "NssStore.certAlias = " + alias);
                }
                if ((derBytes = (byte[])certMap.get(alias)) == null || derBytes.length <= 0) continue;
                bufInput = null;
                certColl = null;
                try {
                    bufInput = new BufferedInputStream(new ByteArrayInputStream(derBytes));
                    certColl = certFactory.generateCertificates(bufInput);
                    var11_13 = null;
                    ** if (bufInput == null) goto lbl-1000
                }
                catch (Throwable var10_12) {
                    var11_13 = null;
                    if (bufInput != null) {
                        try {
                            bufInput.close();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    throw var10_12;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        bufInput.close();
                    }
                    catch (Exception ex) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block17;
                    catch (Exception ex) {
                        if (NssStore._logger.isLoggable(Level.FINE)) {
                            NssStore._logger.log(Level.FINE, "Can't load cert: " + alias, ex);
                        } else if (NssStore._logger.isLoggable(Level.INFO)) {
                            NssStore._logger.log(Level.INFO, "nss.cantloadcert", alias);
                        }
                        var11_13 = null;
                        if (bufInput != null) {
                            try {
                                bufInput.close();
                            }
                            catch (Exception ex) {}
                        }
                    }
                }
            }
            if (certColl != null) {
                certIter = certColl.iterator();
                if (!certIter.hasNext()) continue;
                cert = (X509Certificate)certIter.next();
                trustStore.setCertificateEntry(alias, cert);
                continue;
            }
            if (!NssStore._logger.isLoggable(Level.INFO)) continue;
            NssStore._logger.log(Level.INFO, "nss.cantloadcert", alias);
        }
    }

    public static void main(String[] args) throws Exception {
        String dbDir = System.getProperty("com.sun.appserv.nss.db");
        String pwd = NssStore.getNssDbPassword();
        System.out.println("dbDir = " + dbDir + ", password = " + pwd);
        NssStore nssStore = NssStore.getInstance();
        KeyStore ks = (KeyStore)nssStore.getKeyStores().get(0);
        KeyStore ts = (KeyStore)nssStore.getTrustStores().get(0);
        NssStore.dumpKeyStore(ks, pwd);
        NssStore.dumpKeyStore(ts, pwd);
    }

    private static void dumpKeyStore(KeyStore ks, String pwd) throws Exception {
        System.out.println("Dump keystore: " + ks);
        Enumeration<String> aliases = ks.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (ks.isKeyEntry(alias)) {
                System.out.println("\tkey = " + alias + ": " + ks.getKey(alias, pwd.toCharArray()));
                continue;
            }
            System.out.println("\tcert = " + alias + ": " + ks.getCertificate(alias));
        }
    }

    static {
        _logger = LogDomains.getLogger((String)"javax.enterprise.system.core.security");
        boolean isWin = OS.isWindows();
        if (!isWin) {
            System.loadLibrary("nspr4");
        } else {
            System.loadLibrary("libnspr4");
        }
        if (!isWin) {
            System.loadLibrary("plc4");
            try {
                System.loadLibrary("softokn3");
            }
            catch (Throwable throwable) {}
        } else {
            System.loadLibrary("libplc4");
        }
        System.loadLibrary("nss3");
        System.loadLibrary("smime3");
        System.loadLibrary("asnss");
    }
}

