/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.quorum.impl.jmx;

import com.sun.enterprise.ee.quorum.core.Group;
import com.sun.enterprise.ee.quorum.core.GroupEvent;
import com.sun.enterprise.ee.quorum.core.GroupEventListener;
import com.sun.enterprise.ee.quorum.core.GroupServiceProvider;
import com.sun.enterprise.ee.quorum.core.JoinGroupException;
import com.sun.enterprise.ee.quorum.core.Member;
import com.sun.enterprise.ee.quorum.core.MemberExistsException;
import com.sun.enterprise.ee.quorum.core.NoSuchMemberException;
import com.sun.enterprise.ee.quorum.impl.jmx.JMXConnectorClientManager;
import com.sun.enterprise.ee.quorum.impl.jmx.JMXGroupServiceConfig;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.jmxmp.JMXMPConnector;

public class S1ASJMXGroupServiceProvider
extends GroupServiceProvider {
    JMXGroupServiceConfig groupConfig = null;
    Hashtable connClients = new Hashtable();
    Hashtable connThreads = new Hashtable();
    int sequenceNumber = 0;
    JMXServiceURL selfUrl;
    static /* synthetic */ Class class$javax$management$remote$JMXServiceURL;
    static /* synthetic */ Class class$java$lang$String;

    public S1ASJMXGroupServiceProvider() {
        this.groupConfig = new JMXGroupServiceConfig();
    }

    public void joinGroup(String groupName, Member member) throws JoinGroupException, MemberExistsException {
        try {
            System.out.println("S1ASJMXGroupServiceProvider: joining group,initializing client connections with other members\n");
            Vector members = this.getMemberServiceURLs();
            members = this.getRemainingMembers(members, member);
            this.initializeClientConnections(groupName, members);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        super.joinGroup(groupName, member);
        Group g = this.getGroup(groupName);
        Iterator e = g.getMembers().iterator();
        while (e.hasNext()) {
            System.out.println(((Member)e.next()).getPort());
        }
    }

    private void sendSelfServerURL(String groupName) {
        JMXMPConnector c = null;
        Enumeration e = this.connClients.keys();
        while (e.hasMoreElements()) {
            try {
                c = (JMXMPConnector)this.connClients.get(e.nextElement());
                MBeanServerConnection mbs = c.getMBeanServerConnection();
                ObjectName grpCommMBean = new ObjectName("example:name=GrpCommMBean");
                Object[] params = new Object[]{this.selfUrl, groupName};
                mbs.invoke(grpCommMBean, "reestablishConnection", params, new String[]{(class$javax$management$remote$JMXServiceURL == null ? S1ASJMXGroupServiceProvider.class$("javax.management.remote.JMXServiceURL") : class$javax$management$remote$JMXServiceURL).getName(), (class$java$lang$String == null ? S1ASJMXGroupServiceProvider.class$("java.lang.String") : class$java$lang$String).getName()});
            }
            catch (JMException jm) {
                System.out.println("The remote invoke operation resulted in a JMX Exception.\n");
                System.out.println(jm.getMessage());
            }
            catch (IOException ie) {
                System.out.println("The connection to " + c.toString() + " was dropped.\n");
                System.out.println(ie.getMessage());
            }
        }
    }

    public void leaveGroup(String groupName, Member member) throws NoSuchMemberException {
    }

    protected void fireFailureOccured(Member m, List groupNames, int failureType) {
        long timeStamp = new Date().getTime();
        GroupEvent event = new GroupEvent(failureType, m, groupNames, timeStamp, this.getSequenceNumber(), null);
        System.out.println("S1ASJMXGroupServiceProvider: firing failure event\n");
        listener.handleGroupEvent(event);
    }

    protected void fireMemberAdded(Member m, String groupName) {
        long timeStamp = new Date().getTime();
        Vector<String> g = new Vector<String>();
        g.add(groupName);
        GroupEvent event = new GroupEvent(0, m, g, timeStamp, this.getSequenceNumber(), null);
        System.out.println("S1ASJMXGroupServiceProvider: firing member addition event\n");
        listener.handleGroupEvent(event);
    }

    public void receiveMessageFromMember(Member sender, String groupName, Serializable data) {
        long timeStamp = new Date().getTime();
        Vector<String> g = new Vector<String>();
        g.add(groupName);
        GroupEvent event = new GroupEvent(3, sender, g, timeStamp, this.getSequenceNumber(), data);
        System.out.println("S1ASJMXGroupServiceProvider: firing MessageReceived event\n");
        listener.handleGroupEvent(event);
    }

    public void sendMessage(Serializable userData, Member m) {
    }

    public void sendMessage(Serializable userData, Member[] m) {
    }

    public List getQuorum(String groupName) {
        Group g = this.getGroup(groupName);
        return g.getMembers();
    }

    private void initializeClientConnections(String groupName, Vector members) throws IOException {
        Enumeration en = members.elements();
        while (en.hasMoreElements()) {
            try {
                JMXServiceURL url = (JMXServiceURL)en.nextElement();
                this.createConnection(url, groupName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void createConnection(JMXServiceURL url, String groupName) {
        Thread t;
        Thread mgr = null;
        if (!(this.connClients.get(url) != null || (t = (Thread)this.connThreads.get(url)) != null && t.isAlive())) {
            mgr = new Thread(new JMXConnectorClientManager(url, this, groupName));
            this.connThreads.put(url, mgr);
            mgr.start();
        }
    }

    public void recreateConnection(Object url, String groupName) {
        this.createConnection((JMXServiceURL)url, groupName);
    }

    public synchronized void addClientConnectors(JMXServiceURL url, JMXConnector conn, String groupName) throws MemberExistsException {
        if (conn != null && url != null) {
            this.connClients.put(url, conn);
            Member m = new Member(url.getHost(), url.getPort(), null, null);
            Group g = this.getGroup(groupName);
            if (!g.containsMember(m)) {
                g.addMember(m);
                this.fireMemberAdded(m, groupName);
                System.out.println(this.getClass().getName() + ": Member Added from " + url.getHost() + ":" + url.getPort() + " under group " + groupName);
            }
        }
        try {
            Thread.currentThread();
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.sendSelfServerURL(groupName);
    }

    private Vector getMemberServiceURLs() throws MalformedURLException {
        String[] a = this.groupConfig.getServiceURLs();
        Vector<JMXServiceURL> s = new Vector<JMXServiceURL>();
        for (int i = 0; i < a.length; ++i) {
            String[] hostport = a[i].split(":");
            s.add(new JMXServiceURL("jmxmp", hostport[0].trim(), new Integer(hostport[1].trim())));
        }
        return s;
    }

    private Vector getRemainingMembers(Vector members, Member member) {
        Enumeration e = members.elements();
        while (e.hasMoreElements()) {
            JMXServiceURL m = (JMXServiceURL)e.nextElement();
            if (!m.getHost().equals(member.getHost()) || m.getPort() != member.getPort()) continue;
            this.selfUrl = m;
            members.remove(m);
        }
        return members;
    }

    private int getSequenceNumber() {
        return this.sequenceNumber++;
    }

    public void handleFailure(JMXServiceURL url, boolean pingTimeout) {
        Member m = this.getMember(url.getHost(), url.getPort());
        Vector groups = this.getAllGroups();
        Vector<String> groupNames = new Vector<String>();
        Iterator i = groups.iterator();
        while (i.hasNext()) {
            Group g = (Group)i.next();
            try {
                groupNames.add(g.getGroupName());
                g.removeMember(m);
            }
            catch (NoSuchMemberException e) {
                System.out.println(e.getMessage());
            }
        }
        this.connClients.remove(url);
        if (pingTimeout) {
            this.fireFailureOccured(m, groupNames, 2);
        } else {
            this.fireFailureOccured(m, groupNames, 1);
        }
    }

    public void addGroupEventListener(GroupEventListener listener) {
        super.addGroupEventsListener(listener);
    }
}

