/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.quorum.impl.jmx;

import com.sun.enterprise.ee.quorum.impl.jmx.JMXConnectorClientManager;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketException;
import java.util.Date;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.jmxmp.JMXMPConnector;

public class JMXConnectorPinger {
    MBeanServerConnection mbs;
    JMXMPConnector conn;
    JMXServiceURL url;
    long pingInterval = 5000L;
    long pingTimeout = 300L;

    public JMXConnectorPinger(JMXMPConnector conn, MBeanServerConnection mbs, JMXServiceURL url, long pingInt, long pingTimeout) {
        this.conn = conn;
        this.mbs = mbs;
        this.url = url;
        if (pingInt > 0L) {
            this.pingInterval = pingInt;
        }
        if (pingTimeout > 0L) {
            this.pingTimeout = pingTimeout;
        }
    }

    public synchronized void ping(JMXConnectorClientManager callBack) {
        boolean sockExcpCount = false;
        boolean connExcpCount = false;
        try {
            ObjectName o = new ObjectName("domain:name=null");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        while (this.mbs != null) {
            long timeStamp = 0L;
            try {
                timeStamp = new Date().getTime();
                ObjectName n = new ObjectName("example:type=connectorServer, name=jmxConnServ");
                Boolean active = (Boolean)this.mbs.invoke(n, "isActive", new Object[0], new String[0]);
            }
            catch (InstanceNotFoundException e) {
                e.printStackTrace();
                break;
            }
            catch (MalformedObjectNameException e) {
                e.printStackTrace();
                break;
            }
            catch (MBeanException e) {
                e.printStackTrace();
                break;
            }
            catch (ReflectionException e) {
                e.printStackTrace();
                break;
            }
            catch (SocketException e) {
                System.out.println(e.getMessage() + " at url");
                callBack.handleProcessFailure();
                break;
            }
            catch (InterruptedIOException e) {
                System.out.println(e.getMessage() + " at url");
                callBack.handleMachineOrNetworkFailure();
                break;
            }
            catch (IOException e) {
                long newtime = new Date().getTime() - timeStamp;
                if (newtime < this.pingTimeout) {
                    callBack.handleProcessFailure();
                    break;
                }
                callBack.handleMachineOrNetworkFailure();
                break;
            }
            try {
                Thread.sleep(this.pingInterval);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void notifyFailureSuspected() {
    }
}

