/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.quorum.impl.jmx;

import com.sun.enterprise.ee.quorum.core.MemberExistsException;
import com.sun.enterprise.ee.quorum.impl.jmx.JMXConnectorPinger;
import com.sun.enterprise.ee.quorum.impl.jmx.JMXGroupServiceConfig;
import com.sun.enterprise.ee.quorum.impl.jmx.S1ASJMXGroupServiceProvider;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.HashMap;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.jmxmp.JMXMPConnector;

public class JMXConnectorClientManager
implements Runnable {
    private String host = null;
    private int port;
    private JMXServiceURL url = null;
    private S1ASJMXGroupServiceProvider callback;
    private static long DEFAULT_RETRY_INTERVAL = 3000L;
    private static int DEFAULT_NUM_RETRIES = 0;
    private JMXConnectorPinger pinger;
    private String groupName = null;
    private JMXGroupServiceConfig cfg;

    public JMXConnectorClientManager(JMXServiceURL url, S1ASJMXGroupServiceProvider Callback2, String groupName) {
        try {
            this.url = url;
            this.host = url.getHost();
            this.port = url.getPort();
            this.callback = Callback2;
            this.groupName = groupName;
            this.cfg = new JMXGroupServiceConfig();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void run() {
        JMXMPConnector conn = this.createConnection();
        if (conn != null) {
            try {
                MBeanServerConnection mbs = conn.getMBeanServerConnection();
                this.pingConnections(conn, mbs);
            }
            catch (IOException e) {
                System.out.println("Server Connection has closed before client could get a reference to the Server\n");
                System.out.println(e.getMessage());
            }
        }
    }

    private JMXMPConnector createConnection() {
        int retries = this.cfg.getClientConnectionRetries();
        long retryInterval = this.cfg.getClientReconnectionInterval();
        return this.createConnection(retryInterval, retries);
    }

    private JMXMPConnector createConnection(long retryInterval, int maxNumRetries) {
        JMXMPConnector conn = null;
        int connExcpCount = 0;
        if (retryInterval <= 0L) {
            retryInterval = DEFAULT_RETRY_INTERVAL;
        }
        if (maxNumRetries <= 0) {
            maxNumRetries = DEFAULT_NUM_RETRIES;
        }
        try {
            while (conn == null && (maxNumRetries == 0 || connExcpCount <= maxNumRetries)) {
                block13: {
                    try {
                        return this.connect();
                    }
                    catch (InterruptedIOException e) {
                        if (maxNumRetries <= 0 || ++connExcpCount < maxNumRetries) break block13;
                        this.notifyFailure(false);
                        break;
                    }
                    catch (ConnectException e) {
                        if (maxNumRetries <= 0 || ++connExcpCount < maxNumRetries) break block13;
                        System.out.println("Process Failure at " + this.url.toString() + "\n");
                        this.notifyFailure(false);
                        break;
                    }
                    catch (UnknownHostException e) {
                        if (maxNumRetries <= 0 || ++connExcpCount < maxNumRetries) break block13;
                        System.out.println("Node Failure at " + this.url.getHost() + "\n");
                        this.notifyFailure(false);
                        break;
                    }
                    catch (SocketException e) {
                        if (maxNumRetries <= 0 || ++connExcpCount < maxNumRetries) break block13;
                        System.out.println("Socket failure at " + this.url.toString() + "\n");
                        this.notifyFailure(false);
                        break;
                    }
                    catch (MemberExistsException ex) {
                        ex.printStackTrace();
                    }
                }
                try {
                    Thread.sleep(retryInterval);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            System.out.println("Exception Reported:");
            e.printStackTrace();
        }
        return conn;
    }

    private JMXMPConnector connect() throws ConnectException, MemberExistsException, UnknownHostException, IOException {
        JMXMPConnector conn = null;
        HashMap<String, Long> m = new HashMap<String, Long>();
        m.put("com.sun.jmx.remote.request.waiting.timeout", new Long(this.cfg.getPingTimeout()));
        conn = (JMXMPConnector)JMXConnectorFactory.connect(this.url, m);
        if (conn != null) {
            System.out.println("CONNECTED");
            this.callback.addClientConnectors(this.url, (JMXConnector)conn, this.groupName);
        }
        return conn;
    }

    public void notifyFailure(boolean pingTimeout) {
        this.callback.handleFailure(this.url, pingTimeout);
    }

    public JMXServiceURL getServiceURL() {
        return this.url;
    }

    public void pingConnections(JMXMPConnector conn, MBeanServerConnection mbs) {
        this.pinger = new JMXConnectorPinger(conn, mbs, this.url, this.cfg.getPingInterval(), this.cfg.getPingTimeout());
        this.pinger.ping(this);
    }

    public void handleProcessFailure() {
        JMXMPConnector conn = null;
        System.out.println("IOException: Attempting to reconnect...........\n");
        conn = this.createConnection(DEFAULT_RETRY_INTERVAL, this.cfg.getPingReconnectionRetries());
        if (conn != null) {
            try {
                this.pingConnections(conn, conn.getMBeanServerConnection());
            }
            catch (IOException e) {
                System.out.println("JMXMPConnector could not get MBeanServerConnection.\n");
                System.out.println(e.getMessage());
            }
        }
    }

    public void handleMachineOrNetworkFailure() {
        System.out.println("Ping Timed Out: Notifying Failure...........\n");
        this.notifyFailure(true);
    }
}

