/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.quorum.core;

import com.sun.enterprise.ee.quorum.core.Group;
import com.sun.enterprise.ee.quorum.core.GroupEventListener;
import com.sun.enterprise.ee.quorum.core.GroupService;
import com.sun.enterprise.ee.quorum.core.JoinGroupException;
import com.sun.enterprise.ee.quorum.core.Member;
import com.sun.enterprise.ee.quorum.core.MemberExistsException;
import com.sun.enterprise.ee.quorum.core.NoSuchMemberException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public abstract class GroupServiceProvider
implements GroupService {
    protected static GroupEventListener listener = null;
    Vector groups = new Vector();

    public void addGroupEventsListener(GroupEventListener listener) {
        if (GroupServiceProvider.listener == null) {
            GroupServiceProvider.listener = listener;
        }
    }

    protected abstract void fireFailureOccured(Member var1, List var2, int var3);

    protected abstract void fireMemberAdded(Member var1, String var2);

    public abstract List getQuorum(String var1);

    public abstract void sendMessage(Serializable var1, Member var2);

    public abstract void sendMessage(Serializable var1, Member[] var2);

    public void joinGroup(String groupName, Member member) throws JoinGroupException, MemberExistsException {
        Group g = this.getGroup(groupName);
        if (!g.containsMember(member)) {
            g.addMember(member);
        }
        this.updateGroupsList(g);
    }

    protected void updateGroupsList(Group g) {
        if (!this.groups.contains(g)) {
            this.groups.add(g);
        }
    }

    protected void removeFromGroupsList(Group g) {
        if (g.getMembers().size() == 0 && this.groups.contains(g)) {
            this.groups.remove(g);
        }
    }

    public void leaveGroup(String groupName, Member member) throws NoSuchMemberException {
        Group g = this.getGroup(groupName);
        if (g.containsMember(member)) {
            g.removeMember(member);
        }
        this.removeFromGroupsList(g);
    }

    public Vector getAllGroups() {
        return this.groups;
    }

    public Group getGroup(String groupName) {
        Enumeration e = this.groups.elements();
        while (e.hasMoreElements()) {
            Group g = (Group)e.nextElement();
            if (!g.getGroupName().equals(groupName)) continue;
            return g;
        }
        return new Group(groupName);
    }

    public Member getMember(String host, int port) {
        Member m;
        Vector groups = this.getAllGroups();
        Iterator i = groups.iterator();
        while (i.hasNext()) {
            Group g = (Group)i.next();
            Iterator list = g.getMembers().iterator();
            while (list.hasNext()) {
                m = (Member)list.next();
                if (!m.getHost().equals(host) || m.getPort() != port) continue;
                return m;
            }
        }
        m = new Member(host, port, null, null);
        return m;
    }

    public void removeGroupEventsListener(GroupEventListener listener) {
        if (GroupServiceProvider.listener != null) {
            GroupServiceProvider.listener = null;
        }
    }

    public abstract void recreateConnection(Object var1, String var2);
}

