/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.quorum.core;

import com.sun.enterprise.ee.quorum.core.Member;
import com.sun.enterprise.ee.quorum.core.MemberExistsException;
import com.sun.enterprise.ee.quorum.core.NoSuchMemberException;
import java.util.Iterator;
import java.util.Vector;

public class Group {
    private String groupName = "defaultgroupname";
    private String groupId = "defaultgroupid";
    private Vector members = new Vector();

    public Group(String groupName) {
        this(groupName, null);
    }

    public Group(String name, String id) {
        this.groupName = name;
        this.groupId = id;
    }

    public synchronized void addMember(Member newMember) throws MemberExistsException {
        if (this.containsMember(newMember)) {
            throw new MemberExistsException("Member already exists: " + newMember);
        }
        this.members.add(newMember);
    }

    public synchronized void removeMember(Member member) throws NoSuchMemberException {
        if (!this.containsMember(member)) {
            throw new NoSuchMemberException("Non Existent member cannot be removed:" + member);
        }
        this.members.remove(member);
    }

    String getGroupId() {
        return this.groupId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public Vector getMembers() {
        return this.members;
    }

    public int getMemberCount() {
        return this.members.size();
    }

    public boolean containsMember(Member m) {
        Iterator list = this.members.iterator();
        while (list.hasNext()) {
            Member member = (Member)list.next();
            String host = member.getHost();
            int port = member.getPort();
            if (!host.equals(m.getHost()) || port != m.getPort()) continue;
            return true;
        }
        return false;
    }

    public synchronized void removeAllMembers(String groupName) {
        this.members.removeAllElements();
    }
}

