/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.nodeagent;

import com.sun.appserv.server.ServerLifecycleException;
import com.sun.enterprise.admin.event.AdminEvent;
import com.sun.enterprise.admin.event.AdminEventListenerRegistry;
import com.sun.enterprise.admin.event.AdminEventResult;
import com.sun.enterprise.admin.event.ShutdownEvent;
import com.sun.enterprise.admin.event.ShutdownEventListener;
import com.sun.enterprise.admin.server.core.channel.AdminChannel;
import com.sun.enterprise.admin.server.core.channel.RMIClient;
import com.sun.enterprise.ee.admin.servermgmt.AgentConfig;
import com.sun.enterprise.ee.admin.servermgmt.DASPropertyReader;
import com.sun.enterprise.ee.admin.servermgmt.NodeAgentPropertyReader;
import com.sun.enterprise.ee.nodeagent.NodeAgent;
import com.sun.enterprise.ee.nodeagent.Shutdown;
import com.sun.enterprise.security.store.IdentityManager;
import com.sun.enterprise.util.ASenvPropertyReader;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NodeAgentMain {
    private static final StringManager _strMgr = StringManager.getManager((Class)NodeAgentMain.class);
    private static AgentConfig _config = null;
    private static Logger _logger = null;
    private static boolean bDebug = false;

    private static void usage() {
        System.out.println("usage: NodeAgentMain start|stop");
    }

    private static AgentConfig getConfig() {
        if (_config == null) {
            _config = new AgentConfig();
        }
        return _config;
    }

    static Logger getLogger() {
        if (_logger == null) {
            _logger = Logger.getLogger("javax.ee.enterprise.system.nodeagent", "com.sun.logging.ee.enterprise.system.nodeagent.LogStrings");
            if (bDebug) {
                _logger.setLevel(Level.FINEST);
            } else {
                _logger.setLevel(Level.CONFIG);
            }
        }
        return _logger;
    }

    private static void shutdown() {
        try {
            NodeAgentMain.getLogger().log(Level.INFO, "nodeAgent.sending-stop");
            String agentName = NodeAgentMain.getConfig().getRepositoryName();
            RMIClient rmiClient = AdminChannel.getRMIClient((String)agentName);
            ShutdownEvent shutdownEvent = new ShutdownEvent(agentName);
            AdminEventResult adminEventResult = rmiClient.sendNotification((AdminEvent)shutdownEvent);
        }
        catch (Exception ex) {
            NodeAgentMain.getLogger().log(Level.WARNING, "nodeAgent.exception", ex);
            System.exit(1);
        }
    }

    private static void startup(String startInstancesOverride) throws ServerLifecycleException {
        try {
            IdentityManager.populateFromInputStream();
        }
        catch (IOException e) {
            NodeAgentMain.getLogger().log(Level.WARNING, "nodeagent.failureOnReadingSecurityIdentity", e);
        }
        NodeAgentMain.getLogger().log(Level.INFO, IdentityManager.getFormatedContents());
        AdminChannel.createRMIChannel();
        AdminChannel.createSharedSecret();
        System.out.println(_strMgr.getString("nodeAgent.redirecting.output", (Object)(System.getProperty("com.sun.aas.instanceRoot") + "/logs/server.log")));
        NodeAgentMain.getLogger().log(Level.INFO, "nodeagent.starting.agent");
        DASPropertyReader dasReader = new DASPropertyReader(new AgentConfig());
        try {
            dasReader.read();
            if (dasReader.getPort() != null) {
                NodeAgentMain.getLogger().log(Level.CONFIG, "DAS url = " + dasReader.getJMXURL());
            }
        }
        catch (Exception e) {
            NodeAgentMain.getLogger().log(Level.INFO, "nodeAgent.das_properties_not_found", e);
        }
        NodeAgentPropertyReader nodeAgentReader = new NodeAgentPropertyReader(new AgentConfig());
        try {
            nodeAgentReader.read();
            NodeAgentMain.getLogger().log(Level.CONFIG, "NodeAgent url  = " + nodeAgentReader.getJMXURL());
        }
        catch (Exception e) {
            NodeAgentMain.getLogger().log(Level.SEVERE, "nodeAgent.nodeagent_properties_not_found", e);
            System.exit(1);
        }
        try {
            NodeAgent nas = new NodeAgent(dasReader, nodeAgentReader);
            AdminEventListenerRegistry.addShutdownEventListener((ShutdownEventListener)new Shutdown(nas));
            nas.run(startInstancesOverride);
            AdminChannel.setRMIChannelReady();
        }
        catch (Exception e) {
            throw new ServerLifecycleException((Throwable)e);
        }
    }

    public static void main(String[] args) {
        try {
            if (System.getProperty("Debug") != null) {
                bDebug = true;
            }
            ASenvPropertyReader propertyReader = new ASenvPropertyReader(System.getProperty("com.sun.aas.configRoot"));
            propertyReader.setSystemProperties();
            if (args == null || args.length < 1) {
                NodeAgentMain.usage();
                System.exit(1);
            } else if (args[0].equals("stop")) {
                NodeAgentMain.shutdown();
                System.exit(0);
            } else if (args[0].equals("start")) {
                String startInstancesOverride = null;
                for (int ii = 0; ii < args.length; ++ii) {
                    if (!args[ii].startsWith("startInstancesOverride")) continue;
                    startInstancesOverride = args[ii].substring(args[ii].indexOf("=") + 1);
                }
                NodeAgentMain.startup(startInstancesOverride);
            } else {
                NodeAgentMain.usage();
                System.exit(1);
            }
        }
        catch (Throwable ex) {
            NodeAgentMain.getLogger().log(Level.SEVERE, "nodeAgent.exception", ex);
            System.exit(1);
        }
    }
}

