/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.deployment.phasing;

import com.sun.enterprise.admin.target.ClusterTarget;
import com.sun.enterprise.admin.target.Target;
import com.sun.enterprise.admin.target.TargetType;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.deployment.backend.DeployableObjectType;
import com.sun.enterprise.deployment.phasing.ApplicationReferenceHelper;
import com.sun.enterprise.deployment.phasing.DeploymentTarget;
import com.sun.enterprise.deployment.phasing.DeploymentTargetException;
import com.sun.enterprise.deployment.phasing.DeploymentTargetFactory;
import com.sun.enterprise.deployment.phasing.ServerDeploymentTarget;
import com.sun.enterprise.util.i18n.StringManager;

public class ClusterDeploymentTarget
extends ClusterTarget
implements DeploymentTarget {
    protected static StringManager localStrings = StringManager.getManager((Class)ClusterDeploymentTarget.class);
    protected String thisTargetName = null;
    protected ConfigContext configContext = null;
    protected String domainName = null;

    public ClusterDeploymentTarget(ConfigContext configContext, String domainName, String groupName) {
        super(groupName, configContext);
        this.configContext = configContext;
        this.thisTargetName = groupName;
        this.domainName = domainName;
    }

    protected TargetType[] getValidTypes() {
        DeploymentTargetFactory tf = DeploymentTargetFactory.getDeploymentTargetFactory();
        return tf.getValidDeploymentTargetTypes();
    }

    public String[] getModules(DeployableObjectType type, Boolean enabled) throws DeploymentTargetException {
        try {
            ServerDeploymentTarget sdTarget = new ServerDeploymentTarget(this.configContext, this.domainName, "");
            return sdTarget.getModules(this.getAppsDeployedToCluster(), type, enabled);
        }
        catch (Throwable t) {
            throw new DeploymentTargetException(t);
        }
    }

    public void addAppReference(String appName, boolean enabled, String virtualServers) throws DeploymentTargetException {
        try {
            if (!ClusterHelper.clusterReferencesApplication((ConfigContext)this.configContext, (String)this.getName(), (String)appName)) {
                ApplicationReferenceHelper refHelper = new ApplicationReferenceHelper(this.configContext);
                refHelper.createApplicationReference(this.getValidTypes(), this.getName(), enabled, virtualServers, appName);
            }
        }
        catch (Throwable t) {
            throw new DeploymentTargetException(t);
        }
    }

    public void removeAppReference(String appName) throws DeploymentTargetException {
        try {
            ApplicationReferenceHelper refHelper = new ApplicationReferenceHelper(this.configContext);
            refHelper.deleteApplicationReference(this.getValidTypes(), this.getName(), appName);
        }
        catch (Throwable t) {
            throw new DeploymentTargetException(t);
        }
    }

    public boolean sendStartEvent(int eventType, String appName, String moduleType) throws DeploymentTargetException {
        return this.sendStartEvent(eventType, appName, moduleType, false);
    }

    public boolean sendStartEvent(int eventType, String appName, String moduleType, boolean isForced) throws DeploymentTargetException {
        try {
            boolean clusterResult = true;
            String[] svrRef = this.getServersInThisCluster();
            for (int i = 0; i < svrRef.length; ++i) {
                ServerDeploymentTarget sdTarget = new ServerDeploymentTarget(this.configContext, this.domainName, svrRef[i]);
                boolean serverResult = sdTarget.sendStartEvent(eventType, appName, moduleType, isForced);
                if (serverResult) continue;
                clusterResult = false;
            }
            return clusterResult;
        }
        catch (Throwable t) {
            throw new DeploymentTargetException(t);
        }
    }

    public boolean sendStopEvent(int eventType, String appName, String moduleType, boolean cascade) throws DeploymentTargetException {
        try {
            String[] svrRef = this.getServersInThisCluster();
            for (int i = 0; i < svrRef.length; ++i) {
                ServerDeploymentTarget sdTarget = new ServerDeploymentTarget(this.configContext, this.domainName, svrRef[i]);
                sdTarget.sendStopEvent(eventType, appName, moduleType, cascade);
            }
            return true;
        }
        catch (Throwable t) {
            throw new DeploymentTargetException(t);
        }
    }

    public boolean sendStopEvent(int eventType, String appName, String moduleType, boolean cascade, boolean force) throws DeploymentTargetException {
        try {
            String[] svrRef = this.getServersInThisCluster();
            for (int i = 0; i < svrRef.length; ++i) {
                ServerDeploymentTarget sdTarget = new ServerDeploymentTarget(this.configContext, this.domainName, svrRef[i]);
                sdTarget.sendStopEvent(eventType, appName, moduleType, cascade, force);
            }
            return true;
        }
        catch (Throwable t) {
            throw new DeploymentTargetException(t);
        }
    }

    public Target getTarget() {
        return this;
    }

    private String[] getServersInThisCluster() throws ConfigException {
        Server[] servers = super.getServers();
        int size = servers.length;
        String[] result = new String[size];
        for (int i = 0; i < size; ++i) {
            result[i] = servers[i].getName();
        }
        return result;
    }

    private String[] getAppsDeployedToCluster() throws ConfigException {
        ApplicationRef[] apprefs = super.getApplicationRefs();
        String[] appList = new String[apprefs.length];
        for (int i = 0; i < apprefs.length; ++i) {
            appList[i] = apprefs[i].getRef();
        }
        return appList;
    }

    public String getName() {
        return this.thisTargetName;
    }

    public String getDescription() {
        return localStrings.getString("enterprise.deployment.phasing.deploymenttarget.cluster.description", (Object)this.thisTargetName);
    }
}

