/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.demos;

import com.sun.enterprise.ee.cms.core.ActionFactory;
import com.sun.enterprise.ee.cms.core.GMSFactory;
import com.sun.enterprise.ee.cms.core.GroupHandle;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.demos.FailureNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.demos.FailureRecoveryActionFactoryImpl;
import com.sun.enterprise.ee.cms.demos.MessageActionFactoryImpl;
import java.util.Collection;
import java.util.Vector;

public class ApplicationServer {
    private Vector actionFactories = new Vector();
    private GroupManagementService gms = null;

    public ApplicationServer(String serverName) {
        this.gms = (GroupManagementService)((Object)GMSFactory.getGMSModule(serverName));
    }

    public void registerActionFactory(ActionFactory actionFactory) {
        this.actionFactories.add(actionFactory);
        this.gms.addActionFactory(actionFactory);
    }

    public void registerActionFactories(Collection actionFactories) {
        actionFactories.addAll(actionFactories);
        this.gms.addActionFactories(actionFactories);
    }

    public void startGMS() {
        Thread gservice = new Thread((Runnable)((Object)this.gms));
        gservice.start();
        this.gms.startup();
        try {
            gservice.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void stopGMS() {
        this.gms.shutdown();
    }

    public void sendMessage(String message) {
        GroupHandle gh = this.gms.getGroupHandle();
        gh.sendMessage(message.getBytes());
    }

    public static void main(String[] args) {
        ApplicationServer as = new ApplicationServer(args[0]);
        as.registerActionFactory(new FailureRecoveryActionFactoryImpl());
        as.registerActionFactory(new FailureNotificationActionFactoryImpl());
        as.registerActionFactory(new MessageActionFactoryImpl());
        as.startGMS();
        try {
            Thread.sleep(20000L);
            System.out.println("Sending message");
            as.sendMessage("This is " + args[0]);
            Thread.sleep(120000L);
            System.out.println("Stopping GMS");
            as.stopGMS();
            System.exit(0);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

