/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.core;

import com.sun.enterprise.ee.cms.core.FailureNotificationSignalImpl;
import com.sun.enterprise.ee.cms.core.GMSContextFactory;
import com.sun.enterprise.ee.cms.core.Signal;
import com.sun.enterprise.ee.cms.core.SignalPacket;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jgroups.Address;
import org.jgroups.View;
import org.jgroups.stack.IpAddress;

public class ViewWindow {
    private int size = 20;
    private Vector views = new Vector();
    private Vector signals = new Vector();
    private Vector gracefulShutdownList = new Vector();
    private Signal[] activeSignals;
    private Logger logger = GMSLogDomain.getLogger((String)"javax.ee.enterprise.system.gms");

    public void setSize(int s) {
        this.size = s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void newViewObserved(View v) {
        Vector vector = this.views;
        synchronized (vector) {
            this.views.addElement(v.clone());
            while (this.views.size() > this.size) {
                this.views.removeElementAt(0);
            }
            this.activeSignals = this.analyzeViewChange(this.views);
            if (this.activeSignals.length != 0) {
                GMSContextFactory.getGMSContext().getRouter().queueSignals(new SignalPacket(this.activeSignals));
            }
        }
    }

    private Signal[] analyzeViewChange(Vector vs) {
        this.signals.removeAllElements();
        this.logNewMemberJoins(vs);
        this.addFailureSignals(vs);
        Signal[] s = new Signal[]{};
        return this.signals.toArray(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFailureSignals(Vector vs) {
        if (vs.size() < 2) {
            return;
        }
        if (this.getViewSizeDiff(vs) > 0) {
            Iterator oldMembership = ((View)vs.elementAt(vs.size() - 2)).getMembers().iterator();
            Vector newMembers = ((View)vs.elementAt(vs.size() - 1)).getMembers();
            while (oldMembership.hasNext()) {
                Address address = (Address)oldMembership.next();
                if (newMembers.contains(address)) continue;
                if (!this.isGracefulShutdown(address)) {
                    if (GMSContextFactory.getGMSContext().getRouter().isFailureNotificationAFRegistered()) {
                        this.signals.addElement(new FailureNotificationSignalImpl(address));
                    }
                    this.logger.log(Level.FINE, "gms.failureEventReceived", this.constructMemberIdentity((IpAddress)address));
                    continue;
                }
                Vector vector = this.gracefulShutdownList;
                synchronized (vector) {
                    this.gracefulShutdownList.remove(address);
                }
            }
        }
    }

    private void logNewMemberJoins(Vector vs) {
        if (vs.size() < 2) {
            return;
        }
        if (this.getViewSizeDiff(vs) < 0) {
            Iterator newMembership = ((View)vs.elementAt(vs.size() - 1)).getMembers().iterator();
            Vector oldMembers = ((View)vs.elementAt(vs.size() - 2)).getMembers();
            while (newMembership.hasNext()) {
                Address address = (Address)newMembership.next();
                if (oldMembers.contains(address)) continue;
                this.logger.log(Level.FINER, "gms.newMemberAdded", this.constructMemberIdentity((IpAddress)address));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleGracefulShutdown(Address member) {
        Vector vector = this.gracefulShutdownList;
        synchronized (vector) {
            this.gracefulShutdownList.add(member);
        }
    }

    private boolean isGracefulShutdown(Address address) {
        return this.gracefulShutdownList.contains(address);
    }

    private String constructMemberIdentity(IpAddress address) {
        StringBuffer sb = new StringBuffer();
        sb.append(address.getIpAddress().getHostName());
        sb.append(":" + address.getPort());
        sb.append("(Member ID:" + new String(address.getAdditionalData()) + ")");
        return sb.toString();
    }

    private int getViewSizeDiff(Vector vs) {
        return ((View)vs.elementAt(vs.size() - 2)).size() - ((View)vs.elementAt(vs.size() - 1)).size();
    }

    Vector getPreviousView() {
        return ((View)this.views.elementAt(this.views.size() - 2)).getMembers();
    }

    Vector getCurrentView() {
        return ((View)this.views.elementAt(this.views.size() - 1)).getMembers();
    }
}

