/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.core;

import com.sun.enterprise.ee.cms.core.FailureNotificationSignal;
import com.sun.enterprise.ee.cms.core.FailureRecoverySignal;
import com.sun.enterprise.ee.cms.core.GMSContextFactory;
import com.sun.enterprise.ee.cms.core.MessageSignal;
import com.sun.enterprise.ee.cms.core.QueueHelper;
import com.sun.enterprise.ee.cms.core.Router;
import com.sun.enterprise.ee.cms.core.Signal;
import com.sun.enterprise.ee.cms.core.SignalPacket;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import java.util.logging.Logger;

public class SignalHandler
implements Runnable {
    QueueHelper qh;
    Logger logger = GMSLogDomain.getLogger((String)"javax.ee.enterprise.system.gms");

    public SignalHandler(QueueHelper qh) {
        this.qh = qh;
    }

    public void run() {
        while (true) {
            SignalPacket signalPacket;
            Signal[] signals;
            if ((signals = (signalPacket = this.qh.take()).getSignals()) != null) {
                this.handleSignals(signals);
                continue;
            }
            this.handleSignal(signalPacket.getSignal());
        }
    }

    private void handleSignal(Signal signal) {
        this.analyzeSignal(signal);
    }

    private void handleSignals(Signal[] signals) {
        for (int i = 0; i < signals.length; ++i) {
            this.analyzeSignal(signals[i]);
        }
    }

    private void analyzeSignal(Signal signal) {
        if (signal instanceof FailureRecoverySignal) {
            this.getRouter().notifyFailureRecoveryAction(signal);
        } else if (signal instanceof FailureNotificationSignal) {
            this.getRouter().notifyFailureNotificationAction(signal);
        } else if (signal instanceof MessageSignal) {
            this.getRouter().notifyMessageAction(signal);
        }
    }

    private Router getRouter() {
        return GMSContextFactory.getGMSContext().getRouter();
    }
}

