/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.core;

import com.sun.enterprise.ee.cms.core.SignalPacket;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import java.util.logging.Level;
import java.util.logging.Logger;

public class QueueHelper {
    SignalPacket[] signals;
    int putPtr = 0;
    int takePtr = 0;
    int usedSlots = 0;
    private Logger logger = GMSLogDomain.getLogger((String)"javax.ee.enterprise.system.gms");

    public QueueHelper() {
        this.setBufferSize(6);
    }

    void setBufferSize(int bufsize) {
        int bsize = bufsize >= 0 ? bufsize : 5;
        this.signals = new SignalPacket[bsize];
    }

    synchronized void put(SignalPacket signalPacket) {
        while (this.usedSlots == this.signals.length) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                this.logger.log(Level.FINEST, e.getLocalizedMessage());
            }
        }
        this.signals[this.putPtr] = signalPacket;
        this.putPtr = (this.putPtr + 1) % this.signals.length;
        if (this.usedSlots++ == 0) {
            this.notifyAll();
        }
    }

    synchronized SignalPacket take() {
        while (this.usedSlots == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                this.logger.log(Level.FINEST, e.getLocalizedMessage());
            }
        }
        SignalPacket signal = this.signals[this.takePtr];
        this.signals[this.takePtr] = null;
        this.takePtr = (this.takePtr + 1) % this.signals.length;
        if (this.usedSlots-- == this.signals.length) {
            this.notifyAll();
        }
        return signal;
    }
}

