/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.core;

import com.sun.enterprise.ee.cms.core.FailureNotificationSignal;
import com.sun.enterprise.ee.cms.core.GMSContextFactory;
import com.sun.enterprise.ee.cms.core.SignalAcquireException;
import com.sun.enterprise.ee.cms.core.SignalReleaseException;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jgroups.Address;
import org.jgroups.stack.IpAddress;

public class FailureNotificationSignalImpl
implements FailureNotificationSignal {
    Address failedMember = null;
    protected static final String LOGGER_NAME = "ConsoleLogger";
    protected static final Logger logger = GMSLogDomain.getLogger((String)"javax.ee.enterprise.system.gms");

    FailureNotificationSignalImpl() {
    }

    FailureNotificationSignalImpl(Address failedMember) {
        this.failedMember = failedMember;
    }

    FailureNotificationSignalImpl(FailureNotificationSignalImpl signal) {
        this.setFailedMemberAddress((Address)signal.getFailedMemberAddress());
    }

    protected void setFailedMemberAddress(Address failedMember) {
        this.failedMember = failedMember;
    }

    public String getFailedMemberToken() {
        return new String(((IpAddress)this.failedMember).getAdditionalData());
    }

    IpAddress getFailedMemberAddress() {
        return (IpAddress)this.failedMember;
    }

    public void acquire() throws SignalAcquireException {
        Vector currView = GMSContextFactory.getGMSContext().getViewWindow().getCurrentView();
        Iterator it = currView.iterator();
        while (it.hasNext()) {
            String memToken = new String(((IpAddress)it.next()).getAdditionalData());
            if (!memToken.equals(this.getFailedMemberToken())) continue;
            logger.log(Level.SEVERE, "gms.memberInView", memToken);
            throw new SignalAcquireException("Failed Member:" + this.getFailedMemberToken() + " has joined group again");
        }
        logger.log(Level.FINE, "FailureNotificationSignal Acquired...");
    }

    public void release() throws SignalReleaseException {
        this.failedMember = null;
        logger.log(Level.FINE, "FailureNotificationSignal Released...");
    }
}

