/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.proxy;

import com.sun.enterprise.admin.servermgmt.InstanceException;
import com.sun.enterprise.ee.admin.clientreg.InstanceRegistry;
import com.sun.enterprise.ee.admin.mbeanapi.ServerRuntimeMBean;
import com.sun.enterprise.ee.admin.proxy.BaseProxy;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class InstanceProxy
extends BaseProxy
implements InvocationHandler {
    private static Logger _logger = null;
    private static String _defaultDomain = null;
    private ObjectName _objectName = null;
    private MBeanServerConnection _connection = null;
    private String _instanceName;

    private InstanceProxy(String instanceName) {
        this._instanceName = instanceName;
    }

    private String getInstanceName() {
        return this._instanceName;
    }

    private static Logger getLogger() {
        if (_logger == null) {
            _logger = Logger.getLogger("javax.ee.enterprise.system.tools.admin");
        }
        return _logger;
    }

    public static ServerRuntimeMBean getInstanceProxy(String instanceName) {
        return (ServerRuntimeMBean)Proxy.newProxyInstance(ServerRuntimeMBean.class.getClassLoader(), new Class[]{ServerRuntimeMBean.class}, (InvocationHandler)new InstanceProxy(instanceName));
    }

    private MBeanServerConnection getConnection() throws InstanceException {
        if (this._connection == null) {
            this._connection = InstanceRegistry.getInstanceConnection(this.getInstanceName());
        }
        return this._connection;
    }

    private ObjectName getObjectName() throws IOException, MalformedObjectNameException, InstanceException {
        if (this._objectName == null) {
            if (_defaultDomain == null) {
                _defaultDomain = InstanceProxy.getDefaultDomain();
            }
            this._objectName = new ObjectName(_defaultDomain + ":j2eeType=J2EEServer,name=" + this.getInstanceName() + ",category=runtime");
        }
        return this._objectName;
    }

    private Exception mangleInvokeException(Exception ex) {
        Throwable result = null;
        if (ex instanceof MBeanException) {
            Throwable t = ex.getCause();
            if (t != null && t instanceof Exception) {
                ex = (Exception)t;
            }
            result = ex;
        }
        result = ex instanceof InstanceException ? ex : new InstanceException((Throwable)ex);
        if (InstanceProxy.isUnreachable(ex)) {
            try {
                InstanceRegistry.disconnectInstanceConnection(this.getInstanceName());
            }
            catch (Exception ex2) {
                InstanceProxy.getLogger().log(Level.WARNING, "server.proxy.exception", ex2);
            }
        }
        return result;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        InstanceProxy.getLogger().log(Level.FINEST, "InstanceProxy:invoke " + methodName);
        try {
            return this.getConnection().invoke(this.getObjectName(), methodName, args, InstanceProxy.getParameterTypes(method.getParameterTypes()));
        }
        catch (Exception ex) {
            ex = this.mangleInvokeException(ex);
            if (!InstanceProxy.isUnreachable(ex)) {
                InstanceProxy.getLogger().log(Level.FINE, "server.proxy.exception", ex);
            } else {
                InstanceProxy.getLogger().log(Level.FINE, "server.proxy.cannotConnect", this.getInstanceName());
            }
            throw ex;
        }
    }
}

