/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.proxy;

import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.admin.servermgmt.InstanceException;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.ee.admin.clientreg.InstanceRegistry;
import com.sun.enterprise.ee.admin.proxy.BaseProxy;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class DASProxy
extends BaseProxy
implements InvocationHandler {
    private static Logger _logger = null;
    private ObjectName _objectName = null;
    private MBeanServerConnection _connection = null;

    private static Logger getLogger() {
        if (_logger == null) {
            _logger = Logger.getLogger("javax.ee.enterprise.system.tools.admin");
        }
        return _logger;
    }

    public static Object getDASProxy(Class theInterface, ObjectName objName) {
        return Proxy.newProxyInstance(theInterface.getClassLoader(), new Class[]{theInterface}, (InvocationHandler)new DASProxy(objName));
    }

    private DASProxy(ObjectName objName) {
        this._objectName = objName;
    }

    private ConfigContext getConfigContext() {
        return AdminService.getAdminService().getAdminContext().getAdminConfigContext();
    }

    private MBeanServerConnection getConnection() throws InstanceException {
        if (this._connection == null) {
            this._connection = InstanceRegistry.getDASConnection(this.getConfigContext());
        }
        return this._connection;
    }

    private ObjectName getObjectName() {
        return this._objectName;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        DASProxy.getLogger().log(Level.FINEST, "DASProxy:invoke " + methodName);
        try {
            return this.getConnection().invoke(this.getObjectName(), methodName, args, DASProxy.getParameterTypes(method.getParameterTypes()));
        }
        catch (Exception ex) {
            if (!DASProxy.isUnreachable(ex)) {
                DASProxy.getLogger().log(Level.FINE, "das.proxy.exception", ex);
            } else {
                DASProxy.getLogger().log(Level.FINE, "das.proxy.cannotConnect", this.getObjectName());
            }
            throw ex;
        }
    }
}

