/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.mbeans;

import com.sun.enterprise.admin.servermgmt.InstanceException;
import com.sun.enterprise.admin.servermgmt.RuntimeStatus;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.ee.admin.ExceptionHandler;
import com.sun.enterprise.ee.admin.mbeans.ServerAndClusterBaseMBean;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.logging.Logger;

public class ServerConfigMBean
extends ServerAndClusterBaseMBean
implements com.sun.enterprise.ee.admin.mbeanapi.ServerConfigMBean {
    private static final StringManager _strMgr = StringManager.getManager((Class)ServerConfigMBean.class);
    private static Logger _logger = null;
    private static ExceptionHandler _handler = null;

    protected static Logger getLogger() {
        if (_logger == null) {
            _logger = Logger.getLogger("javax.ee.enterprise.system.tools.admin");
        }
        return _logger;
    }

    protected static ExceptionHandler getExceptionHandler() {
        if (_handler == null) {
            _handler = new ExceptionHandler(ServerConfigMBean.getLogger());
        }
        return _handler;
    }

    protected String getLogMessageId() {
        return "eeadmin.ServerConfigMBean.Exception";
    }

    public RuntimeStatus getRuntimeStatus() throws InstanceException {
        return this.getServersConfigBean().getRuntimeStatus(this.getName());
    }

    public void clearRuntimeStatus() throws InstanceException {
        this.getServersConfigBean().clearRuntimeStatus(this.getName());
    }

    public void start() throws InstanceException {
        this.getServersConfigBean().startServerInstance(this.getName());
    }

    public void stop() throws InstanceException {
        this.getServersConfigBean().stopServerInstance(this.getName());
    }

    public void delete() throws InstanceException {
        this.getServersConfigBean().deleteServerInstance(this.getName());
    }

    public boolean isStandAlone() throws InstanceException {
        String serverName = this.getName();
        try {
            return ServerHelper.isServerStandAlone((ConfigContext)this.getConfigContext(), (String)serverName);
        }
        catch (Exception ex) {
            throw ServerConfigMBean.getExceptionHandler().handleInstanceException(ex, this.getLogMessageId(), serverName);
        }
    }

    public boolean isClustered() throws InstanceException {
        String serverName = this.getName();
        try {
            return ServerHelper.isServerClustered((ConfigContext)this.getConfigContext(), (String)serverName);
        }
        catch (Exception ex) {
            throw ServerConfigMBean.getExceptionHandler().handleInstanceException(ex, this.getLogMessageId(), serverName);
        }
    }

    public boolean isDAS() throws InstanceException {
        String serverName = this.getName();
        try {
            return ServerHelper.isDAS((ConfigContext)this.getConfigContext(), (String)serverName);
        }
        catch (Exception ex) {
            throw ServerConfigMBean.getExceptionHandler().handleInstanceException(ex, this.getLogMessageId(), serverName);
        }
    }
}

