/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.mbeans;

import com.sun.enterprise.admin.mbeans.ResourcesMBean;
import com.sun.enterprise.admin.target.ClusterTarget;
import com.sun.enterprise.admin.target.ServerTarget;
import com.sun.enterprise.admin.target.Target;
import com.sun.enterprise.admin.target.TargetBuilder;
import com.sun.enterprise.admin.target.TargetType;
import com.sun.enterprise.admin.util.IAdminConstants;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.ee.admin.ExceptionHandler;
import com.sun.enterprise.ee.admin.configbeans.ResourcesConfigBean;
import com.sun.enterprise.ee.admin.mbeans.ResourceAndRefMatcher;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.ObjectName;

public class ResourcesConfigMBean
extends ResourcesMBean
implements com.sun.enterprise.ee.admin.mbeanapi.ResourcesConfigMBean,
IAdminConstants {
    private static final TargetType[] VALID_LIST_TYPES;
    private static final StringManager _strMgr;
    private static Logger _logger;
    private static ExceptionHandler _handler;
    private static final TargetType[] VALID_LIST_REFS_TARGETS;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static Logger getLogger() {
        if (_logger == null) {
            _logger = Logger.getLogger("javax.ee.enterprise.system.tools.admin");
        }
        return _logger;
    }

    protected static ExceptionHandler getExceptionHandler() {
        if (_handler == null) {
            _handler = new ExceptionHandler(ResourcesConfigMBean.getLogger());
        }
        return _handler;
    }

    public void createResourceReference(String targetName, boolean enabled, String referenceName) throws ConfigException {
        this.getResourcesConfigBean().createResourceReference(targetName, enabled, referenceName);
    }

    public void deleteResourceReference(String targetName, String referenceName) throws ConfigException {
        this.getResourcesConfigBean().deleteResourceReference(targetName, referenceName);
    }

    public String[] listResourceReferencesAsString(String targetName) throws ConfigException {
        return this.getResourcesConfigBean().listResourceReferencesAsString(targetName);
    }

    public ObjectName[] listReferencees(String resourceRef) throws ConfigException {
        ObjectName[] referencees = new ObjectName[]{};
        try {
            Cluster[] clusters;
            ConfigContext ctx = this.getConfigContext();
            ArrayList<ObjectName> objectNames = new ArrayList<ObjectName>();
            Server[] servers = ServerHelper.getServersReferencingResource((ConfigContext)ctx, (String)resourceRef);
            if (servers != null) {
                for (int i = 0; i < servers.length; ++i) {
                    String name = servers[i].getName();
                    if (ServerHelper.isServerClustered((ConfigContext)ctx, (String)name)) continue;
                    objectNames.add(this.getServerObjectName(name));
                }
            }
            if ((clusters = ClusterHelper.getClustersReferencingResource((ConfigContext)ctx, (String)resourceRef)) != null) {
                for (int i = 0; i < clusters.length; ++i) {
                    String name = clusters[i].getName();
                    objectNames.add(this.getClusterObjectName(name));
                }
            }
            referencees = objectNames.toArray(new ObjectName[0]);
        }
        catch (Exception ex) {
            throw ResourcesConfigMBean.getExceptionHandler().handleConfigException(ex, "eeadmin.listResourceReferences.Exception", resourceRef);
        }
        return referencees;
    }

    private ResourcesConfigBean getResourcesConfigBean() {
        return new ResourcesConfigBean(this.getConfigContext());
    }

    public String getResourceType(String id) throws ConfigException {
        return this.getResourcesConfigBean().getResourceType(id);
    }

    public ObjectName[] getJmsConnectionFactoryRefs(String targetName) throws ConfigException, JMException, Exception {
        ObjectName[] jmsConnectionFactoryRefs = new ObjectName[]{};
        ObjectName targetON = this.getTargetObjectName(this.getListRefsTarget(targetName));
        if (!$assertionsDisabled && targetON == null) {
            throw new AssertionError();
        }
        ObjectName[] refs = this.listResourceRefs(targetON, ServerTags.CONNECTOR_RESOURCE);
        if (refs.length > 0) {
            ObjectName[] oaCF = super.getJmsConnectionFactory(targetName);
            if (!($assertionsDisabled || oaCF != null && oaCF.length > 0)) {
                throw new AssertionError();
            }
            jmsConnectionFactoryRefs = ResourceAndRefMatcher.instance.matchingRefs(oaCF, refs);
        }
        return jmsConnectionFactoryRefs;
    }

    public ObjectName[] getJmsDestinationResourceRefs(String targetName) throws ConfigException, JMException, Exception {
        ObjectName[] jmsDestinationRefs = new ObjectName[]{};
        ObjectName targetON = this.getTargetObjectName(this.getListRefsTarget(targetName));
        if (!$assertionsDisabled && targetON == null) {
            throw new AssertionError();
        }
        ObjectName[] refs = this.listResourceRefs(targetON, ServerTags.ADMIN_OBJECT_RESOURCE);
        if (refs.length > 0) {
            ObjectName[] oaCF = super.getJmsDestinationResource(targetName);
            if (!($assertionsDisabled || oaCF != null && oaCF.length > 0)) {
                throw new AssertionError();
            }
            jmsDestinationRefs = ResourceAndRefMatcher.instance.matchingRefs(oaCF, refs);
        }
        return jmsDestinationRefs;
    }

    Target getListRefsTarget(String targetName) throws ConfigException {
        Target target = TargetBuilder.INSTANCE.createTarget(VALID_LIST_REFS_TARGETS, targetName, this.getConfigContext());
        return target;
    }

    ObjectName getTargetObjectName(Target target) throws MBeanException {
        ObjectName targetON = null;
        if (target instanceof ServerTarget) {
            targetON = this.getServerObjectName(target.getName());
        } else if (target instanceof ClusterTarget) {
            targetON = this.getClusterObjectName(target.getName());
        }
        return targetON;
    }

    ObjectName[] listResourceRefs(ObjectName target, String type) throws JMException {
        return (ObjectName[])this.getMBeanServer().invoke(target, "listResourceRefsByType", new Object[]{type}, new String[]{"java.lang.String"});
    }

    static {
        $assertionsDisabled = !ResourcesConfigMBean.class.desiredAssertionStatus();
        VALID_LIST_TYPES = new TargetType[]{TargetType.CLUSTER, TargetType.SERVER, TargetType.DAS};
        _strMgr = StringManager.getManager((Class)ResourcesConfigMBean.class);
        _logger = null;
        _handler = null;
        VALID_LIST_REFS_TARGETS = new TargetType[]{TargetType.CLUSTER, TargetType.SERVER, TargetType.DAS};
    }
}

