/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.mbeans;

import com.sun.enterprise.admin.servermgmt.RuntimeStatus;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.ee.admin.ExceptionHandler;
import com.sun.enterprise.ee.admin.mbeanapi.NodeAgentMBean;
import com.sun.enterprise.ee.admin.mbeans.EEBaseConfigMBean;
import com.sun.enterprise.ee.admin.proxy.NodeAgentProxy;
import com.sun.enterprise.ee.admin.servermgmt.AgentException;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class NodeAgentConfigMBean
extends EEBaseConfigMBean
implements com.sun.enterprise.ee.admin.mbeanapi.NodeAgentConfigMBean {
    private static final StringManager _strMgr = StringManager.getManager((Class)NodeAgentConfigMBean.class);
    private static Logger _logger = null;
    private static ExceptionHandler _handler = null;

    protected static Logger getLogger() {
        if (_logger == null) {
            _logger = Logger.getLogger("javax.ee.enterprise.system.tools.admin");
        }
        return _logger;
    }

    protected static ExceptionHandler getExceptionHandler() {
        if (_handler == null) {
            _handler = new ExceptionHandler(NodeAgentConfigMBean.getLogger());
        }
        return _handler;
    }

    private String getNodeAgentName() throws AgentException {
        try {
            return (String)this.getAttribute(ServerTags.NAME);
        }
        catch (Exception ex) {
            throw NodeAgentConfigMBean.getExceptionHandler().handleAgentException(ex, "nodeagent.NodeAgentConfigMBean.Exception", "unknown");
        }
    }

    public RuntimeStatus getRuntimeStatus() throws AgentException {
        return this.getNodeAgentsConfigBean().getRuntimeStatus(this.getNodeAgentName());
    }

    public void clearRuntimeStatus() throws AgentException {
        this.getNodeAgentsConfigBean().clearRuntimeStatus(this.getNodeAgentName());
    }

    public void delete() throws AgentException {
        this.getNodeAgentsConfigBean().deleteNodeAgentConfig(this.getNodeAgentName());
    }

    public String[] listServerInstancesAsString(boolean andStatus) throws AgentException {
        String agentName = this.getNodeAgentName();
        try {
            return this.getServersConfigBean().listServerInstancesAsString(agentName, andStatus);
        }
        catch (Exception ex) {
            throw NodeAgentConfigMBean.getExceptionHandler().handleAgentException(ex, "nodeagent.listInstances.Exception", agentName);
        }
    }

    public ObjectName[] listServerInstances() throws AgentException, MBeanException {
        return this.toServerONArray(this.listServerInstancesAsString(false));
    }

    public AttributeList setAttributes(AttributeList list) {
        list = super.setAttributes(list);
        this.informNodeAgent();
        return list;
    }

    public void setAttribute(Attribute attr) throws AttributeNotFoundException, MBeanException, ReflectionException {
        super.setAttribute(attr);
        this.informNodeAgent();
    }

    private void informNodeAgent() {
        String agentName = null;
        try {
            agentName = this.getNodeAgentName();
            this.flushAll();
            NodeAgentMBean agentMBean = NodeAgentProxy.getNodeAgentProxy(agentName);
            agentMBean.synchronizeWithDAS();
        }
        catch (ConfigException ce) {
            NodeAgentConfigMBean.getLogger().log(Level.WARNING, "eeadmin.nodeagentconfig.flush_failed");
        }
        catch (AgentException ae) {
            NodeAgentConfigMBean.getLogger().log(Level.WARNING, "eeadmin.nodeagentconfig.agent_exp", agentName);
        }
        catch (MBeanException mbe) {
            NodeAgentConfigMBean.getLogger().log(Level.WARNING, "eeadmin.nodeagentconfig.mbean_exp", mbe);
        }
    }
}

