/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.mbeans;

import com.sun.enterprise.ee.admin.hadbmgmt.HADBConfigureCluster;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBConfigurePersistence;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBConfigurePersistenceInfo;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBCreateDBInfo;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBCreateSchema;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBInfo;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBRemoveCluster;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBRemoveClusterInfo;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBSetupException;
import com.sun.enterprise.ee.admin.mbeans.EEBaseConfigMBean;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HadbConfigMBean
extends EEBaseConfigMBean
implements com.sun.enterprise.ee.admin.mbeanapi.HadbConfigMBean {
    private static final StringManager STR_MGR = StringManager.getManager((Class)HadbConfigMBean.class);
    private static Logger logger;

    private Logger getLogger() {
        if (logger == null) {
            logger = Logger.getLogger("javax.ee.enterprise.system.tools.admin");
        }
        return logger;
    }

    public Object[] createHACluster(String hosts, String agentPort, String haAdminPassword, String haAdminPasswordFile, String deviceSize, String remotePackagePath, String clusterName, Properties props) throws HADBSetupException {
        HADBInfo info = null;
        try {
            this.getLogger().log(Level.INFO, "HADBConfigMBean.createHACluster() called with hosts=" + hosts + " , clusterName=" + clusterName);
            info = new HADBCreateDBInfo(hosts, agentPort, haAdminPassword, haAdminPasswordFile, remotePackagePath, clusterName, this.getLogger(), this.getConfigContext(), this.getMBeanServer());
            info.setup();
            ((HADBCreateDBInfo)info).setDeviceSize(deviceSize);
            ((HADBCreateDBInfo)info).setProperties(props);
            HADBConfigureCluster hcc = new HADBConfigureCluster((HADBCreateDBInfo)info);
            Object[] objectArray = hcc.configure();
            return objectArray;
        }
        catch (HADBSetupException hse) {
            throw hse;
        }
        catch (Exception e) {
            throw new HADBSetupException(e);
        }
        finally {
            if (info != null) {
                info.cleanup();
            }
        }
    }

    public Object[] deleteHACluster(String hosts, String agentPort, String haAdminPassword, String haAdminPasswordFile, String clusterName) throws HADBSetupException {
        HADBInfo info = null;
        try {
            this.getLogger().log(Level.INFO, "HADBConfigMBean.deleteHACluster() called with cluster = " + clusterName);
            info = new HADBRemoveClusterInfo(hosts, agentPort, haAdminPassword, haAdminPasswordFile, clusterName, this.getLogger(), this.getConfigContext(), this.getMBeanServer());
            info.setup();
            HADBRemoveCluster rc = new HADBRemoveCluster(info);
            Object[] objectArray = rc.remove();
            return objectArray;
        }
        catch (HADBSetupException hse) {
            throw hse;
        }
        catch (Exception e) {
            throw new HADBSetupException(e);
        }
        finally {
            if (info != null) {
                info.cleanup();
            }
        }
    }

    public Object[] createHASchema(String hosts, String agentPort, String haAdminPassword, String haAdminPasswordFile, String storeuser, String storepassword, String dbsystempassword, String databaseName) throws HADBSetupException {
        HADBInfo info = null;
        try {
            this.getLogger().log(Level.INFO, "HADBConfigMBean.createHASchema() called with: hosts = " + hosts + ", agentPort = " + agentPort + ", storeuser = " + storeuser + ", storepassword = " + storepassword + ", dbsystempassword = " + dbsystempassword + ", databaseName = " + databaseName);
            info = new HADBCreateDBInfo(hosts, agentPort, haAdminPassword, haAdminPasswordFile, null, databaseName, this.getLogger(), this.getConfigContext(), this.getMBeanServer());
            info.setDatabaseUser(storeuser);
            info.setDatabasePassword(storepassword);
            info.setSystemPassword(dbsystempassword);
            info.setup();
            HADBCreateSchema creator = new HADBCreateSchema(info);
            Object[] objectArray = creator.create();
            return objectArray;
        }
        catch (HADBSetupException hse) {
            throw hse;
        }
        catch (Exception e) {
            throw new HADBSetupException(e);
        }
        finally {
            if (info != null) {
                info.cleanup();
            }
        }
    }

    public Object[] clearHASchema(String hosts, String agentPort, String haAdminPassword, String haAdminPasswordFile, String storeuser, String storepassword, String dbsystempassword, String databaseName) throws HADBSetupException {
        HADBInfo info = null;
        try {
            this.getLogger().log(Level.INFO, "HADBConfigMBean.clearHASchema() called with: hosts = " + hosts + ", agentPort = " + agentPort + ", storeuser = " + storeuser + ", storepassword = " + storepassword + ", dbsystempassword = " + dbsystempassword + ", databaseName = " + databaseName);
            info = new HADBCreateDBInfo(hosts, agentPort, haAdminPassword, haAdminPasswordFile, null, databaseName, this.getLogger(), this.getConfigContext(), this.getMBeanServer());
            info.setDatabaseUser(storeuser);
            info.setDatabasePassword(storepassword);
            info.setSystemPassword(dbsystempassword);
            info.setup();
            HADBCreateSchema creator = new HADBCreateSchema(info);
            Object[] objectArray = creator.clear();
            return objectArray;
        }
        catch (HADBSetupException hse) {
            throw hse;
        }
        catch (Exception e) {
            throw new HADBSetupException(e);
        }
        finally {
            if (info != null) {
                info.cleanup();
            }
        }
    }

    public Object[] configureHAPersistence(String type, String frequency, String scope, String store, Properties props, String clusterName) throws HADBSetupException {
        try {
            this.getLogger().log(Level.INFO, "HADBConfigMBean.configureHAPersistence() called with type = " + type + ", frequency = " + frequency + ", scope = " + scope + ", store = " + store + ", clusterName = " + clusterName + ", props = " + props);
            HADBConfigurePersistenceInfo info = new HADBConfigurePersistenceInfo(clusterName, this.getLogger(), this.getConfigContext(), this.getMBeanServer(), type, frequency, scope, store, props);
            info.setup();
            HADBConfigurePersistence worker = new HADBConfigurePersistence(info);
            return worker.commit();
        }
        catch (HADBSetupException hse) {
            throw hse;
        }
        catch (Exception e) {
            throw new HADBSetupException(e);
        }
    }
}

