/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.mbeans;

import com.sun.enterprise.admin.common.Status;
import com.sun.enterprise.admin.event.AdminEvent;
import com.sun.enterprise.admin.event.AdminEventMulticaster;
import com.sun.enterprise.admin.event.AdminEventResult;
import com.sun.enterprise.admin.event.EjbTimerEvent;
import com.sun.enterprise.admin.servermgmt.InstanceException;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.ee.admin.mbeanapi.ServerRuntimeMBean;
import com.sun.enterprise.ee.admin.mbeans.EEBaseConfigMBean;
import com.sun.enterprise.ee.admin.proxy.InstanceProxy;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EJBTimerManagementMBean
extends EEBaseConfigMBean
implements com.sun.enterprise.ee.admin.mbeanapi.EJBTimerManagementMBean {
    private static final StringManager _strMgr = StringManager.getManager((Class)EJBTimerManagementMBean.class);
    private static Logger _logger;

    private Logger getLogger() {
        if (_logger == null) {
            _logger = Logger.getLogger("javax.ee.enterprise.system.tools.admin");
        }
        return _logger;
    }

    public void migrateTimers(String sourceServerName, String destServerName) throws InstanceException, ConfigException {
        this.fine("Entering migrate Timers");
        this.validateSourceServer(sourceServerName);
        if (destServerName == null || "".equals(destServerName)) {
            destServerName = this.getOneAliveSiblingServer(sourceServerName);
        } else {
            this.validateDestServer(sourceServerName, destServerName);
        }
        this.fine("Migrate Timers: Sending Notification for " + sourceServerName + " to " + destServerName);
        this.sendTimerMigrateEvent(sourceServerName, destServerName);
    }

    public String[] listTimers(String target) throws ConfigException, InstanceException {
        this.fine("Entering list Timers");
        String server = null;
        String[] allServers = null;
        if (this.isCluster(target)) {
            server = this.getOneAliveServer(target);
            allServers = this.getServersInCluster(target);
        } else if (this.isServer(target)) {
            this.assertServerAliveForListTimer(target);
            server = target;
            allServers = new String[]{target};
        } else {
            throw new ConfigException(_strMgr.getString("notAValidTargetForListTimers", (Object)target));
        }
        this.fine("List Timers: Sending Notification to " + server + " for :" + this.arrayToString(allServers));
        String[] resStr = this.sendListTimerEvent(server, allServers);
        this.fine("RESULT: " + resStr);
        String[] ret = null;
        if (resStr == null || resStr.length == 0) {
            ret = new String[]{"There are no Ejb Timers."};
        }
        if (resStr.length == allServers.length) {
            ret = new String[resStr.length];
            for (int i = 0; i < resStr.length; ++i) {
                ret[i] = allServers[i] + ": " + resStr[i];
            }
        }
        return ret;
    }

    private boolean isCluster(String target) throws ConfigException {
        return ClusterHelper.isACluster((ConfigContext)this.getConfigContext(), (String)target);
    }

    private boolean isServer(String target) throws ConfigException {
        return ServerHelper.isAServer((ConfigContext)this.getConfigContext(), (String)target);
    }

    private void assertServerAliveForListTimer(String server) throws ConfigException, InstanceException {
        if (!this.isServerRunning(server)) {
            throw new ConfigException(_strMgr.getString("serverNotAliveForTimerList", (Object)server));
        }
    }

    private boolean isServerRunning(String server) throws InstanceException {
        try {
            ServerRuntimeMBean serverMBean = InstanceProxy.getInstanceProxy(server);
            Status status = serverMBean.getRuntimeStatus().getStatus();
            if (status.getStatusCode() == 0) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean isServerDead(String server) throws InstanceException {
        try {
            ServerRuntimeMBean serverMBean = InstanceProxy.getInstanceProxy(server);
            Status status = serverMBean.getRuntimeStatus().getStatus();
            if (status.getStatusCode() == 3) {
                return true;
            }
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    private void assertSourceDead(String server) throws ConfigException, InstanceException {
        if (!this.isServerDead(server)) {
            throw new ConfigException(_strMgr.getString("sourceServerAliveForMigrateTimers", (Object)server));
        }
    }

    private void assertDestServerAlive(String server) throws ConfigException, InstanceException {
        if (!this.isServerRunning(server)) {
            throw new ConfigException(_strMgr.getString("destServerNotAliveForMigrateTimers", (Object)server));
        }
    }

    private void validateSourceServer(String server) throws ConfigException, InstanceException {
        this.assertSourceServerNotNull(server);
        this.assertSourceDead(server);
    }

    private void validateDestServer(String source, String dest) throws ConfigException, InstanceException {
        this.assertClusterMembership(source, dest);
        this.assertDestServerAlive(dest);
    }

    private String getOneAliveServer(String cluster) throws ConfigException, InstanceException {
        String[] servers = this.getServersInCluster(cluster);
        if (servers != null && servers.length > 0) {
            for (int i = 0; i < servers.length; ++i) {
                String name = servers[i];
                if (!this.isServerRunning(name)) continue;
                return name;
            }
        }
        throw new ConfigException(_strMgr.getString("noAliveServerInCluster", (Object)cluster));
    }

    private String[] getServersInCluster(String cluster) throws ConfigException {
        ConfigContext configContext = this.getConfigContext();
        Server[] servers = ServerHelper.getServersInCluster((ConfigContext)configContext, (String)cluster);
        if (servers == null) {
            return null;
        }
        String[] serverNames = new String[servers.length];
        for (int i = 0; i < servers.length; ++i) {
            serverNames[i] = servers[i].getName();
        }
        return serverNames;
    }

    private void assertSourceServerNotNull(String server) throws ConfigException {
        if (server == null || "".equals(server)) {
            throw new ConfigException(_strMgr.getString("sourceServerNull", (Object)server));
        }
    }

    private void assertNotSame(String server1, String server2) throws ConfigException {
        if (server1 != null && server1.equals(server2)) {
            throw new ConfigException(_strMgr.getString("sameSourceDest", (Object)server1, (Object)server2));
        }
    }

    private void assertClusterMembership(String server1, String server2) throws ConfigException {
        this.assertNotSame(server1, server2);
        ConfigContext configContext = this.getConfigContext();
        Cluster cluster1 = ClusterHelper.getClusterForInstance((ConfigContext)configContext, (String)server1);
        Cluster cluster2 = ClusterHelper.getClusterForInstance((ConfigContext)configContext, (String)server2);
        if (cluster1 == null || cluster2 == null || !cluster1.getName().equals(cluster2.getName())) {
            throw new ConfigException(_strMgr.getString("serversNotSiblings", (Object)server1, (Object)server2));
        }
    }

    private String getOneAliveSiblingServer(String sourceServerName) throws ConfigException, InstanceException {
        Cluster cluster1 = this.getClusterForInstance(sourceServerName);
        String[] servers = this.getServersInCluster(cluster1.getName());
        if (servers != null && servers.length > 0) {
            for (int i = 0; i < servers.length; ++i) {
                String name = servers[i];
                if (name.equals(sourceServerName) || !this.isServerRunning(name)) continue;
                return name;
            }
        }
        throw new ConfigException(_strMgr.getString("noAliveSibling", (Object)cluster1.getName(), (Object)sourceServerName));
    }

    private Cluster getClusterForInstance(String server) throws ConfigException {
        ConfigContext configContext = this.getConfigContext();
        return ClusterHelper.getClusterForInstance((ConfigContext)configContext, (String)server);
    }

    private void sendTimerMigrateEvent(String sourceServerName, String destServerName) throws InstanceException {
        EjbTimerEvent event = new EjbTimerEvent(destServerName, 1, sourceServerName, new String[]{destServerName});
        event.setTargetDestination(destServerName);
        this.forwardEvent((AdminEvent)event);
    }

    private String[] sendListTimerEvent(String server, String[] allServers) {
        EjbTimerEvent event = new EjbTimerEvent(server, 2, server, allServers);
        event.setTargetDestination(server);
        AdminEventResult res = this.forwardEvent((AdminEvent)event);
        return (String[])res.getAttribute(server, "ejb_timer_call_result");
    }

    private AdminEventResult forwardEvent(AdminEvent e) {
        AdminEventResult result = null;
        result = AdminEventMulticaster.multicastEvent((AdminEvent)e);
        return result;
    }

    private void fine(String s) {
        this.getLogger().log(Level.FINE, s);
    }

    private String arrayToString(String[] s) {
        if (s == null) {
            return null;
        }
        String res = "";
        for (int i = 0; i < s.length; ++i) {
            if (res != "") {
                res = res + ",";
            }
            res = res + s[i];
        }
        return res;
    }
}

