/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.mbeans;

import com.sun.enterprise.admin.mbeans.ConfigsMBean;
import com.sun.enterprise.admin.servermgmt.InstanceException;
import com.sun.enterprise.admin.util.IAdminConstants;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.ee.admin.ExceptionHandler;
import com.sun.enterprise.ee.admin.configbeans.ConfigsConfigBean;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Logger;
import javax.management.MBeanException;
import javax.management.ObjectName;

public class ConfigsConfigMBean
extends ConfigsMBean
implements IAdminConstants,
com.sun.enterprise.ee.admin.mbeanapi.ConfigsConfigMBean {
    public static final String DEFAULT_HTTP_LISTENER_ACCEPTOR_THREADS = "1";
    private static final StringManager _strMgr = StringManager.getManager((Class)ConfigsConfigMBean.class);
    private static Logger _logger = null;
    private static ExceptionHandler _handler = null;

    private static Logger getLogger() {
        if (_logger == null) {
            _logger = Logger.getLogger("javax.ee.enterprise.system.tools.admin");
        }
        return _logger;
    }

    protected static ExceptionHandler getExceptionHandler() {
        if (_handler == null) {
            _handler = new ExceptionHandler(ConfigsConfigMBean.getLogger());
        }
        return _handler;
    }

    private ConfigsConfigBean getConfigsConfigBean() {
        return new ConfigsConfigBean(this.getConfigContext());
    }

    public ObjectName copyConfiguration(String sourceConfigName, String newConfigName, Properties props) throws ConfigException, MBeanException {
        this.getConfigsConfigBean().copyConfiguration(sourceConfigName, newConfigName, props);
        return this.getConfigurationObjectName(newConfigName);
    }

    public void deleteConfiguration(String configName) throws ConfigException {
        this.getConfigsConfigBean().deleteConfiguration(configName);
    }

    public ObjectName[] listConfigurations(String targetName) throws ConfigException, MBeanException {
        return this.toConfigurationONArray(this.getConfigsConfigBean().listConfigurationsAsString(targetName));
    }

    public ObjectName[] listConfigurations(String targetName, boolean includeDAS) throws ConfigException, MBeanException {
        ObjectName[] configs = this.listConfigurations(targetName);
        try {
            if (!includeDAS) {
                ObjectName dasConfigPattern = new ObjectName("*:type=config,category=config,name=server-config");
                ArrayList<ObjectName> al = new ArrayList<ObjectName>();
                for (int i = 0; i < configs.length; ++i) {
                    if (dasConfigPattern.apply(configs[i])) continue;
                    al.add(configs[i]);
                }
                configs = al.toArray(new ObjectName[0]);
            }
        }
        catch (Exception ex) {
            throw ConfigsConfigMBean.getExceptionHandler().handleConfigException(ex, "eeadmin.listConfigurations.Exception", targetName);
        }
        return configs;
    }

    boolean getRuntimeStatus(String configName) throws InstanceException {
        return this.getConfigsConfigBean().getRuntimeStatus(configName);
    }

    protected String getDefaultHTTPListenerAcceptorThreads() {
        return DEFAULT_HTTP_LISTENER_ACCEPTOR_THREADS;
    }
}

