/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.mbeans;

import com.sun.enterprise.admin.servermgmt.InstanceException;
import com.sun.enterprise.admin.servermgmt.RuntimeStatusList;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.ee.admin.ExceptionHandler;
import com.sun.enterprise.ee.admin.mbeans.ServerAndClusterBaseMBean;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.logging.Logger;
import javax.management.MBeanException;
import javax.management.ObjectName;

public class ClusterConfigMBean
extends ServerAndClusterBaseMBean
implements com.sun.enterprise.ee.admin.mbeanapi.ClusterConfigMBean {
    private static final StringManager _strMgr = StringManager.getManager((Class)ClusterConfigMBean.class);
    private static Logger _logger = null;
    private static ExceptionHandler _handler = null;

    protected static Logger getLogger() {
        if (_logger == null) {
            _logger = Logger.getLogger("javax.ee.enterprise.system.tools.admin");
        }
        return _logger;
    }

    protected static ExceptionHandler getExceptionHandler() {
        if (_handler == null) {
            _handler = new ExceptionHandler(ClusterConfigMBean.getLogger());
        }
        return _handler;
    }

    protected String getLogMessageId() {
        return "eeadmin.ClusterConfigMBean.Exception";
    }

    public boolean isStandAlone() throws InstanceException {
        String clusterName = this.getName();
        try {
            return ClusterHelper.isClusterStandAlone((ConfigContext)this.getConfigContext(), (String)clusterName);
        }
        catch (Exception ex) {
            throw ClusterConfigMBean.getExceptionHandler().handleInstanceException(ex, this.getLogMessageId(), clusterName);
        }
    }

    public RuntimeStatusList getRuntimeStatus() throws InstanceException {
        return this.getClustersConfigBean().getRuntimeStatus(this.getName());
    }

    public void clearRuntimeStatus() throws InstanceException {
        this.getClustersConfigBean().clearRuntimeStatus(this.getName());
    }

    public RuntimeStatusList start() throws InstanceException {
        return this.getClustersConfigBean().startCluster(this.getName());
    }

    public RuntimeStatusList stop() throws InstanceException {
        return this.getClustersConfigBean().stopCluster(this.getName());
    }

    public void delete() throws InstanceException {
        this.getClustersConfigBean().deleteCluster(this.getName());
    }

    public String[] listServerInstancesAsString(boolean andStatus) throws InstanceException {
        return this.getServersConfigBean().listServerInstancesAsString(this.getName(), andStatus);
    }

    public ObjectName[] listServerInstances() throws InstanceException, MBeanException {
        return this.toServerONArray(this.listServerInstancesAsString(false));
    }
}

