/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.lbadmin.writer;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.ConfigFactory;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.LbConfig;
import com.sun.enterprise.ee.admin.lbadmin.beans.Loadbalancer;
import com.sun.enterprise.ee.admin.lbadmin.reader.impl.LoadbalancerReaderImpl;
import com.sun.enterprise.ee.admin.lbadmin.transform.LoadbalancerVisitor;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import org.netbeans.modules.schema2beans.Schema2BeansException;

public class LbConfigWriter {
    Loadbalancer _lb = null;
    String _path = null;
    String _name = null;
    ConfigContext _ctx = null;
    String _f = "loadbalancer.xml";
    private static final StringManager _strMgr = StringManager.getManager((Class)LbConfigWriter.class);
    private static final String PUBLICID = "-//Sun Microsystems Inc.//DTD Sun ONE Application Server 7.1//EN";
    private static final String SYSTEMID = "sun-loadbalancer_1_1.dtd";

    public LbConfigWriter(ConfigContext ctx, String lbConfigName, String path) {
        if (path == null || "".equals(path) || "null".equals(path)) {
            String iRoot = System.getProperty("com.sun.aas.instanceRoot");
            this._path = iRoot + File.separator + "generated" + File.separator + this._f + "." + lbConfigName;
        } else {
            File f = new File(path);
            this._path = f.isDirectory() ? path + File.separator + this._f + "." + lbConfigName : path;
        }
        this._name = lbConfigName;
        this._ctx = ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String write() throws IOException, ConfigException, Schema2BeansException {
        String string;
        block5: {
            LbConfig lbConfig = ((Domain)this._ctx.getRootConfigBean()).getLbConfigs().getLbConfigByName(this._name);
            LoadbalancerReaderImpl lbRdr = new LoadbalancerReaderImpl(this._ctx, lbConfig);
            this._lb = new Loadbalancer();
            LoadbalancerVisitor lbVstr = new LoadbalancerVisitor(this._lb);
            lbRdr.accept(lbVstr);
            File f = new File(this._path);
            if (f.isDirectory()) {
                f = new File(f, this._f);
            }
            if (f.exists()) {
                String msg = _strMgr.getString("FileExists", (Object)f.getPath());
                throw new IOException(msg);
            }
            if (!f.getParentFile().exists()) {
                String msg = _strMgr.getString("ParentFileMissing", (Object)f.getParent());
                throw new IOException(msg);
            }
            FileOutputStream fo = null;
            try {
                String fAbsPath;
                fo = new FileOutputStream(f);
                String footer = _strMgr.getString("GeneratedFileFooter", (Object)new Date().toString());
                this._lb.graphManager().setDoctype(PUBLICID, SYSTEMID);
                this._lb.write(fo);
                fo.write(footer.getBytes());
                string = fAbsPath = f.getAbsolutePath();
                Object var10_11 = null;
                if (fo == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var10_12 = null;
                    if (fo == null) break block6;
                    fo.close();
                    fo = null;
                }
                throw throwable;
            }
            fo.close();
            fo = null;
        }
        return string;
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            return;
        }
        try {
            String cPath = "domain.xml";
            ConfigContext ctx = null;
            try {
                ctx = ConfigFactory.createConfigContext((String)cPath);
            }
            catch (ConfigException ce) {
                ce.printStackTrace();
            }
            LbConfigWriter lbw = new LbConfigWriter(ctx, args[0], args[1]);
            lbw.write();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

