/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.lbadmin.reader.impl;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.ApplicationHelper;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.PropertyResolver;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.archivist.AbstractArchive;
import com.sun.enterprise.deployment.archivist.FileArchive;
import com.sun.enterprise.deployment.io.ApplicationDeploymentDescriptorFile;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.ee.admin.lbadmin.reader.api.LocationHelper;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;

public class LocationHelperImpl
implements LocationHelper {
    private ConfigContext _ctx = null;
    private String _dasName = null;
    private static Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.admin");
    private static final String WEB_INF = "WEB-INF";
    private static final String META_INF = "META-INF";
    private static final String SUN_WEB_DD = "sun-web.xml";
    private static final String SUN_EJB_JAR_DD = "sun-ejb-jar.xml";
    private static final String SUN_PREFIX = "sun-";

    public LocationHelperImpl(ConfigContext ctx) {
        this._ctx = ctx;
        this._dasName = System.getProperty("com.sun.aas.instanceName");
    }

    public String getSunWebXmlPathForModule(String moduleName) {
        String path = null;
        try {
            ConfigBean bean = ApplicationHelper.findApplication((ConfigContext)this._ctx, (String)moduleName);
            if (bean != null && bean instanceof WebModule) {
                String loc = ((WebModule)bean).getLocation();
                PropertyResolver pr = new PropertyResolver(this._ctx, this._dasName);
                String resolved = pr.resolve(loc);
                File f = new File(resolved, WEB_INF + File.separator + SUN_WEB_DD);
                path = f.getAbsolutePath();
            }
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "Unexpected error while getting path to sun-web.xml", e);
        }
        _logger.fine("Returning stand alone web-app path: " + path);
        return path;
    }

    public List getSunWebXmlPathForApplication(String applicationName) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            ConfigBean bean = ApplicationHelper.findApplication((ConfigContext)this._ctx, (String)applicationName);
            if (bean != null) {
                if (bean instanceof J2eeApplication) {
                    String loc = ((J2eeApplication)bean).getLocation();
                    PropertyResolver pr = new PropertyResolver(this._ctx, this._dasName);
                    String rLocation = pr.resolve(loc);
                    FileArchive in = new FileArchive();
                    in.open(rLocation);
                    ApplicationDeploymentDescriptorFile rootDD = new ApplicationDeploymentDescriptorFile();
                    Application application = (Application)rootDD.read(null, (AbstractArchive)in);
                    Iterator modules = application.getModules();
                    while (modules.hasNext()) {
                        ModuleDescriptor aModule = (ModuleDescriptor)modules.next();
                        if (!aModule.getModuleType().equals(ModuleType.WAR)) {
                            _logger.fine("Skipping non web module descriptor: " + aModule.getModuleType());
                            continue;
                        }
                        if (aModule.getAlternateDescriptor() != null) {
                            File altWebapp;
                            File f = new File(aModule.getAlternateDescriptor());
                            String parent = f.getParent();
                            if (parent == null) {
                                parent = "";
                            }
                            if ((altWebapp = new File(rLocation, parent + File.separator + SUN_PREFIX + f.getName())).exists()) {
                                _logger.fine("Adding alt-web-app path " + altWebapp.getAbsolutePath());
                                list.add(altWebapp.getAbsolutePath());
                                continue;
                            }
                            _logger.fine("Invalid path: " + altWebapp.getAbsolutePath());
                            continue;
                        }
                        String aUri = aModule.getArchiveUri();
                        if (aUri == null) continue;
                        String instanceRoot = System.getProperty("com.sun.aas.instanceRoot");
                        File generated = new File(instanceRoot, "generated");
                        File xml = new File(generated, "xml");
                        File j2eeApps = new File(xml, "j2ee-apps");
                        File module = new File(j2eeApps, applicationName);
                        String modulePath = module.getAbsolutePath();
                        File webapp = new File(modulePath, FileUtils.makeFriendlyFileName((String)aUri) + File.separator + WEB_INF + File.separator + SUN_WEB_DD);
                        if (webapp.exists()) {
                            _logger.fine("Adding web-app path " + webapp.getAbsolutePath());
                            list.add(webapp.getAbsolutePath());
                            continue;
                        }
                        webapp = new File(rLocation, FileUtils.makeFriendlyFileName((String)aUri) + File.separator + WEB_INF + File.separator + SUN_WEB_DD);
                        if (webapp.exists()) {
                            _logger.fine("Adding web-app path " + webapp.getAbsolutePath());
                            list.add(webapp.getAbsolutePath());
                            continue;
                        }
                        _logger.fine("Invalid path: " + webapp.getAbsolutePath());
                    }
                } else {
                    _logger.fine("Not a J2EE: " + applicationName);
                }
            } else {
                _logger.fine("Application not found in server configuration " + applicationName);
            }
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "Unexpected error while getting path to sun-web.xml", e);
        }
        return list;
    }

    public List getSunEjbJarXmlPathForApplication(String applicationName) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            ConfigBean bean = ApplicationHelper.findApplication((ConfigContext)this._ctx, (String)applicationName);
            if (bean != null) {
                if (bean instanceof J2eeApplication) {
                    String loc = ((J2eeApplication)bean).getLocation();
                    PropertyResolver pr = new PropertyResolver(this._ctx, this._dasName);
                    String rLocation = pr.resolve(loc);
                    FileArchive in = new FileArchive();
                    in.open(rLocation);
                    ApplicationDeploymentDescriptorFile rootDD = new ApplicationDeploymentDescriptorFile();
                    Application application = (Application)rootDD.read(null, (AbstractArchive)in);
                    Iterator modules = application.getModules();
                    while (modules.hasNext()) {
                        ModuleDescriptor aModule = (ModuleDescriptor)modules.next();
                        if (!aModule.getModuleType().equals(ModuleType.EJB)) {
                            _logger.fine("Skipping non ejb jar module descriptor: " + aModule.getModuleType());
                            continue;
                        }
                        if (aModule.getAlternateDescriptor() != null) {
                            File altWebapp;
                            File f = new File(aModule.getAlternateDescriptor());
                            String parent = f.getParent();
                            if (parent == null) {
                                parent = "";
                            }
                            if ((altWebapp = new File(rLocation, parent + File.separator + SUN_PREFIX + f.getName())).exists()) {
                                _logger.fine("Adding alt-web-app path " + altWebapp.getAbsolutePath());
                                list.add(altWebapp.getAbsolutePath());
                                continue;
                            }
                            _logger.fine("Invalid path: " + altWebapp.getAbsolutePath());
                            continue;
                        }
                        String aUri = aModule.getArchiveUri();
                        if (aUri == null) continue;
                        String instanceRoot = System.getProperty("com.sun.aas.instanceRoot");
                        File generated = new File(instanceRoot, "generated");
                        File xml = new File(generated, "xml");
                        File j2eeApps = new File(xml, "j2ee-apps");
                        File module = new File(j2eeApps, applicationName);
                        String modulePath = module.getAbsolutePath();
                        File ejbapp = new File(modulePath, FileUtils.makeFriendlyFileName((String)aUri) + File.separator + META_INF + File.separator + SUN_EJB_JAR_DD);
                        if (ejbapp.exists()) {
                            _logger.fine("Adding ejb-app path " + ejbapp.getAbsolutePath());
                            list.add(ejbapp.getAbsolutePath());
                            continue;
                        }
                        ejbapp = new File(rLocation, FileUtils.makeFriendlyFileName((String)aUri) + File.separator + META_INF + File.separator + SUN_EJB_JAR_DD);
                        if (ejbapp.exists()) {
                            _logger.fine("Adding ejb-app path " + ejbapp.getAbsolutePath());
                            list.add(ejbapp.getAbsolutePath());
                            continue;
                        }
                        _logger.fine("Invalid path: " + ejbapp.getAbsolutePath());
                    }
                } else {
                    _logger.fine("Not a J2EE: " + applicationName);
                }
            } else {
                _logger.fine("Application not found in server configuration " + applicationName);
            }
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "Unexpected error while getting path to sun-ejb-jar.xml", e);
        }
        return list;
    }
}

