/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.lbadmin.reader.impl;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.ClusterRef;
import com.sun.enterprise.config.serverbeans.HealthChecker;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.ee.admin.lbadmin.reader.api.ClusterReader;
import com.sun.enterprise.ee.admin.lbadmin.reader.api.HealthCheckerReader;
import com.sun.enterprise.ee.admin.lbadmin.reader.api.InstanceReader;
import com.sun.enterprise.ee.admin.lbadmin.reader.api.LbReaderException;
import com.sun.enterprise.ee.admin.lbadmin.reader.api.WebModuleReader;
import com.sun.enterprise.ee.admin.lbadmin.reader.impl.ClusterReaderHelper;
import com.sun.enterprise.ee.admin.lbadmin.reader.impl.HealthCheckerReaderImpl;
import com.sun.enterprise.ee.admin.lbadmin.reader.impl.InstanceReaderImpl;
import com.sun.enterprise.ee.admin.lbadmin.transform.ClusterVisitor;
import com.sun.enterprise.ee.admin.lbadmin.transform.Visitor;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.ArrayList;

public class ClusterReaderImpl
implements ClusterReader {
    private ConfigContext _configCtx = null;
    private ClusterRef _clusterRef = null;
    private static final StringManager _strMgr = StringManager.getManager((Class)ClusterReaderImpl.class);

    public ClusterReaderImpl(ConfigContext ctx, ClusterRef ref) throws LbReaderException {
        if (ctx == null || ref == null) {
            String iMsg = _strMgr.getString("InvalidArgs");
            throw new RuntimeException(iMsg);
        }
        this._configCtx = ctx;
        this._clusterRef = ref;
        try {
            if (!ClusterHelper.isACluster((ConfigContext)ctx, (String)ref.getRef())) {
                String msg = _strMgr.getString("ClusterNotFound", (Object)ref.getRef());
                throw new LbReaderException(msg);
            }
        }
        catch (ConfigException ce) {
            String msg = _strMgr.getString("ClusterNotFound", (Object)ref.getRef());
            throw new LbReaderException(msg, ce);
        }
    }

    public String getName() {
        return this._clusterRef.getRef();
    }

    public InstanceReader[] getInstances() throws LbReaderException {
        Server[] servers = null;
        try {
            servers = ServerHelper.getServersInCluster((ConfigContext)this._configCtx, (String)this._clusterRef.getRef());
        }
        catch (ConfigException ce) {
            String msg = _strMgr.getString("ErrorFindingClusteredServers", (Object)this._clusterRef.getRef());
            throw new LbReaderException(msg, ce);
        }
        InstanceReader[] readers = null;
        if (servers != null) {
            readers = new InstanceReader[servers.length];
            for (int i = 0; i < servers.length; ++i) {
                readers[i] = new InstanceReaderImpl(this._configCtx, this._clusterRef, servers[i]);
            }
        }
        return readers;
    }

    public HealthCheckerReader getHealthChecker() throws LbReaderException {
        HealthChecker bean = this._clusterRef.getHealthChecker();
        if (bean == null) {
            return null;
        }
        HealthCheckerReaderImpl reader = new HealthCheckerReaderImpl(bean);
        return reader;
    }

    public WebModuleReader[] getWebModules() throws LbReaderException {
        ArrayList list = new ArrayList();
        ApplicationRef[] refs = null;
        try {
            refs = ClusterHelper.getApplicationReferences((ConfigContext)this._configCtx, (String)this._clusterRef.getRef());
        }
        catch (ConfigException ce) {
            String msg = _strMgr.getString("ErrorFindingClusteredApplications", (Object)this._clusterRef.getRef());
            throw new LbReaderException(msg, ce);
        }
        return ClusterReaderHelper.getWebModules(this._configCtx, refs, this._clusterRef.getRef());
    }

    public void accept(Visitor v) {
        ClusterVisitor cv = (ClusterVisitor)v;
        cv.visit(this);
    }
}

