/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.hadbmgmt;

import com.sun.enterprise.ee.admin.hadbmgmt.HADBSetupException;
import java.net.InetAddress;

public class HADBUtils {
    private static final boolean NO_HADB;
    private static final boolean NO_DELETE;
    private static final boolean NATIVE_SCHEMA;
    private static final boolean USE_IP_ONLY;
    private static int phonyReturnValue;
    private static final String LOOPBACK = "127.0.0.1";

    private HADBUtils() {
    }

    static boolean useIP() {
        return USE_IP_ONLY;
    }

    static boolean nativeSchema() {
        return NATIVE_SCHEMA;
    }

    static boolean noDelete() {
        return NO_DELETE;
    }

    static boolean noHADB() {
        return NO_HADB;
    }

    static boolean yesHADB() {
        return !NO_HADB;
    }

    static int getPhonyReturnValue() {
        return phonyReturnValue;
    }

    static void setPhonyReturnValue(int i) {
        phonyReturnValue = i;
    }

    static String getIP(String host) throws HADBSetupException {
        try {
            InetAddress add = InetAddress.getByName(host);
            String ip = add.getHostAddress();
            if (ip.equals(LOOPBACK)) {
                add = InetAddress.getLocalHost();
                ip = add.getHostAddress();
            }
            if (ip.equals(LOOPBACK)) {
                throw new HADBSetupException("hadbmgmt-res.BadHostNameGotLoopback");
            }
            return add.getHostAddress();
        }
        catch (Exception e) {
            throw new HADBSetupException("hadbmgmt-res.BadHostName", (Throwable)e, host);
        }
    }

    static {
        phonyReturnValue = 0;
        String prop = System.getProperty("hadbnohadb");
        NO_HADB = prop != null && prop.equals("true");
        prop = System.getProperty("hadbmnodeletepasswordfile", "false");
        NO_DELETE = prop != null && prop.equals("true");
        prop = System.getProperty("hadbnativeschema", "false");
        NATIVE_SCHEMA = prop == null || !prop.equals("false");
        prop = System.getProperty("hadbusehostname", "false");
        USE_IP_ONLY = prop == null || !prop.equals("true");
    }
}

