/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.hadbmgmt;

import com.sun.enterprise.admin.util.JMXConnectorConfig;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.StaleWriteConfigException;
import com.sun.enterprise.config.serverbeans.AvailabilityService;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBMExecutor;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBSetupException;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBUtils;
import com.sun.enterprise.ee.admin.hadbmgmt.LoggerHelper;
import com.sun.enterprise.ee.admin.hadbmgmt.PasswordManager;
import com.sun.enterprise.ee.admin.hadbmgmt.StringHelper;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.management.MBeanServer;

public class HADBInfo {
    private String hosts;
    private int agentPort;
    private String agentURL;
    private String clusterName;
    private String jdbcURL;
    private String[] args;
    private String systemUser;
    private String systemPassword;
    private String adminPassword;
    private PasswordManager adminPasswordManager;
    private PasswordManager dbPasswordManager;
    private String dbUser;
    private String dbPassword;
    private ConfigContext configCtx;
    private File executable;
    private MBeanServer mbeanServer;
    private File hadbRoot;
    private boolean dbPreExists = false;
    private String agentPortString;
    private List msgs = new ArrayList();
    private String userPasswordFile;
    private static final String DRIVER_NAME = "jdbc:sun:hadb:";
    private static final int DEFAULT_AGENT_PORT = 1862;
    private static final String HA_HOSTS_PROPERTY_NAME = "ha-agent-hosts";
    private static final String HA_AGENT_PORT_PROPERTY_NAME = "ha-agent-port";
    private static final String HA_DB_NAME_PROPERTY_NAME = "ha-db-name";

    public HADBInfo(String hosts, String agentPort, String theAdminPassword, String userPasswordFile, String clusterOrDbName, Logger logger, ConfigContext configCtx, MBeanServer mbeanServer) throws HADBSetupException {
        this.clusterName = clusterOrDbName;
        this.configCtx = configCtx;
        this.systemUser = "system";
        this.mbeanServer = mbeanServer;
        this.userPasswordFile = userPasswordFile;
        if (logger == null) {
            String mesg = StringHelper.get("hadbmgmt-res.InternalError", "MBean passed in a null logger reference.  This is supposed to be impossible.");
            logger = Logger.getLogger("javax.enterprise.system.tools.admin.hadbmanagement");
            logger.severe(mesg);
            throw new HADBSetupException(mesg);
        }
        LoggerHelper.set(logger);
        this.hosts = hosts;
        this.agentPortString = agentPort;
        this.setAdminPassword(theAdminPassword);
    }

    public void setup() throws HADBSetupException {
        this.verifyStandaloneCluster();
        this.setHosts();
        this.checkHosts();
        this.setHadbRoot();
        this.setAgentPort();
        PasswordManager.setPasswords(this, this.userPasswordFile);
        try {
            JMXConnectorConfig config = ServerHelper.getJMXConnectorInfo((ConfigContext)this.configCtx, (String)ServerHelper.getDAS((ConfigContext)this.configCtx).getName());
            String pw = config.getPassword();
            this.setSystemPassword(pw);
            this.setDatabasePassword(pw);
            this.setAdminPassword(pw);
            this.setDatabaseUser(config.getUser());
            this.adminPasswordManager = new PasswordManager(this, "adminpassword", this.adminPassword);
            this.dbPasswordManager = new PasswordManager(this, "dbpassword", this.dbPassword);
        }
        catch (Exception e) {
            throw new HADBSetupException("hadbmgmt-res.InternalError", e);
        }
    }

    public final void cleanup() {
        if (this.adminPasswordManager != null) {
            this.adminPasswordManager.delete();
        }
        if (this.dbPasswordManager != null) {
            this.dbPasswordManager.delete();
        }
    }

    public final void setSystemPassword(String s) {
        if (!this.ok(s) || this.ok(this.systemPassword)) {
            return;
        }
        this.systemPassword = s;
    }

    public final void setDatabaseUser(String s) {
        if (!this.ok(s) || this.ok(this.dbUser)) {
            return;
        }
        this.dbUser = s;
    }

    public final void setDatabasePassword(String s) {
        if (!this.ok(s) || this.ok(this.dbPassword)) {
            return;
        }
        this.dbPassword = s;
    }

    public final void setAdminPassword(String s) {
        if (!this.ok(s) || this.ok(this.adminPassword)) {
            return;
        }
        this.adminPassword = s;
    }

    final PasswordManager getAdminPasswordManager() {
        return this.adminPasswordManager;
    }

    final PasswordManager getDBPasswordManager() {
        return this.dbPasswordManager;
    }

    final void setDatabasePassword(String s, boolean overwrite) {
        if (!overwrite) {
            this.setDatabasePassword(s);
        }
        if (this.ok(s)) {
            this.dbPassword = s;
        }
    }

    final void setAdminPassword(String s, boolean overwrite) {
        if (!overwrite) {
            this.setAdminPassword(s);
        }
        if (this.ok(s)) {
            this.adminPassword = s;
        }
    }

    final String getClusterName() throws HADBSetupException {
        if (!this.ok(this.clusterName)) {
            throw new HADBSetupException("hadbmgmt-res.InternalError", "Cluster name has not been set yet.");
        }
        return this.clusterName;
    }

    final String getSystemUser() {
        return this.systemUser;
    }

    final String getSystemPassword() {
        return this.systemPassword;
    }

    final String getDatabaseUser() {
        return this.dbUser;
    }

    final String getDatabasePassword() {
        return this.dbPassword;
    }

    final File getHadbRoot() {
        return this.hadbRoot;
    }

    final File getExecutable() {
        if (this.executable == null) {
            this.executable = new File(new File(this.getHadbRoot(), "bin"), "hadbm");
        }
        return this.executable;
    }

    final String[] getStartCommands() throws HADBSetupException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("start");
        args.add(this.getJavaRootArg());
        args.add(this.adminPasswordManager.getArg());
        args.add(this.getAgentURLArg());
        args.add(this.clusterName);
        return this.toArray(args);
    }

    final String[] getStopCommands() throws HADBSetupException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("stop");
        args.add(this.getJavaRootArg());
        args.add(this.adminPasswordManager.getArg());
        args.add("-y");
        args.add(this.getAgentURLArg());
        args.add(this.clusterName);
        return this.toArray(args);
    }

    final String[] getDeleteCommands() throws HADBSetupException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("delete");
        args.add(this.getJavaRootArg());
        args.add(this.adminPasswordManager.getArg());
        args.add("-y");
        args.add(this.getAgentURLArg());
        args.add(this.clusterName);
        return this.toArray(args);
    }

    final String[] getJdbcURLCommands() throws HADBSetupException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("get");
        args.add(this.getJavaRootArg());
        args.add(this.adminPasswordManager.getArg());
        args.add("jdbcURL");
        args.add(this.getAgentURLArg());
        args.add(this.clusterName);
        return this.toArray(args);
    }

    final String[] getExistsCommands() throws HADBSetupException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("status");
        args.add(this.getJavaRootArg());
        args.add(this.adminPasswordManager.getArg());
        args.add(this.getAgentURLArg());
        args.add(this.clusterName);
        return this.toArray(args);
    }

    final String[] getIsAliveCommands() throws HADBSetupException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("list");
        args.add(this.getJavaRootArg());
        args.add(this.adminPasswordManager.getArg());
        args.add(this.getAgentURLArg());
        return this.toArray(args);
    }

    String getAgentURLArg() throws HADBSetupException {
        return "--agent=" + this.getAgentURL();
    }

    final String getHosts() {
        return this.hosts;
    }

    final String getHostsAndPorts() throws HADBSetupException {
        return this.getJdbcURL(true);
    }

    final String getJdbcURL() throws HADBSetupException {
        return this.getJdbcURL(false);
    }

    final String getJdbcURL(boolean stripDriverName) throws HADBSetupException {
        if (HADBUtils.noHADB()) {
            return "bilbo:1111,bilbo:1112";
        }
        if (!this.ok(this.jdbcURL)) {
            String[] commands = this.getJdbcURLCommands();
            HADBMExecutor exec = new HADBMExecutor();
            int exitValue = exec.exec(this.getExecutable(), commands);
            if (exitValue != 0) {
                throw new HADBSetupException("hadbmgmt-res.GetJdbcUrlFailed", new Object[]{"" + exitValue, exec.getStdout(), exec.getStderr()});
            }
            LoggerHelper.fine("***** getJdbcURL STDOUT\n" + exec.getStdout());
            LoggerHelper.fine("***** getJdbcURL STDERR\n" + exec.getStderr());
            String jdbcUrlString = exec.getStdout();
            int index = jdbcUrlString.indexOf(DRIVER_NAME);
            if (index < 0) {
                throw new HADBSetupException("hadbmgmt-res.MalformedJdbcUrl", jdbcUrlString);
            }
            this.jdbcURL = jdbcUrlString.substring(index).trim();
            LoggerHelper.fine("jdbcURL is " + this.jdbcURL);
        }
        String result = this.jdbcURL;
        if (stripDriverName) {
            result = this.jdbcURL.substring(DRIVER_NAME.length());
        }
        LoggerHelper.fine("getJdbcURL " + stripDriverName + " returns " + result);
        return result;
    }

    final MBeanServer getMBeanServer() throws HADBSetupException {
        if (this.mbeanServer == null) {
            throw new HADBSetupException("hadbmgmt-res.InternalError", "null mbeanServer");
        }
        return this.mbeanServer;
    }

    final ConfigContext getConfigContext() {
        return this.configCtx;
    }

    final void setDBPreExists() {
        this.dbPreExists = true;
    }

    final boolean getDBPreExists() {
        return this.dbPreExists;
    }

    final Config getConfigForCluster() throws HADBSetupException {
        try {
            return ClusterHelper.getConfigForCluster((ConfigContext)this.getConfigContext(), (String)this.getClusterName());
        }
        catch (ConfigException ce) {
            if (this.clusterConfigRequired()) {
                throw new HADBSetupException("hadbmgmt-res.BadConfigContext", (Throwable)ce, this.getClusterName());
            }
            return null;
        }
    }

    final ElementProperty createHostsElementProperty() throws StaleWriteConfigException {
        ElementProperty ep = new ElementProperty();
        ep.setName(HA_HOSTS_PROPERTY_NAME, true);
        ep.setValue(this.getHosts(), true);
        return ep;
    }

    final ElementProperty createAgentPortElementProperty() throws StaleWriteConfigException {
        ElementProperty ep = new ElementProperty();
        ep.setName(HA_AGENT_PORT_PROPERTY_NAME, true);
        ep.setValue("" + this.agentPort, true);
        return ep;
    }

    final ElementProperty createDBNameElementProperty() throws StaleWriteConfigException, HADBSetupException {
        ElementProperty ep = new ElementProperty();
        ep.setName(HA_DB_NAME_PROPERTY_NAME, true);
        ep.setValue(this.getClusterName(), true);
        return ep;
    }

    boolean clusterConfigRequired() {
        return true;
    }

    String getJavaRoot() {
        return System.getProperty("com.sun.aas.javaRoot");
    }

    String getJavaRootArg() {
        return "--javahome=" + this.getJavaRoot();
    }

    void addMsg(String s) {
        this.msgs.add(s);
    }

    Object[] prepMsgs() {
        if (this.msgs.size() <= 0) {
            return null;
        }
        if (!this.msgs.get(this.msgs.size() - 1).toString().equals("\n")) {
            this.msgs.add("\n");
        }
        return this.msgs.toArray();
    }

    final String getAgentURL() throws HADBSetupException {
        if (this.agentURL == null) {
            this.agentURL = this.getHosts() + ":" + this.agentPort;
        }
        return this.agentURL;
    }

    final void verifyStandaloneCluster() throws HADBSetupException {
        if (!this.clusterConfigRequired() && this.getConfigForCluster() == null) {
            return;
        }
        try {
            if (ClusterHelper.isClusterStandAlone((ConfigContext)this.getConfigContext(), (String)this.getClusterName())) {
                return;
            }
        }
        catch (Exception e) {
            throw new HADBSetupException(e);
        }
        throw new HADBSetupException("hadbmgmt-res.SharedClusterConfig");
    }

    final void setHadbRoot() throws HADBSetupException {
        String path = System.getProperty("com.sun.aas.hadbRoot");
        if (!this.ok(path)) {
            throw new HADBSetupException("hadbmgmt-res.NoHadbRootEnv", "com.sun.aas.hadbRoot");
        }
        File f = new File(path);
        if (!FileUtils.safeIsDirectory((File)f)) {
            throw new HADBSetupException("hadbmgmt-res.NoHadbRootPath", new Object[]{"com.sun.aas.hadbRoot", path});
        }
        if (!f.canWrite()) {
            throw new HADBSetupException("hadbmgmt-res.NoHadbRootWrite", new Object[]{"com.sun.aas.hadbRoot", path});
        }
        this.hadbRoot = f;
    }

    private final void setHosts() throws HADBSetupException {
        if (!this.ok(this.hosts)) {
            try {
                this.hosts = this.getHostsFromConfig();
                if (this.ok(this.hosts)) {
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.clusterConfigRequired()) {
                throw new HADBSetupException("hadbmgmt-res.NoHosts");
            }
            throw new HADBSetupException("hadbmgmt-res.NoHostsOnRemove");
        }
    }

    private final void checkHosts() throws HADBSetupException {
        if (!this.ok(this.hosts)) {
            throw new HADBSetupException("hadbmgmt-res.InternalError", "checkHosts called with no hosts set.  This is supposed to be impossible.");
        }
        String[] ha = this.hosts.split(",");
        ArrayList<String> hl = new ArrayList<String>();
        for (int i = 0; i < ha.length; ++i) {
            if (!this.ok(ha[i])) continue;
            hl.add(ha[i]);
        }
        int num = hl.size();
        if (num < 2 || num % 2 != 0) {
            throw new HADBSetupException("hadbmgmt-res.BadNumberOfHosts", new Object[]{"" + num, this.hosts});
        }
        this.hosts = "";
        boolean first = true;
        Iterator it = hl.iterator();
        while (it.hasNext()) {
            String host = it.next().toString();
            if (first) {
                first = false;
            } else {
                this.hosts = this.hosts + ",";
            }
            if (HADBUtils.useIP()) {
                host = HADBUtils.getIP(host);
            }
            this.hosts = this.hosts + host;
        }
    }

    private final String getHostsFromConfig() throws HADBSetupException {
        Config config = this.getConfigForCluster();
        if (config == null) {
            return null;
        }
        AvailabilityService avail = config.getAvailabilityService();
        ElementProperty epHosts = avail.getElementPropertyByName(HA_HOSTS_PROPERTY_NAME);
        if (epHosts == null) {
            return null;
        }
        String val = epHosts.getValue();
        if (!this.ok(val)) {
            return null;
        }
        return val;
    }

    private final String getAgentPortFromConfig() throws HADBSetupException {
        Config config = this.getConfigForCluster();
        if (config == null) {
            return null;
        }
        AvailabilityService avail = config.getAvailabilityService();
        ElementProperty epHosts = avail.getElementPropertyByName(HA_AGENT_PORT_PROPERTY_NAME);
        if (epHosts == null) {
            return "0";
        }
        String val = epHosts.getValue();
        if (!this.ok(val)) {
            return "0";
        }
        return val;
    }

    private final void setAgentPort() throws HADBSetupException {
        try {
            this.agentPort = Integer.parseInt(this.agentPortString);
            if (this.agentPort > 0 && this.agentPort < 65536) {
                return;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.agentPortString = this.getAgentPortFromConfig();
        try {
            this.agentPort = Integer.parseInt(this.agentPortString);
            if (this.agentPort > 0 && this.agentPort < 65536) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        LoggerHelper.warning("hadbmgmt-res.NoAgentPort", "1862");
        this.agentPort = 1862;
    }

    private final String[] toArray(List list) {
        String[] ss = new String[list.size()];
        return list.toArray(ss);
    }

    private final boolean ok(String s) {
        return StringUtils.ok((String)s);
    }
}

