/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.hadbmgmt;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBInfo;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBSetupException;
import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Logger;
import javax.management.MBeanServer;

public class HADBCreateDBInfo
extends HADBInfo {
    private ArrayList extraArgs;
    private String historyPath;
    private String devicePath;
    private String agentURLOverride;
    private int deviceSize = 512;
    private int dataDevices = 1;
    private int portBase = 15200;
    private int spares = 0;
    private String remotePackagePath;
    private Properties props;
    private static final int MAX_DEVICE_SIZE = 0x7FFFFF;
    private static final int MIN_DEVICE_SIZE = 208;
    private static final int DEFAULT_DEVICE_SIZE = 512;
    private static final int DEFAULT_DATA_DEVICES = 1;
    private static final int DEFAULT_PORT_BASE = 15200;
    private static final int DEFAULT_SPARES = 0;
    private static final String DEFAULT_DEVICE_SUBDIR = "device";
    private static final String DEFAULT_HISTORY_SUBDIR = "history";

    public HADBCreateDBInfo(String hosts, String agentPort, String theAdminPassword, String userPasswordFile, String remotePackagePath, String clusterOrDbName, Logger logger, ConfigContext configCtx, MBeanServer mbeanServer) throws HADBSetupException {
        super(hosts, agentPort, theAdminPassword, userPasswordFile, clusterOrDbName, logger, configCtx, mbeanServer);
        this.remotePackagePath = remotePackagePath;
    }

    public final void setDeviceSize(String size) throws HADBSetupException {
        int newDeviceSize = 0;
        if (size == null || size.length() <= 0) {
            return;
        }
        try {
            newDeviceSize = Integer.parseInt(size);
            if (newDeviceSize < 208 || newDeviceSize > 0x7FFFFF) {
                throw new NumberFormatException();
            }
            this.deviceSize = newDeviceSize;
        }
        catch (NumberFormatException nfe) {
            throw new HADBSetupException("hadbmgmt-res.BadDeviceSize", new String[]{"208", "8388607", size});
        }
    }

    public final void setProperties(Properties p) throws HADBSetupException {
        this.props = p;
        this.parseProps();
    }

    final String[] getCreateCommands() throws HADBSetupException {
        ArrayList<String> list = new ArrayList<String>(32);
        list.add("create");
        if (this.getHistoryPath() != null) {
            list.add("--historypath=" + this.getHistoryPath());
        }
        if (this.getDevicePath() != null) {
            list.add("--devicepath=" + this.getDevicePath());
        }
        list.add("--datadevices=" + this.getDataDevices());
        list.add("--portbase=" + this.getPortBase());
        list.add("--spares=" + this.getSpares());
        list.add("--devicesize=" + this.deviceSize);
        list.add(this.getJavaRootArg());
        list.add(this.getAdminPasswordManager().getArg());
        list.add(this.getDBPasswordManager().getArg());
        list.add("--hosts=" + this.getHosts());
        list.add(this.getAgentURLArg());
        if (this.extraArgs != null) {
            list.addAll(this.extraArgs);
        }
        if (this.ok(this.getRemotePackagePath())) {
            list.add("--packagepath=" + this.getRemotePackagePath());
        }
        list.add(this.getClusterName());
        String[] args = new String[list.size()];
        return list.toArray(args);
    }

    final int getPortBase() {
        return this.portBase;
    }

    private final void parseProps() throws HADBSetupException {
        if (this.props == null) {
            return;
        }
        String pathErr = "hadbmgmt-res.BadPathInProperty";
        String s = this.props.getProperty("historypath");
        if (this.ok(s)) {
            this.historyPath = this.checkPath(s, pathErr, "historypath=" + s);
        }
        if (this.ok(s = this.props.getProperty("devicepath"))) {
            this.devicePath = this.checkPath(s, pathErr, "devicepath=" + s);
        }
        if (this.ok(s = this.props.getProperty("datadevices"))) {
            this.dataDevices = this.parseInt(s, 1, 1000, 1);
        }
        if (this.ok(s = this.props.getProperty("portbase"))) {
            this.portBase = this.parseInt(s, 1, 65535, 15200);
        }
        if (this.ok(s = this.props.getProperty("spares"))) {
            this.spares = this.parseInt(s, 0, 1000, 0);
        }
        if (this.ok(s = this.props.getProperty("agent"))) {
            this.agentURLOverride = s;
        }
        if (this.ok(s = this.props.getProperty("dbpassword"))) {
            this.setDatabasePassword(s, true);
        }
        if (this.props.containsKey("--no-cleanup")) {
            this.extraArgs = new ArrayList();
            this.extraArgs.add("--no-cleanup");
        }
        if (this.props.containsKey("--no-clear")) {
            if (this.extraArgs == null) {
                this.extraArgs = new ArrayList();
            }
            this.extraArgs.add("--no-clear");
        }
    }

    private final String getHistoryPath() {
        return this.historyPath;
    }

    private final String getDevicePath() {
        return this.devicePath;
    }

    String getAgentURLArg() throws HADBSetupException {
        if (this.agentURLOverride != null) {
            return "--agent=" + this.agentURLOverride;
        }
        return super.getAgentURLArg();
    }

    private final int getDataDevices() {
        return this.dataDevices;
    }

    private final int getSpares() {
        return this.spares;
    }

    private final String getRemotePackagePath() {
        return this.remotePackagePath;
    }

    private final boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    private final int parseInt(String s, int min, int max, int defaultValue) {
        try {
            int num = Integer.parseInt(s);
            if (num >= min && num <= max) {
                return num;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return defaultValue;
    }

    private final String checkPath(String path, String errorMessage, String errorArg) throws HADBSetupException {
        if (path == null) {
            throw new HADBSetupException("hadbmgmt-res.InternalError", "null path argument sent to checkPath()");
        }
        File f = new File(path);
        f.mkdirs();
        if (!f.isDirectory()) {
            throw new HADBSetupException(errorMessage, errorArg);
        }
        return f.getAbsolutePath();
    }
}

