/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.hadbmgmt;

import java.io.BufferedWriter;
import java.io.File;
import java.io.OutputStreamWriter;

public class FileUtils {
    private FileUtils() {
    }

    public static boolean protect(File f) {
        if (!f.exists()) {
            return true;
        }
        if (FileUtils.isUNIX()) {
            return FileUtils.protectUNIX(f);
        }
        return FileUtils.protectWindows(f);
    }

    private static boolean protectUNIX(File f) {
        String fname = f.getAbsolutePath();
        String mode = "0600";
        if (f.isDirectory()) {
            mode = "0700";
        }
        String cmd = "chmod " + mode + " " + fname;
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            return p.waitFor() == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean protectWindows(File f) {
        String fname = f.getAbsolutePath();
        String uname = System.getProperty("user.name");
        String cmd = "cacls " + fname + " /G " + uname + ":F";
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(p.getOutputStream()));
            writer.write(89);
            writer.newLine();
            writer.flush();
            return p.waitFor() == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isUNIX() {
        return File.separatorChar == '/';
    }
}

