/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.event;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ResourceAdapterConfig;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.ee.admin.event.EndPoint;
import com.sun.enterprise.ee.admin.event.TargetHelperBase;

class ResourceTargetHelper
extends TargetHelperBase {
    ResourceTargetHelper(String target, ConfigContext ctx) {
        super(target, ctx);
    }

    EndPoint[] getEndPoints() throws ConfigException {
        EndPoint[] endPoints = null;
        if (ServerTags.CONNECTOR_CONNECTION_POOL.equals(this._type)) {
            _logger.fine("[ResourceTargetHelper] Target [" + this._name + "] is a connector connection pool resource target of type [" + this._type + "]");
            Server[] servers = ServerHelper.getServersReferencingConnectorPool((ConfigContext)this._context, (String)this._name);
            endPoints = ResourceTargetHelper.createEndPoints(servers, this._context);
        } else if (ServerTags.JDBC_CONNECTION_POOL.equals(this._type)) {
            _logger.fine("[ResourceTargetHelper] Target [" + this._name + "] is a jdbc pool resource target of type [" + this._type + "]");
            Server[] servers = ServerHelper.getServersReferencingJdbcPool((ConfigContext)this._context, (String)this._name);
            endPoints = ResourceTargetHelper.createEndPoints(servers, this._context);
        } else if (ServerTags.RESOURCE_ADAPTER_CONFIG.equals(this._type)) {
            _logger.fine("[ResourceTargetHelper] Target [" + this._name + "] is a resource adapter config resource target of type [" + this._type + "]");
            Resources root = ((Domain)this._context.getRootConfigBean()).getResources();
            ResourceAdapterConfig raConfig = root.getResourceAdapterConfigByResourceAdapterName(this._name);
            if (raConfig != null) {
                String fullRAName = raConfig.getResourceAdapterName();
                String appName = null;
                int idx = fullRAName.indexOf("#");
                appName = idx > 0 ? fullRAName.substring(0, idx) : fullRAName;
                Server[] servers = ServerHelper.getServersReferencingApplication((ConfigContext)this._context, (String)appName);
                endPoints = ResourceTargetHelper.createEndPoints(servers, this._context);
            }
        } else {
            _logger.fine("[ResourceTargetHelper] Target [" + this._name + "] is a pure resource target of type [" + this._type + "]");
            Server[] servers = ServerHelper.getServersReferencingResource((ConfigContext)this._context, (String)this._name);
            endPoints = ResourceTargetHelper.createEndPoints(servers, this._context);
        }
        _logger.fine("[ResourceTargetHelper] End point count " + (endPoints == null ? 0 : endPoints.length));
        return endPoints;
    }
}

