/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.event;

import com.sun.enterprise.admin.event.AdminEvent;
import com.sun.enterprise.admin.event.AdminEventResult;
import com.sun.enterprise.admin.event.CommandEvent;
import com.sun.enterprise.admin.servermgmt.InstanceException;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.ee.admin.event.EndPoint;
import com.sun.enterprise.ee.admin.mbeanapi.ServerRuntimeMBean;
import com.sun.enterprise.ee.admin.proxy.InstanceProxy;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.logging.Level;
import java.util.logging.Logger;

class EndPointHandler
implements Runnable {
    private EndPoint _endPoint = null;
    private AdminEvent _event = null;
    private AdminEventResult _result = null;
    private static Logger _logger = null;
    private static final StringManager _strMgr = StringManager.getManager((Class)EndPointHandler.class);

    EndPointHandler(AdminEvent event, EndPoint ep) {
        this._endPoint = ep;
        this._event = event;
    }

    private static Logger getLogger() {
        if (_logger == null) {
            _logger = Logger.getLogger("javax.ee.enterprise.system.tools.admin");
        }
        return _logger;
    }

    public void run() {
        String serverName = this._endPoint.getHost();
        ConfigContext ctx = this._endPoint.getConfigContext();
        try {
            Config config = ServerHelper.getConfigForServer((ConfigContext)ctx, (String)serverName);
            if (config != null && config.isDynamicReconfigurationEnabled() || this._event instanceof CommandEvent) {
                ServerRuntimeMBean sRuntime = InstanceProxy.getInstanceProxy(this._endPoint.getHost());
                this._result = sRuntime.forwardEvent(this._event);
            } else {
                EndPointHandler.getLogger().log(Level.WARNING, "eeadmin.eventDynamicReconfigDisabled.Warning", new Object[]{serverName, this._event.toString()});
            }
        }
        catch (InstanceException e) {
            EndPointHandler.getLogger().log(Level.WARNING, "eeadmin.eventInstanceUnreachable.Warning", serverName);
            this._result = new AdminEventResult(this._event.getSequenceNumber());
            this._result.setResultCode("transmission_error");
            this._result.addException(serverName, (Throwable)e);
        }
        catch (Exception e) {
            EndPointHandler.getLogger().log(Level.SEVERE, "eeadmin.eventInstanceError.Exception", e);
            this._result = new AdminEventResult(this._event.getSequenceNumber());
            this._result.setResultCode("Event did not reach any recipient");
            this._result.addException(serverName, (Throwable)e);
        }
    }

    AdminEventResult getResult() {
        return this._result;
    }
}

