/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.configbeans;

import com.sun.enterprise.admin.configbeans.BaseConfigBean;
import com.sun.enterprise.admin.servermgmt.InstanceException;
import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.admin.servermgmt.RuntimeStatus;
import com.sun.enterprise.admin.target.Target;
import com.sun.enterprise.admin.target.TargetBuilder;
import com.sun.enterprise.admin.target.TargetType;
import com.sun.enterprise.admin.util.IAdminConstants;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigAPIHelper;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.NodeAgent;
import com.sun.enterprise.config.serverbeans.NodeAgents;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.ee.admin.ExceptionHandler;
import com.sun.enterprise.ee.admin.configbeans.ServersConfigBean;
import com.sun.enterprise.ee.admin.servermgmt.EEDomainsManager;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Logger;

public class ConfigsConfigBean
extends BaseConfigBean
implements IAdminConstants {
    private static final StringManager _strMgr = StringManager.getManager((Class)ConfigsConfigBean.class);
    private static Logger _logger = null;
    private static ExceptionHandler _handler = null;

    private static Logger getLogger() {
        if (_logger == null) {
            _logger = Logger.getLogger("javax.ee.enterprise.system.tools.admin");
        }
        return _logger;
    }

    protected static ExceptionHandler getExceptionHandler() {
        if (_handler == null) {
            _handler = new ExceptionHandler(ConfigsConfigBean.getLogger());
        }
        return _handler;
    }

    public ConfigsConfigBean(ConfigContext configContext) {
        super(configContext);
    }

    private void addConfigurationProperties(Config configuration, Properties props) throws ConfigException {
        if (props != null) {
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String propName = (String)e.nextElement();
                String propValue = props.getProperty(propName);
                if (propValue == null) continue;
                SystemProperty epOriginal = configuration.getSystemPropertyByName(propName);
                if (epOriginal != null) {
                    configuration.removeSystemProperty(epOriginal, true);
                }
                SystemProperty ep = new SystemProperty();
                ep.setName(propName);
                ep.setValue(propValue);
                configuration.addSystemProperty(ep, true);
            }
        }
    }

    String createStandAloneConfiguration(String name, Properties props) throws ConfigException {
        String standaloneConfigName = ConfigAPIHelper.getStandAloneConfigurationName((String)name);
        this.copyConfiguration("default-config", standaloneConfigName, props);
        return standaloneConfigName;
    }

    public void copyConfiguration(String sourceConfigName, String newConfigName, Properties props) throws ConfigException {
        try {
            ConfigContext configContext = this.getConfigContext();
            Config sourceConfig = ConfigAPIHelper.getConfigByName((ConfigContext)configContext, (String)sourceConfigName);
            if ("server-config".equals(sourceConfigName)) {
                throw new ConfigException(_strMgr.getString("configurationSourceInvalid", (Object)sourceConfigName));
            }
            Domain domain = ConfigAPIHelper.getDomainConfigBean((ConfigContext)configContext);
            Configs configs = domain.getConfigs();
            Config newConfig = configs.getConfigByName(newConfigName);
            if (newConfig != null) {
                throw new ConfigException(_strMgr.getString("configurationAlreadyExists", (Object)newConfigName));
            }
            if ("domain".equals(newConfigName)) {
                throw new ConfigException(_strMgr.getString("configurationNameRestricted", (Object)newConfigName));
            }
            Servers servers = domain.getServers();
            Server server = servers.getServerByName(newConfigName);
            if (server != null) {
                throw new ConfigException(_strMgr.getString("configurationNameAlreadyExistsAsServer", (Object)newConfigName));
            }
            Clusters clusters = domain.getClusters();
            Cluster cluster = clusters.getClusterByName(newConfigName);
            if (cluster != null) {
                throw new ConfigException(_strMgr.getString("configurationNameAlreadyExistsAsCluster", (Object)newConfigName));
            }
            NodeAgents nas = domain.getNodeAgents();
            NodeAgent na = nas.getNodeAgentByName(newConfigName);
            if (na != null) {
                throw new ConfigException(_strMgr.getString("configurationNameAlreadyExistsAsNodeAgent", (Object)newConfigName));
            }
            newConfig = (Config)sourceConfig.clone();
            newConfig.setConfigContext(sourceConfig.getConfigContext());
            this.addConfigurationProperties(newConfig, props);
            EEDomainsManager mgr = new EEDomainsManager();
            mgr.copyConfigururation(new RepositoryConfig(), sourceConfigName, newConfigName);
            newConfig.setName(newConfigName);
            configs.addConfig(newConfig, true);
        }
        catch (Exception ex) {
            throw ConfigsConfigBean.getExceptionHandler().handleConfigException(ex, "eeadmin.copyConfiguration.Exception", new String[]{sourceConfigName, newConfigName});
        }
    }

    public void deleteConfiguration(String configName) throws ConfigException {
        try {
            ConfigContext configContext = this.getConfigContext();
            if (configName.equals("default-config")) {
                throw new ConfigException(_strMgr.getString("cannotDeleteDefaultConfigTemplate", (Object)"default-config"));
            }
            Config config = ConfigAPIHelper.getConfigByName((ConfigContext)configContext, (String)configName);
            if (ConfigAPIHelper.isConfigurationReferenced((ConfigContext)configContext, (String)configName)) {
                throw new ConfigException(_strMgr.getString("configurationNotEmpty", (Object)configName, (Object)ConfigAPIHelper.getConfigurationReferenceesAsString((ConfigContext)configContext, (String)configName)));
            }
            EEDomainsManager mgr = new EEDomainsManager();
            mgr.deleteConfigururation(new RepositoryConfig(), configName);
            Domain domain = ConfigAPIHelper.getDomainConfigBean((ConfigContext)configContext);
            Configs configs = domain.getConfigs();
            configs.removeConfig(config, true);
        }
        catch (Exception ex) {
            throw ConfigsConfigBean.getExceptionHandler().handleConfigException(ex, "eeadmin.deleteConfiguration.Exception", configName);
        }
    }

    public String[] listConfigurationsAsString(String targetName) throws ConfigException {
        try {
            TargetType[] validTypes = new TargetType[]{TargetType.DOMAIN, TargetType.CLUSTER, TargetType.SERVER, TargetType.DAS, TargetType.CONFIG};
            ConfigContext configContext = this.getConfigContext();
            Target target = TargetBuilder.INSTANCE.createTarget("domain", validTypes, targetName, configContext);
            Config[] configs = target.getConfigs();
            int numConfigs = configs.length;
            String[] result = new String[numConfigs];
            for (int i = 0; i < numConfigs; ++i) {
                result[i] = configs[i].getName();
            }
            return result;
        }
        catch (Exception ex) {
            throw ConfigsConfigBean.getExceptionHandler().handleConfigException(ex, "eeadmin.listConfigurations.Exception", targetName);
        }
    }

    private ServersConfigBean getServersConfigBean() {
        return new ServersConfigBean(this.getConfigContext());
    }

    public boolean getRuntimeStatus(String configName) throws InstanceException {
        try {
            boolean restartRequired = false;
            String[] servers = this.getServersForConfig(configName);
            ServersConfigBean cmb = this.getServersConfigBean();
            RuntimeStatus status = null;
            for (int i = 0; i < servers.length; ++i) {
                try {
                    status = cmb.getRuntimeStatus(servers[i]);
                }
                catch (InstanceException ie) {
                    // empty catch block
                }
                if (status == null || !status.isRestartNeeded()) continue;
                restartRequired = true;
                break;
            }
            return restartRequired;
        }
        catch (Exception ex) {
            throw ConfigsConfigBean.getExceptionHandler().handleInstanceException(ex, "eeadmin.getConfigStatus.Exception", configName);
        }
    }

    private String[] getServersForConfig(String configName) throws ConfigException {
        String[] sa = new String[]{};
        Server[] servers = ServerHelper.getServersReferencingConfig((ConfigContext)this.getConfigContext(), (String)configName);
        if (servers != null) {
            sa = new String[servers.length];
            for (int i = 0; i < sa.length; ++i) {
                sa[i] = servers[i].getName();
            }
        }
        return sa;
    }
}

