/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.clientreg;

import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.admin.util.IAdminConstants;
import com.sun.enterprise.admin.util.JMXConnectorConfig;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.NodeAgentHelper;
import com.sun.enterprise.ee.admin.clientreg.JMXConnectorRegistry;
import com.sun.enterprise.ee.admin.clientreg.MBeanServerConnectionInfo;
import com.sun.enterprise.ee.admin.servermgmt.AgentException;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.IOException;
import javax.management.MBeanServerConnection;

public class NodeAgentRegistry
extends JMXConnectorRegistry
implements IAdminConstants {
    private static final StringManager _strMgr = StringManager.getManager((Class)NodeAgentRegistry.class);
    private static NodeAgentRegistry _registry = null;

    private NodeAgentRegistry() {
        _registry = this;
    }

    public static synchronized NodeAgentRegistry getNodeAgentRegistry() {
        if (_registry == null) {
            _registry = new NodeAgentRegistry();
        }
        return _registry;
    }

    protected MBeanServerConnectionInfo findConnectionInfo(String nodeAgentName) throws AgentException {
        return this.findConnectionInfo(this.getConfigContext(), nodeAgentName);
    }

    protected MBeanServerConnectionInfo findConnectionInfo(ConfigContext configContext, String nodeAgentName) throws AgentException {
        try {
            JMXConnectorConfig config = NodeAgentHelper.getJMXConnectorInfo((ConfigContext)configContext, (String)nodeAgentName);
            return new MBeanServerConnectionInfo(config);
        }
        catch (Exception ex) {
            throw new AgentException(ex);
        }
    }

    private ConfigContext getConfigContext() {
        return AdminService.getAdminService().getAdminContext().getAdminConfigContext();
    }

    public static synchronized MBeanServerConnection getNodeAgentConnection(String nodeAgentName) throws AgentException {
        return NodeAgentRegistry.getNodeAgentRegistry().getConnection(nodeAgentName);
    }

    public static synchronized void removeNodeAgentConnection(String nodeAgentName) {
        try {
            NodeAgentRegistry.getNodeAgentRegistry().removeConnectorFromCache(nodeAgentName);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static synchronized void disconnectNodeAgentConnection(String nodeAgentName) throws AgentException {
        try {
            NodeAgentRegistry.getNodeAgentRegistry().disconnectCachedConnector(nodeAgentName);
        }
        catch (IOException ex) {
            throw new AgentException(ex);
        }
    }

    public static synchronized MBeanServerConnectionInfo getNodeAgentConnectionInfo(ConfigContext configContext, String nodeAgentName) throws AgentException {
        return NodeAgentRegistry.getNodeAgentRegistry().findConnectionInfo(configContext, nodeAgentName);
    }
}

