/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin;

import com.sun.enterprise.ee.admin.PortInUse;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.ArrayList;

public class PortInUseException
extends Exception {
    protected ArrayList _inUse = new ArrayList();
    protected static final StringManager _strMgr = StringManager.getManager((Class)PortInUseException.class);

    public PortInUseException() {
    }

    public PortInUseException(String serverName, String hostName, int port, String propertyName, String conflictingPropertyName) {
        this();
        this.addConflictingPort(new PortInUse(propertyName, port, hostName, serverName, conflictingPropertyName));
    }

    public PortInUseException(String hostName, int port, String propertyName) {
        this();
        this.addConflictingPort(new PortInUse(propertyName, port, hostName));
    }

    private void addConflictingPort(PortInUse port) {
        if (!this.portAlreadyConflicts(port.getPort())) {
            this._inUse.add(port);
        }
    }

    public void augmentException(PortInUseException ex) {
        ArrayList conflictingPorts = ex.getConflictingPorts();
        int numPorts = conflictingPorts.size();
        for (int i = 0; i < numPorts; ++i) {
            this.addConflictingPort((PortInUse)conflictingPorts.get(i));
        }
    }

    public boolean portAlreadyConflicts(int port) {
        PortInUse portInUse = new PortInUse(null, port, null);
        return this._inUse.contains(portInUse);
    }

    public ArrayList getConflictingPorts() {
        return this._inUse;
    }

    public String toString() {
        return this.getMessage();
    }

    public String getLocalizedMessage() {
        return this.getMessage();
    }

    public String getMessage() {
        String result = "";
        int numPorts = this._inUse.size();
        for (int i = 0; i < numPorts; ++i) {
            PortInUse portInUse = (PortInUse)this._inUse.get(i);
            result = portInUse.getConflictingPropertyName() == null ? result + _strMgr.getString("portInUse", (Object)new Integer(portInUse.getPort()), (Object)portInUse.getHostName(), (Object)portInUse.getPropertyName()) : result + _strMgr.getString("portNotUnique", new Object[]{new Integer(portInUse.getPort()), portInUse.getHostName(), portInUse.getPropertyName(), portInUse.getServerName(), portInUse.getConflictingPropertyName()});
            if (i >= numPorts - 1) continue;
            result = result + "\n";
        }
        return result;
    }
}

