/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.event.http;

import com.sun.enterprise.admin.config.ConfigBeanHelper;
import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.AccessLog;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpAccessLog;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.Ssl;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.web.HttpServiceWebContainer;
import com.sun.httpservice.spi.HttpServiceSPIException;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpServiceReconfigHelper {
    public static final String SSL_EVENT = "HSSslEvent";
    public static final String HTTP_LISTENER_EVENT = "HSHttpListenerEvent";
    public static final String VIRTUAL_SERVER_EVENT = "HSVirtualServerEvent";
    public static final String HTTP_SERVICE_EVENT = "HSServiceEvent";
    public static final String HTTP_ACCESS_LOG_EVENT = "HSHttpAccessLogEvent";
    public static final String ACCESS_LOG_EVENT = "HSAccessLogEvent";
    protected static Logger _logger = null;
    protected Level _logLevel = null;

    public void HttpServiceReconfigHelper() {
    }

    public static void initiateReconfig(ConfigContext configContext) throws AdminEventListenerException {
        try {
            Domain domain = ServerBeansFactory.getDomainBean((ConfigContext)configContext);
            HttpService httpService = HttpServiceReconfigHelper.getHttpService(configContext);
            HttpServiceWebContainer hswc = HttpServiceWebContainer.getHttpServiceWebContainer();
            if (HttpServiceReconfigHelper.hasAttributesAndPropertiesResolved(httpService)) {
                hswc.reconfigHttpService(httpService, domain);
            } else {
                _logger.log(Level.WARNING, "restart.required.use_of_system_property.not.permitted");
            }
        }
        catch (ConfigException ce) {
            _logger.log(Level.WARNING, "httpservice.reconfig.domain.could_not_get", ce);
        }
        catch (HttpServiceSPIException hsspie) {
            throw new AdminEventListenerException("httpservice.reconfig.failed", (Throwable)hsspie);
        }
    }

    private static boolean hasAttributesAndPropertiesResolved(HttpService httpService) throws ConfigException {
        VirtualServer[] virtualServers;
        String serverName = System.getProperty("com.sun.aas.instanceName");
        if (httpService != null && !ConfigBeanHelper.checkIfAttributesAndPropertiesAreResolvable((ConfigBean)httpService, (String)serverName)) {
            return false;
        }
        AccessLog accessLog = httpService.getAccessLog();
        if (accessLog != null && !ConfigBeanHelper.checkIfAttributesAndPropertiesAreResolvable((ConfigBean)accessLog, (String)serverName)) {
            return false;
        }
        HttpListener[] httpListeners = httpService.getHttpListener();
        if (httpListeners != null) {
            for (int count = 0; count < httpListeners.length; ++count) {
                if (httpListeners[count] == null) continue;
                if (!ConfigBeanHelper.checkIfAttributesAndPropertiesAreResolvable((ConfigBean)httpListeners[count], (String)serverName)) {
                    return false;
                }
                Ssl ssl = httpListeners[count].getSsl();
                if (ssl == null || ConfigBeanHelper.checkIfAttributesAndPropertiesAreResolvable((ConfigBean)ssl, (String)serverName)) continue;
                return false;
            }
        }
        if ((virtualServers = httpService.getVirtualServer()) != null) {
            for (int count = 0; count < virtualServers.length; ++count) {
                if (virtualServers[count] == null) continue;
                if (!ConfigBeanHelper.checkIfAttributesAndPropertiesAreResolvable((ConfigBean)virtualServers[count], (String)serverName)) {
                    return false;
                }
                HttpAccessLog hal = virtualServers[count].getHttpAccessLog();
                if (hal == null || ConfigBeanHelper.checkIfAttributesAndPropertiesAreResolvable((ConfigBean)hal, (String)serverName)) continue;
                return false;
            }
        }
        return true;
    }

    public static HttpService getHttpService(ConfigContext configContext) {
        try {
            Config config = ServerBeansFactory.getConfigBean((ConfigContext)configContext);
            return config.getHttpService();
        }
        catch (ConfigException ce) {
            _logger.log(Level.WARNING, "httpservice.reconfig.domain.could_not_get", ce);
            return null;
        }
    }

    static {
        _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
    }
}

