/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.event.http;

import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.admin.event.http.HSVirtualServerEvent;
import com.sun.enterprise.admin.event.http.HSVirtualServerEventListener;
import com.sun.enterprise.admin.event.http.HttpServiceReconfigHelper;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.ConfigUpdate;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.web.HttpServiceWebContainer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.logging.Level;
import org.apache.catalina.LifecycleException;

public class HSVirtualServerEventListenerImpl
extends HttpServiceReconfigHelper
implements HSVirtualServerEventListener {
    private static ResourceBundle _rb = null;

    public void handleCreate(HSVirtualServerEvent event) throws AdminEventListenerException {
        Server server = null;
        if (event != null) {
            HttpServiceWebContainer hswc = HttpServiceWebContainer.getHttpServiceWebContainer();
            ConfigContext configContext = event.getConfigContext();
            if (configContext != null) {
                try {
                    server = ServerBeansFactory.getServerBean((ConfigContext)configContext);
                    hswc.createNewHosts(server, HSVirtualServerEventListenerImpl.getHttpService(configContext));
                }
                catch (LifecycleException le) {
                    throw new AdminEventListenerException((Throwable)le);
                }
                catch (ConfigException ce) {
                    String msg = _rb.getString("vs.appsConfigError");
                    _logger.log(Level.WARNING, msg, ce);
                    throw new AdminEventListenerException((Throwable)ce);
                }
                HSVirtualServerEventListenerImpl.initiateReconfig(configContext);
            }
        }
    }

    public void handleUpdate(HSVirtualServerEvent event) throws AdminEventListenerException {
        HttpServiceWebContainer hswc = HttpServiceWebContainer.getHttpServiceWebContainer();
        ConfigContext configContext = event.getConfigContext();
        ConfigUpdate configUpdate = null;
        ArrayList configChangeList = event.getConfigChangeList();
        Iterator iter = configChangeList.iterator();
        VirtualServer vsBean = null;
        Server server = null;
        String xpath = null;
        while (iter.hasNext()) {
            configUpdate = (ConfigUpdate)iter.next();
            try {
                xpath = configUpdate.getXPath();
                if (xpath != null) {
                    vsBean = (VirtualServer)configContext.exactLookup(configUpdate.getXPath());
                    server = ServerBeansFactory.getServerBean((ConfigContext)configContext);
                    if (vsBean.getId().equals("__asadmin")) {
                        String msg = _rb.getString("httpservice.vs.adminvs.nonreconfigurable");
                        throw new AdminEventListenerException(msg);
                    }
                    hswc.updateHosts(vsBean, server);
                }
            }
            catch (ConfigException ce) {
                throw new AdminEventListenerException("httpservice.reconfig.exception", (Throwable)ce);
            }
            catch (LifecycleException le) {
                _logger.log(Level.WARNING, "httpservice.reconfig.lifecycle.exception", le);
            }
            try {
                HSVirtualServerEventListenerImpl.initiateReconfig(configContext);
            }
            catch (AdminEventListenerException ae) {
                throw new AdminEventListenerException("httpservice.reconfig.exception", (Throwable)ae);
            }
        }
    }

    public void handleDelete(HSVirtualServerEvent event) throws AdminEventListenerException {
        if (event != null) {
            HttpServiceWebContainer hswc = HttpServiceWebContainer.getHttpServiceWebContainer();
            ConfigContext configContext = event.getConfigContext();
            if (configContext != null) {
                try {
                    hswc.removeDeletedHosts(HSVirtualServerEventListenerImpl.getHttpService(configContext));
                }
                catch (LifecycleException le) {
                    throw new AdminEventListenerException((Throwable)le);
                }
                HSVirtualServerEventListenerImpl.initiateReconfig(configContext);
            }
        }
    }

    static {
        _rb = _logger.getResourceBundle();
    }
}

