/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.event.http;

import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.admin.event.http.HSAccessLogEvent;
import com.sun.enterprise.admin.event.http.HSAccessLogEventListener;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.AccessLog;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.httpservice.spi.HttpService;
import com.sun.httpservice.spi.HttpServiceLogRotator;
import com.sun.httpservice.spi.HttpServiceSPIException;
import com.sun.logging.LogDomains;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HSAccessLogEventListenerImpl
implements HSAccessLogEventListener {
    private static ResourceBundle _rb = null;
    static Logger _logger = null;

    public void handleCreate(HSAccessLogEvent event) throws AdminEventListenerException {
        ConfigContext context;
        if (event != null && (context = event.getConfigContext()) != null) {
            HSAccessLogEventListenerImpl.reconfig(context);
        }
    }

    public void handleDelete(HSAccessLogEvent event) throws AdminEventListenerException {
        ConfigContext context;
        if (event != null && (context = event.getConfigContext()) != null) {
            HSAccessLogEventListenerImpl.reconfig(context);
        }
    }

    public void handleUpdate(HSAccessLogEvent event) throws AdminEventListenerException {
        ConfigContext context;
        if (event != null && (context = event.getConfigContext()) != null) {
            HSAccessLogEventListenerImpl.reconfig(context);
        }
    }

    private static void reconfig(ConfigContext configContext) throws AdminEventListenerException {
        boolean needStart;
        HttpServiceLogRotator rotator = HttpService.getInstance().getLogRotator();
        Config config = null;
        try {
            config = ServerBeansFactory.getConfigBean((ConfigContext)configContext);
        }
        catch (ConfigException e) {
            String msg = _rb.getString("httpservice.accesslog.rotation.could.not.obtain.config");
            _logger.log(Level.WARNING, msg, e);
            throw new AdminEventListenerException(msg, (Throwable)e);
        }
        com.sun.enterprise.config.serverbeans.HttpService httpServiceBean = config.getHttpService();
        AccessLog accessLog = httpServiceBean.getAccessLog();
        if (rotator.getStatus() == 1) {
            try {
                rotator.stop();
            }
            catch (HttpServiceSPIException ex) {
                _logger.log(Level.WARNING, "httpservice.accesslog.rotation.could.not.stop", ex);
            }
        }
        if (!(needStart = HSAccessLogEventListenerImpl.internalConfig(accessLog, rotator))) {
            return;
        }
        try {
            rotator.start();
        }
        catch (HttpServiceSPIException ex) {
            String msg = _rb.getString("httpservice.accesslog.rotation.could.not.restart");
            _logger.log(Level.WARNING, msg);
            throw new AdminEventListenerException(msg, (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean internalConfig(AccessLog accessLog, HttpServiceLogRotator rotator) {
        block16: {
            if (accessLog == null) {
                String suffix = "%YYYY;%MM;%DD;-%hh;h%mm;m%ss;s";
                rotator.setSuffix(suffix);
                String s_enabled = AccessLog.getDefaultRotationEnabled();
                boolean enabled = Boolean.valueOf(s_enabled);
                if (!enabled) {
                    return false;
                }
                String rotationType = AccessLog.getDefaultRotationPolicy();
                if (rotationType.equals("time")) {
                    long time = Long.parseLong(AccessLog.getDefaultRotationIntervalInMinutes());
                    rotator.setRotationPolicy(2);
                    rotator.setTimeInterval(time *= 60L);
                    break block16;
                } else {
                    if (rotationType.equals("size")) {
                        _logger.log(Level.WARNING, "httpservice.accesslog_rotation.bysize.not.supported");
                        _logger.log(Level.WARNING, "httpservice.accesslog_rotaion.disabled");
                        return false;
                    }
                    _logger.log(Level.WARNING, "httpservice.accesslog_rotation.type.unknown", rotationType);
                    _logger.log(Level.WARNING, "httpservice.accesslog_rotaion.disabled");
                    return false;
                }
            }
            String suffix = accessLog.getRotationSuffix();
            if (suffix == null) {
                suffix = accessLog.getDefaultRotationSuffix();
            }
            rotator.setSuffix(suffix);
            boolean enabled = false;
            String s_enabled = accessLog.getAttributeValue("rotation-enabled");
            if (s_enabled == null || s_enabled.length() == 0) {
                s_enabled = AccessLog.getDefaultRotationEnabled();
                enabled = Boolean.valueOf(s_enabled);
            } else {
                enabled = accessLog.isRotationEnabled();
            }
            if (!enabled) {
                return false;
            }
            String rotationType = accessLog.getRotationPolicy();
            if (rotationType == null) {
                rotationType = accessLog.getDefaultRotationPolicy();
            }
            if (rotationType.equals("size")) {
                _logger.log(Level.WARNING, "httpservice.accesslog_rotation.bysize.not.supported");
                _logger.log(Level.WARNING, "httpservice.accesslog_rotaion.disabled");
                return false;
            }
            if (!rotationType.equals("time")) {
                _logger.log(Level.WARNING, "httpservice.accesslog_rotation.type.unknown", rotationType);
                _logger.log(Level.WARNING, "httpservice.accesslog_rotaion.disabled");
                return false;
            }
            String s_time = accessLog.getRotationIntervalInMinutes();
            if (s_time == null || s_time.length() < 1) {
                _logger.log(Level.FINE, "httpservice.accesslog_rotation.interval.default.value");
                s_time = accessLog.getDefaultRotationIntervalInMinutes();
            }
            long time = 0L;
            try {
                time = Long.parseLong(s_time);
            }
            catch (NumberFormatException nex) {
                _logger.log(Level.WARNING, "httpservice.accesslog_rotation.interval.invalid.value", s_time);
                _logger.log(Level.WARNING, "httpservice.accesslog_rotaion.disabled");
                return false;
            }
            if (time <= 0L) {
                _logger.log(Level.WARNING, "httpservice.accesslog_rotation.interval.invalid.value", s_time);
                _logger.log(Level.WARNING, "httpservice.accesslog_rotaion.disabled");
                return false;
            }
            rotator.setRotationPolicy(2);
            rotator.setTimeInterval(time *= 60L);
        }
        rotator.setEnabled(true);
        return true;
    }

    static {
        _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
        _rb = _logger.getResourceBundle();
    }
}

