/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class JSFBitSet
implements Cloneable,
Serializable {
    private static final int ADDRESS_BITS_PER_UNIT = 6;
    private static final int BITS_PER_UNIT = 64;
    private static final int BIT_INDEX_MASK = 63;
    private static final long WORD_MASK = -1L;
    private long[] bits;
    private transient int unitsInUse = 0;
    private static final long serialVersionUID = 7997698588986878753L;
    private static final byte[] trailingZeroTable = new byte[]{-25, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 7, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0};

    private static int unitIndex(int bitIndex) {
        return bitIndex >> 6;
    }

    private static long bit(int bitIndex) {
        return 1L << (bitIndex & 0x3F);
    }

    private void recalculateUnitsInUse() {
        int i = this.unitsInUse - 1;
        while (i >= 0) {
            if (this.bits[i] != 0L) break;
            --i;
        }
        this.unitsInUse = i + 1;
    }

    public JSFBitSet() {
        this(64);
    }

    public JSFBitSet(int nbits) {
        if (nbits < 0) {
            throw new NegativeArraySizeException("nbits < 0: " + nbits);
        }
        this.bits = new long[JSFBitSet.unitIndex(nbits - 1) + 1];
    }

    private void ensureCapacity(int unitsRequired) {
        if (this.bits.length < unitsRequired) {
            int request = Math.max(2 * this.bits.length, unitsRequired);
            long[] newBits = new long[request];
            System.arraycopy(this.bits, 0, newBits, 0, this.unitsInUse);
            this.bits = newBits;
        }
    }

    public void flip(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int unitIndex = JSFBitSet.unitIndex(bitIndex);
        int unitsRequired = unitIndex + 1;
        if (this.unitsInUse < unitsRequired) {
            this.ensureCapacity(unitsRequired);
            int n = unitIndex;
            this.bits[n] = this.bits[n] ^ JSFBitSet.bit(bitIndex);
            this.unitsInUse = unitsRequired;
        } else {
            int n = unitIndex;
            this.bits[n] = this.bits[n] ^ JSFBitSet.bit(bitIndex);
            if (this.bits[this.unitsInUse - 1] == 0L) {
                this.recalculateUnitsInUse();
            }
        }
    }

    public void flip(int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        if (toIndex < 0) {
            throw new IndexOutOfBoundsException("toIndex < 0: " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + " > toIndex: " + toIndex);
        }
        int endUnitIndex = JSFBitSet.unitIndex(toIndex);
        int unitsRequired = endUnitIndex + 1;
        if (this.unitsInUse < unitsRequired) {
            this.ensureCapacity(unitsRequired);
            this.unitsInUse = unitsRequired;
        }
        int startUnitIndex = JSFBitSet.unitIndex(fromIndex);
        long bitMask = 0L;
        if (startUnitIndex == endUnitIndex) {
            bitMask = (1L << (toIndex & 0x3F)) - (1L << (fromIndex & 0x3F));
            int n = startUnitIndex;
            this.bits[n] = this.bits[n] ^ bitMask;
            if (this.bits[this.unitsInUse - 1] == 0L) {
                this.recalculateUnitsInUse();
            }
            return;
        }
        bitMask = JSFBitSet.bitsLeftOf(fromIndex & 0x3F);
        int n = startUnitIndex;
        this.bits[n] = this.bits[n] ^ bitMask;
        if (endUnitIndex - startUnitIndex > 1) {
            int i = startUnitIndex + 1;
            while (i < endUnitIndex) {
                int n2 = i++;
                this.bits[n2] = this.bits[n2] ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
        bitMask = JSFBitSet.bitsRightOf(toIndex & 0x3F);
        int n3 = endUnitIndex;
        this.bits[n3] = this.bits[n3] ^ bitMask;
        if (this.bits[this.unitsInUse - 1] == 0L) {
            this.recalculateUnitsInUse();
        }
    }

    private static long bitsRightOf(int x) {
        return x == 0 ? 0L : -1L >>> 64 - x;
    }

    private static long bitsLeftOf(int x) {
        return -1L << x;
    }

    public void set(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int unitIndex = JSFBitSet.unitIndex(bitIndex);
        int unitsRequired = unitIndex + 1;
        if (this.unitsInUse < unitsRequired) {
            this.ensureCapacity(unitsRequired);
            int n = unitIndex;
            this.bits[n] = this.bits[n] | JSFBitSet.bit(bitIndex);
            this.unitsInUse = unitsRequired;
        } else {
            int n = unitIndex;
            this.bits[n] = this.bits[n] | JSFBitSet.bit(bitIndex);
        }
    }

    public void set(int bitIndex, boolean value) {
        if (value) {
            this.set(bitIndex);
        } else {
            this.clear(bitIndex);
        }
    }

    public void set(int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        if (toIndex < 0) {
            throw new IndexOutOfBoundsException("toIndex < 0: " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + " > toIndex: " + toIndex);
        }
        int endUnitIndex = JSFBitSet.unitIndex(toIndex);
        int unitsRequired = endUnitIndex + 1;
        if (this.unitsInUse < unitsRequired) {
            this.ensureCapacity(unitsRequired);
            this.unitsInUse = unitsRequired;
        }
        int startUnitIndex = JSFBitSet.unitIndex(fromIndex);
        long bitMask = 0L;
        if (startUnitIndex == endUnitIndex) {
            bitMask = (1L << (toIndex & 0x3F)) - (1L << (fromIndex & 0x3F));
            int n = startUnitIndex;
            this.bits[n] = this.bits[n] | bitMask;
            return;
        }
        bitMask = JSFBitSet.bitsLeftOf(fromIndex & 0x3F);
        int n = startUnitIndex;
        this.bits[n] = this.bits[n] | bitMask;
        if (endUnitIndex - startUnitIndex > 1) {
            int i = startUnitIndex + 1;
            while (i < endUnitIndex) {
                int n2 = i++;
                this.bits[n2] = this.bits[n2] | 0xFFFFFFFFFFFFFFFFL;
            }
        }
        bitMask = JSFBitSet.bitsRightOf(toIndex & 0x3F);
        int n3 = endUnitIndex;
        this.bits[n3] = this.bits[n3] | bitMask;
    }

    public void set(int fromIndex, int toIndex, boolean value) {
        if (value) {
            this.set(fromIndex, toIndex);
        } else {
            this.clear(fromIndex, toIndex);
        }
    }

    public void clear(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int unitIndex = JSFBitSet.unitIndex(bitIndex);
        if (unitIndex >= this.unitsInUse) {
            return;
        }
        int n = unitIndex;
        this.bits[n] = this.bits[n] & (JSFBitSet.bit(bitIndex) ^ 0xFFFFFFFFFFFFFFFFL);
        if (this.bits[this.unitsInUse - 1] == 0L) {
            this.recalculateUnitsInUse();
        }
    }

    public void clear(int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        if (toIndex < 0) {
            throw new IndexOutOfBoundsException("toIndex < 0: " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + " > toIndex: " + toIndex);
        }
        int startUnitIndex = JSFBitSet.unitIndex(fromIndex);
        if (startUnitIndex >= this.unitsInUse) {
            return;
        }
        int endUnitIndex = JSFBitSet.unitIndex(toIndex);
        long bitMask = 0L;
        if (startUnitIndex == endUnitIndex) {
            bitMask = (1L << (toIndex & 0x3F)) - (1L << (fromIndex & 0x3F));
            int n = startUnitIndex;
            this.bits[n] = this.bits[n] & (bitMask ^ 0xFFFFFFFFFFFFFFFFL);
            if (this.bits[this.unitsInUse - 1] == 0L) {
                this.recalculateUnitsInUse();
            }
            return;
        }
        bitMask = JSFBitSet.bitsLeftOf(fromIndex & 0x3F);
        int n = startUnitIndex;
        this.bits[n] = this.bits[n] & (bitMask ^ 0xFFFFFFFFFFFFFFFFL);
        if (endUnitIndex - startUnitIndex > 1) {
            int i = startUnitIndex + 1;
            while (i < endUnitIndex) {
                if (i < this.unitsInUse) {
                    this.bits[i] = 0L;
                }
                ++i;
            }
        }
        if (endUnitIndex < this.unitsInUse) {
            bitMask = JSFBitSet.bitsRightOf(toIndex & 0x3F);
            int n2 = endUnitIndex;
            this.bits[n2] = this.bits[n2] & (bitMask ^ 0xFFFFFFFFFFFFFFFFL);
        }
        if (this.bits[this.unitsInUse - 1] == 0L) {
            this.recalculateUnitsInUse();
        }
    }

    public void clear() {
        while (this.unitsInUse > 0) {
            this.bits[--this.unitsInUse] = 0L;
        }
    }

    public boolean get(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        boolean result = false;
        int unitIndex = JSFBitSet.unitIndex(bitIndex);
        if (unitIndex < this.unitsInUse) {
            result = (this.bits[unitIndex] & JSFBitSet.bit(bitIndex)) != 0L;
        }
        return result;
    }

    public JSFBitSet get(int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        if (toIndex < 0) {
            throw new IndexOutOfBoundsException("toIndex < 0: " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + " > toIndex: " + toIndex);
        }
        if (this.length() <= fromIndex || fromIndex == toIndex) {
            return new JSFBitSet(0);
        }
        if (this.length() < toIndex) {
            toIndex = this.length();
        }
        JSFBitSet result = new JSFBitSet(toIndex - fromIndex);
        int startBitIndex = fromIndex & 0x3F;
        int endBitIndex = toIndex & 0x3F;
        int targetWords = (toIndex - fromIndex + 63) / 64;
        int sourceWords = JSFBitSet.unitIndex(toIndex) - JSFBitSet.unitIndex(fromIndex) + 1;
        int inverseIndex = 64 - startBitIndex;
        int targetIndex = 0;
        int sourceIndex = JSFBitSet.unitIndex(fromIndex);
        while (targetIndex < targetWords - 1) {
            result.bits[targetIndex++] = this.bits[sourceIndex++] >>> startBitIndex | (inverseIndex == 64 ? 0L : this.bits[sourceIndex] << inverseIndex);
        }
        result.bits[targetIndex] = sourceWords == targetWords ? (this.bits[sourceIndex] & JSFBitSet.bitsRightOf(endBitIndex)) >>> startBitIndex : this.bits[sourceIndex++] >>> startBitIndex | (inverseIndex == 64 ? 0L : (this.getBits(sourceIndex) & JSFBitSet.bitsRightOf(endBitIndex)) << inverseIndex);
        result.unitsInUse = targetWords;
        result.recalculateUnitsInUse();
        return result;
    }

    private long getBits(int j) {
        return j < this.unitsInUse ? this.bits[j] : 0L;
    }

    public int nextSetBit(int fromIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        int u = JSFBitSet.unitIndex(fromIndex);
        if (u >= this.unitsInUse) {
            return -1;
        }
        int testIndex = fromIndex & 0x3F;
        long unit = this.bits[u] >> testIndex;
        if (unit == 0L) {
            testIndex = 0;
        }
        while (unit == 0L && u < this.unitsInUse - 1) {
            unit = this.bits[++u];
        }
        if (unit == 0L) {
            return -1;
        }
        return u * 64 + (testIndex += JSFBitSet.trailingZeroCnt(unit));
    }

    private static int trailingZeroCnt(long val) {
        int byteVal = (int)val & 0xFF;
        if (byteVal != 0) {
            return trailingZeroTable[byteVal];
        }
        byteVal = (int)(val >>> 8) & 0xFF;
        if (byteVal != 0) {
            return trailingZeroTable[byteVal] + 8;
        }
        byteVal = (int)(val >>> 16) & 0xFF;
        if (byteVal != 0) {
            return trailingZeroTable[byteVal] + 16;
        }
        byteVal = (int)(val >>> 24) & 0xFF;
        if (byteVal != 0) {
            return trailingZeroTable[byteVal] + 24;
        }
        byteVal = (int)(val >>> 32) & 0xFF;
        if (byteVal != 0) {
            return trailingZeroTable[byteVal] + 32;
        }
        byteVal = (int)(val >>> 40) & 0xFF;
        if (byteVal != 0) {
            return trailingZeroTable[byteVal] + 40;
        }
        byteVal = (int)(val >>> 48) & 0xFF;
        if (byteVal != 0) {
            return trailingZeroTable[byteVal] + 48;
        }
        byteVal = (int)(val >>> 56) & 0xFF;
        return trailingZeroTable[byteVal] + 56;
    }

    public int nextClearBit(int fromIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        int u = JSFBitSet.unitIndex(fromIndex);
        if (u >= this.unitsInUse) {
            return fromIndex;
        }
        int testIndex = fromIndex & 0x3F;
        long unit = this.bits[u] >> testIndex;
        if (unit == -1L >> testIndex) {
            testIndex = 0;
        }
        while (unit == -1L && u < this.unitsInUse - 1) {
            unit = this.bits[++u];
        }
        if (unit == -1L) {
            return this.length();
        }
        if (unit == 0L) {
            return u * 64 + testIndex;
        }
        return u * 64 + (testIndex += JSFBitSet.trailingZeroCnt(unit ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public int length() {
        if (this.unitsInUse == 0) {
            return 0;
        }
        long highestUnit = this.bits[this.unitsInUse - 1];
        int highPart = (int)(highestUnit >>> 32);
        return 64 * (this.unitsInUse - 1) + (highPart == 0 ? JSFBitSet.bitLen((int)highestUnit) : 32 + JSFBitSet.bitLen(highPart));
    }

    private static int bitLen(int w) {
        return w < 32768 ? (w < 128 ? (w < 8 ? (w < 2 ? (w < 1 ? (w < 0 ? 32 : 0) : 1) : (w < 4 ? 2 : 3)) : (w < 32 ? (w < 16 ? 4 : 5) : (w < 64 ? 6 : 7))) : (w < 2048 ? (w < 512 ? (w < 256 ? 8 : 9) : (w < 1024 ? 10 : 11)) : (w < 8192 ? (w < 4096 ? 12 : 13) : (w < 16384 ? 14 : 15)))) : (w < 0x800000 ? (w < 524288 ? (w < 131072 ? (w < 65536 ? 16 : 17) : (w < 262144 ? 18 : 19)) : (w < 0x200000 ? (w < 0x100000 ? 20 : 21) : (w < 0x400000 ? 22 : 23))) : (w < 0x8000000 ? (w < 0x2000000 ? (w < 0x1000000 ? 24 : 25) : (w < 0x4000000 ? 26 : 27)) : (w < 0x20000000 ? (w < 0x10000000 ? 28 : 29) : (w < 0x40000000 ? 30 : 31))));
    }

    public boolean isEmpty() {
        return this.unitsInUse == 0;
    }

    public boolean intersects(JSFBitSet set) {
        int i = Math.min(this.unitsInUse, set.unitsInUse) - 1;
        while (i >= 0) {
            if ((this.bits[i] & set.bits[i]) != 0L) {
                return true;
            }
            --i;
        }
        return false;
    }

    public int cardinality() {
        int sum = 0;
        int i = 0;
        while (i < this.unitsInUse) {
            sum += JSFBitSet.bitCount(this.bits[i]);
            ++i;
        }
        return sum;
    }

    private static int bitCount(long val) {
        val -= (val & 0xAAAAAAAAAAAAAAAAL) >>> 1;
        val = (val & 0x3333333333333333L) + (val >>> 2 & 0x3333333333333333L);
        val = val + (val >>> 4) & 0xF0F0F0F0F0F0F0FL;
        val += val >>> 8;
        val += val >>> 16;
        return (int)val + (int)(val >>> 32) & 0xFF;
    }

    public void and(JSFBitSet set) {
        if (this == set) {
            return;
        }
        int oldUnitsInUse = this.unitsInUse;
        this.unitsInUse = Math.min(this.unitsInUse, set.unitsInUse);
        int i = 0;
        while (i < this.unitsInUse) {
            int n = i;
            this.bits[n] = this.bits[n] & set.bits[i];
            ++i;
        }
        while (i < oldUnitsInUse) {
            this.bits[i] = 0L;
            ++i;
        }
        if (this.unitsInUse > 0 && this.bits[this.unitsInUse - 1] == 0L) {
            this.recalculateUnitsInUse();
        }
    }

    public void or(JSFBitSet set) {
        if (this == set) {
            return;
        }
        this.ensureCapacity(set.unitsInUse);
        int unitsInCommon = Math.min(this.unitsInUse, set.unitsInUse);
        int i = 0;
        while (i < unitsInCommon) {
            int n = i;
            this.bits[n] = this.bits[n] | set.bits[i];
            ++i;
        }
        while (i < set.unitsInUse) {
            this.bits[i] = set.bits[i];
            ++i;
        }
        if (this.unitsInUse < set.unitsInUse) {
            this.unitsInUse = set.unitsInUse;
        }
    }

    public void xor(JSFBitSet set) {
        int unitsInCommon;
        if (this.unitsInUse >= set.unitsInUse) {
            unitsInCommon = set.unitsInUse;
        } else {
            unitsInCommon = this.unitsInUse;
            int newUnitsInUse = set.unitsInUse;
            this.ensureCapacity(newUnitsInUse);
            this.unitsInUse = newUnitsInUse;
        }
        int i = 0;
        while (i < unitsInCommon) {
            int n = i;
            this.bits[n] = this.bits[n] ^ set.bits[i];
            ++i;
        }
        while (i < set.unitsInUse) {
            this.bits[i] = set.bits[i];
            ++i;
        }
        this.recalculateUnitsInUse();
    }

    public void andNot(JSFBitSet set) {
        int unitsInCommon = Math.min(this.unitsInUse, set.unitsInUse);
        int i = 0;
        while (i < unitsInCommon) {
            int n = i;
            this.bits[n] = this.bits[n] & (set.bits[i] ^ 0xFFFFFFFFFFFFFFFFL);
            ++i;
        }
        this.recalculateUnitsInUse();
    }

    public int hashCode() {
        long h = 1234L;
        int i = this.bits.length;
        while (--i >= 0) {
            h ^= this.bits[i] * (long)(i + 1);
        }
        return (int)(h >> 32 ^ h);
    }

    public int size() {
        return this.bits.length << 6;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JSFBitSet)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        JSFBitSet set = (JSFBitSet)obj;
        int minUnitsInUse = Math.min(this.unitsInUse, set.unitsInUse);
        int i = 0;
        while (i < minUnitsInUse) {
            if (this.bits[i] != set.bits[i]) {
                return false;
            }
            ++i;
        }
        if (this.unitsInUse > minUnitsInUse) {
            int i2 = minUnitsInUse;
            while (i2 < this.unitsInUse) {
                if (this.bits[i2] != 0L) {
                    return false;
                }
                ++i2;
            }
        } else {
            int i3 = minUnitsInUse;
            while (i3 < set.unitsInUse) {
                if (set.bits[i3] != 0L) {
                    return false;
                }
                ++i3;
            }
        }
        return true;
    }

    public Object clone() {
        JSFBitSet result = null;
        try {
            result = (JSFBitSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        result.bits = new long[this.bits.length];
        System.arraycopy(this.bits, 0, result.bits, 0, this.unitsInUse);
        return result;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.unitsInUse = this.bits.length;
        this.recalculateUnitsInUse();
    }

    public String toString() {
        int numBits = this.unitsInUse << 6;
        StringBuffer buffer = new StringBuffer(8 * numBits + 2);
        String separator = "";
        buffer.append('{');
        int i = 0;
        while (i < numBits) {
            if (this.get(i)) {
                buffer.append(separator);
                separator = ", ";
                buffer.append(i);
            }
            ++i;
        }
        buffer.append('}');
        return buffer.toString();
    }
}

