/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.util.TreeStructure;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.faces.application.StateManager;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StateManagerImpl
extends StateManager {
    private static final Log log = LogFactory.getLog((Class)(class$com$sun$faces$application$StateManagerImpl == null ? (class$com$sun$faces$application$StateManagerImpl = StateManagerImpl.class$("com.sun.faces.application.StateManagerImpl")) : class$com$sun$faces$application$StateManagerImpl));
    private static final String NUMBER_OF_VIEWS_IN_SESSION = "com.sun.faces.NUMBER_OF_VIEWS_IN_SESSION";
    private static final int DEFAULT_NUMBER_OF_VIEWS_IN_SESSION = 15;
    private static final String FACES_VIEW_LIST = "com.sun.faces.VIEW_LIST";
    private static final String ENABLE_HA_PARAM = "enableHighAvailability";
    private static final String JSF_ENABLE_HA_PARAM = "com.sun.faces.enableHighAvailability";
    private static final String APPSERVER_ENABLE_HA_PARAM = "com.sun.appserver.enableHighAvailability";
    int noOfViews = 0;
    private Boolean haStateSavingSet = null;
    static /* synthetic */ Class class$com$sun$faces$application$StateManagerImpl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StateManager.SerializedView saveSerializedView(FacesContext context) throws IllegalStateException {
        StateManager.SerializedView result = null;
        UIViewRoot viewRoot = context.getViewRoot();
        if (viewRoot.isTransient()) {
            return result;
        }
        this.removeTransientChildrenAndFacets(context, (UIComponent)viewRoot, new HashSet());
        if (!this.isSavingStateInClient(context)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Begin saving view in session for viewId " + viewRoot.getViewId()));
            }
            Map sessionMap = Util.getSessionMap(context);
            StateManagerImpl stateManagerImpl = this;
            synchronized (stateManagerImpl) {
                ArrayList<String> viewList = (ArrayList<String>)sessionMap.get(FACES_VIEW_LIST);
                if (viewList == null) {
                    viewList = new ArrayList<String>();
                }
                boolean foundMatch = false;
                int i = 0;
                int size = viewList.size();
                while (i < size) {
                    if (viewList.get(i).equals(viewRoot.getViewId())) {
                        foundMatch = true;
                        break;
                    }
                    ++i;
                }
                if (!foundMatch) {
                    viewList.add(viewRoot.getViewId());
                }
                sessionMap.put(FACES_VIEW_LIST, viewList);
                if (this.isHAStateSavingSet(context)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Highly Available state saving option enabled ");
                        log.debug((Object)("Begin creating serialized view for " + viewRoot.getViewId()));
                    }
                    result = new StateManager.SerializedView((StateManager)this, this.getTreeStructureToSave(context), this.getComponentStateToSave(context));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("End creating serialized view " + viewRoot.getViewId()));
                    }
                    sessionMap.put(viewRoot.getViewId(), new SerializedViewDecorator(result));
                } else {
                    sessionMap.put(viewRoot.getViewId(), viewRoot);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("End saving view in session for viewId " + viewRoot.getViewId()));
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Begin creating serialized view for " + viewRoot.getViewId()));
            }
            result = new StateManager.SerializedView((StateManager)this, this.getTreeStructureToSave(context), this.getComponentStateToSave(context));
            if (log.isDebugEnabled()) {
                log.debug((Object)("End creating serialized view " + viewRoot.getViewId()));
            }
        }
        return result;
    }

    protected void removeTransientChildrenAndFacets(FacesContext context, UIComponent component, Set componentIds) throws IllegalStateException {
        String id;
        UIComponent kid;
        Iterator<Object> kids = component.getChildren().iterator();
        while (kids.hasNext()) {
            kid = (UIComponent)kids.next();
            id = kid.getClientId(context);
            if (id != null && !componentIds.add(id)) {
                throw new IllegalStateException(Util.getExceptionMessageString("com.sun.faces.DUPLICATE_COMPONENT_ID_ERROR", new Object[]{id}));
            }
            if (kid.isTransient()) {
                kids.remove();
                continue;
            }
            this.removeTransientChildrenAndFacets(context, kid, componentIds);
        }
        kids = component.getFacets().values().iterator();
        while (kids.hasNext()) {
            kid = (UIComponent)kids.next();
            id = kid.getClientId(context);
            if (id != null && !componentIds.add(id)) {
                throw new IllegalStateException(Util.getExceptionMessageString("com.sun.faces.DUPLICATE_COMPONENT_ID_ERROR", new Object[]{id}));
            }
            if (kid.isTransient()) {
                kids.remove();
                continue;
            }
            this.removeTransientChildrenAndFacets(context, kid, componentIds);
        }
    }

    protected Object getComponentStateToSave(FacesContext context) {
        UIViewRoot viewRoot = context.getViewRoot();
        return viewRoot.processSaveState(context);
    }

    protected Object getTreeStructureToSave(FacesContext context) {
        TreeStructure structRoot = null;
        UIViewRoot viewRoot = context.getViewRoot();
        if (!viewRoot.isTransient()) {
            structRoot = new TreeStructure((UIComponent)viewRoot);
            this.buildTreeStructureToSave(context, (UIComponent)viewRoot, structRoot, null);
        }
        return structRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UIViewRoot restoreView(FacesContext context, String viewId, String renderKitId) {
        if (null == renderKitId) {
            String message = Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR");
            message = message + " renderKitId " + renderKitId;
            throw new IllegalArgumentException(message);
        }
        UIViewRoot viewRoot = null;
        if (this.isSavingStateInClient(context)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Begin restoring view from response " + viewId));
            }
            if ((viewRoot = this.restoreTreeStructure(context, viewId, renderKitId)) != null) {
                this.restoreComponentState(context, viewRoot, renderKitId);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Possibly a new request. Tree structure could not  be restored for " + viewId));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("End restoring view from response " + viewId));
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Begin restoring view in session for viewId " + viewId));
            }
            Map sessionMap = Util.getSessionMap(context);
            StateManagerImpl stateManagerImpl = this;
            synchronized (stateManagerImpl) {
                if (this.isHAStateSavingSet(context)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"High available state saving option enabled");
                        log.debug((Object)("Begin restoring serialized view for " + viewId));
                    }
                    StateManager.SerializedView serializedView = null;
                    SerializedViewDecorator serializedViewDecorator = (SerializedViewDecorator)sessionMap.get(viewId);
                    if (serializedViewDecorator != null) {
                        serializedView = serializedViewDecorator.getSerializedView(context);
                    }
                    viewRoot = this.restoreSerializedView(context, serializedView, viewId);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("End restoring serialized view " + viewId));
                    }
                } else {
                    viewRoot = (UIViewRoot)sessionMap.get(viewId);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Restoring view from session for viewId " + viewId));
                    }
                }
                this.removeViewFromSession(context, viewRoot);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("End restoring view in session for viewId " + viewId));
            }
        }
        return viewRoot;
    }

    private void removeViewFromSession(FacesContext context, UIViewRoot viewRoot) {
        ArrayList viewList;
        Map sessionMap;
        block7: {
            sessionMap = Util.getSessionMap(context);
            viewList = (ArrayList)sessionMap.get(FACES_VIEW_LIST);
            if (viewList == null) {
                return;
            }
            if (this.noOfViews == 0) {
                this.noOfViews = 15;
                String noViews = context.getExternalContext().getInitParameter(NUMBER_OF_VIEWS_IN_SESSION);
                if (noViews != null) {
                    try {
                        this.noOfViews = Integer.valueOf(noViews);
                    }
                    catch (NumberFormatException nfe) {
                        this.noOfViews = 15;
                        if (!log.isDebugEnabled()) break block7;
                        log.debug((Object)("Error parsing the servetInitParameter com.sun.faces.NUMBER_OF_VIEWS_IN_SESSION. Using the default " + this.noOfViews));
                    }
                }
            }
        }
        if (viewList.size() > this.noOfViews) {
            String viewToRemove = (String)viewList.remove(0);
            sessionMap.remove(viewToRemove);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Number of views in session exceeded specified number " + this.noOfViews + ".Removing view " + viewToRemove));
            }
        }
    }

    protected void restoreComponentState(FacesContext context, UIViewRoot root, String renderKitId) {
        if (null == renderKitId) {
            String message = Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR");
            message = message + " renderKitId " + renderKitId;
            throw new IllegalArgumentException(message);
        }
        Object state = Util.getResponseStateManager(context, renderKitId).getComponentStateToRestore(context);
        root.processRestoreState(context, state);
    }

    protected UIViewRoot restoreTreeStructure(FacesContext context, String viewId, String renderKitId) {
        if (null == renderKitId) {
            String message = Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR");
            message = message + " renderKitId " + renderKitId;
            throw new IllegalArgumentException(message);
        }
        UIComponent viewRoot = null;
        TreeStructure structRoot = null;
        structRoot = (TreeStructure)Util.getResponseStateManager(context, renderKitId).getTreeStructureToRestore(context, viewId);
        if (structRoot == null) {
            return null;
        }
        viewRoot = structRoot.createComponent();
        this.restoreComponentTreeStructure(structRoot, viewRoot);
        return (UIViewRoot)viewRoot;
    }

    public void writeState(FacesContext context, StateManager.SerializedView state) throws IOException {
        if (this.isSavingStateInClient(context)) {
            Util.getResponseStateManager(context, context.getViewRoot().getRenderKitId()).writeState(context, state);
        }
    }

    public void buildTreeStructureToSave(FacesContext context, UIComponent component, TreeStructure treeStructure, Set componentIds) {
        String id;
        if (null == componentIds) {
            componentIds = new HashSet<String>();
        }
        Iterator kids = component.getChildren().iterator();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            id = kid.getClientId(context);
            if (id != null && !componentIds.add(id)) {
                throw new IllegalStateException(Util.getExceptionMessageString("com.sun.faces.DUPLICATE_COMPONENT_ID_ERROR", new Object[]{id}));
            }
            if (kid.isTransient()) continue;
            TreeStructure treeStructureChild = new TreeStructure(kid);
            treeStructure.addChild(treeStructureChild);
            this.buildTreeStructureToSave(context, kid, treeStructureChild, componentIds);
        }
        Iterator facets = component.getFacets().keySet().iterator();
        while (facets.hasNext()) {
            String facetName = (String)facets.next();
            UIComponent facetComponent = (UIComponent)component.getFacets().get(facetName);
            id = facetComponent.getClientId(context);
            if (id != null && !componentIds.add(id)) {
                throw new IllegalStateException(Util.getExceptionMessageString("com.sun.faces.DUPLICATE_COMPONENT_ID_ERROR", new Object[]{id}));
            }
            if (facetComponent.isTransient()) continue;
            TreeStructure treeStructureFacet = new TreeStructure(facetComponent);
            treeStructure.addFacet(facetName, treeStructureFacet);
            this.buildTreeStructureToSave(context, facetComponent, treeStructureFacet, componentIds);
        }
    }

    public void restoreComponentTreeStructure(TreeStructure treeStructure, UIComponent component) {
        Iterator kids = treeStructure.getChildren();
        while (kids.hasNext()) {
            TreeStructure kid = (TreeStructure)kids.next();
            UIComponent child = kid.createComponent();
            component.getChildren().add(child);
            this.restoreComponentTreeStructure(kid, child);
        }
        Iterator facets = treeStructure.getFacetNames();
        while (facets.hasNext()) {
            String facetName = (String)facets.next();
            TreeStructure facetTreeStructure = treeStructure.getTreeStructureForFacet(facetName);
            UIComponent facetComponent = facetTreeStructure.createComponent();
            component.getFacets().put(facetName, facetComponent);
            this.restoreComponentTreeStructure(facetTreeStructure, facetComponent);
        }
    }

    protected boolean isHAStateSavingSet(FacesContext context) {
        if (null != this.haStateSavingSet) {
            return this.haStateSavingSet;
        }
        this.haStateSavingSet = Boolean.FALSE;
        String haStateSavingParam = context.getExternalContext().getInitParameter(JSF_ENABLE_HA_PARAM);
        if (haStateSavingParam != null) {
            this.haStateSavingSet = Boolean.valueOf(haStateSavingParam);
        } else {
            haStateSavingParam = context.getExternalContext().getInitParameter(APPSERVER_ENABLE_HA_PARAM);
            if (haStateSavingParam != null) {
                this.haStateSavingSet = Boolean.valueOf(haStateSavingParam);
            }
        }
        return this.haStateSavingSet;
    }

    protected UIViewRoot restoreSerializedView(FacesContext context, StateManager.SerializedView sv, String viewId) {
        if (sv == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Possibly a new request. Tree structure could not  be restored for " + viewId));
            }
            return null;
        }
        TreeStructure structRoot = (TreeStructure)sv.getStructure();
        if (structRoot == null) {
            return null;
        }
        UIComponent viewRoot = structRoot.createComponent();
        if (viewRoot != null) {
            this.restoreComponentTreeStructure(structRoot, viewRoot);
            Object state = sv.getState();
            viewRoot.processRestoreState(context, state);
        }
        return (UIViewRoot)viewRoot;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class SerializedViewDecorator
    implements Serializable {
        private Object structure;
        private Object state;

        public SerializedViewDecorator(StateManager.SerializedView originalView) {
            this.state = originalView.getState();
            this.structure = originalView.getStructure();
        }

        public StateManager.SerializedView getSerializedView(FacesContext context) {
            StateManager stateManager = context.getApplication().getStateManager();
            stateManager.getClass();
            return new StateManager.SerializedView(stateManager, this.structure, this.state);
        }
    }
}

