/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.guiframework.view;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.Model;
import com.iplanet.jato.view.View;
import com.sun.enterprise.tools.guiframework.exception.FrameworkError;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.DescriptorCCWizardPage;
import com.sun.enterprise.tools.guiframework.view.DescriptorContainerView;
import com.sun.enterprise.tools.guiframework.view.DescriptorViewHelper;
import com.sun.enterprise.tools.guiframework.view.ViewDescriptorManager;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import com.sun.web.ui.model.wizard.WizardEvent;
import com.sun.web.ui.model.wizard.WizardInterface;
import com.sun.web.ui.view.wizard.CCWizard;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DescriptorWizardImpl
implements WizardInterface,
Serializable {
    public static final String RESOURCE_BUNDLE = "resourceBundle";
    public static final String WIZARD_TITLE = "title";
    public static final String WIZARD_WINDOW_PARAMETER_NAME = "WizardWindow.wizName";
    private ViewDescriptor _viewDesc = null;
    private String _resourceBundle = "test.Resources";
    private String _title = "WizardWindow";
    private String _wizName = null;
    private List _wizardPages = new ArrayList();

    public DescriptorWizardImpl(RequestContext ctx, String name) {
        if (name == null) {
            throw new FrameworkException("Wizard name cannot be null!  It is required to find the ViewDescriptor!");
        }
        this.setName(name);
        ViewDescriptor viewDesc = ViewDescriptorManager.getInstance().getViewDescriptor(name);
        if (viewDesc == null) {
            throw new FrameworkException("ViewDescriptor for wizard '" + name + "' not found!");
        }
        this.setViewDescriptor(viewDesc);
    }

    protected void initialize(ViewDescriptor desc) {
        this.setResourceBundle("" + desc.getParameter(RESOURCE_BUNDLE));
        this.setTitle("" + desc.getParameter(WIZARD_TITLE));
        List pages = desc.getChildDescriptors();
        Iterator it = pages.iterator();
        while (it.hasNext()) {
            this.addWizardPage(new WizardPage((ViewDescriptor)it.next()));
        }
    }

    public RequestContext getRequestContext() {
        return RequestManager.getRequestContext();
    }

    protected void setViewDescriptor(ViewDescriptor desc) {
        this._viewDesc = desc;
        this.initialize(desc);
    }

    public ViewDescriptor getViewDescriptor() {
        return this._viewDesc;
    }

    protected void addWizardPage(WizardPage wizardPage) {
        this.getWizardPages().add(wizardPage);
    }

    protected void setWizardPages(List pages) {
        this._wizardPages = pages;
    }

    public List getWizardPages() {
        return this._wizardPages;
    }

    public WizardPage getWizardPage(String pageId) {
        return this.getWizardPage(this.pageIdToPage(pageId));
    }

    public WizardPage getWizardPage(int index) {
        return (WizardPage)this.getWizardPages().get(index);
    }

    public static WizardInterface create(RequestContext ctx) {
        String wizardName = ctx.getRequest().getParameter(WIZARD_WINDOW_PARAMETER_NAME);
        return new DescriptorWizardImpl(ctx, wizardName);
    }

    public String getName() {
        return this._wizName;
    }

    public void setName(String name) {
        this._wizName = name;
    }

    public Model getPageModel(String pageId) {
        WizardPage page = this.getWizardPage(pageId);
        return page.getModel();
    }

    public Class getPageClass(String pageId) {
        this.getRequestContext().getRequest().setAttribute("_VD_NAME", (Object)this.getWizardPage(pageId).getName());
        return DescriptorCCWizardPage.class;
    }

    public String getPageName(String pageId) {
        return this.getWizardPage(pageId).getName();
    }

    public String getFirstPageId() {
        return this.pageToPageId(0);
    }

    public String getNextPageId(String pageId) {
        return this.pageToPageId(this.pageIdToPage(pageId) + 1);
    }

    public String getResourceBundle() {
        return this._resourceBundle;
    }

    public void setResourceBundle(String resBundle) {
        this._resourceBundle = resBundle;
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public String getStepTitle(String pageId) {
        return this.getWizardPage(pageId).getStepText();
    }

    public String[] getFuturePages(String currentPageId) {
        int page = this.pageIdToPage(currentPageId) + 1;
        List pages = this.getWizardPages();
        int howMany = pages.size() - page;
        String[] futurePages = new String[howMany];
        int i = 0;
        while (i < howMany) {
            futurePages[i] = "" + page;
            ++i;
            ++page;
        }
        return futurePages;
    }

    public String[] getFutureSteps(String currentPageId) {
        int page = this.pageIdToPage(currentPageId) + 1;
        List pages = this.getWizardPages();
        int howMany = pages.size() - page;
        String[] futureSteps = new String[howMany];
        int i = 0;
        while (i < howMany) {
            futureSteps[i] = ((WizardPage)pages.get(page)).getStepText();
            ++i;
            ++page;
        }
        return futureSteps;
    }

    public String getStepInstruction(String pageId) {
        return this.getWizardPage(pageId).getStepInstructions();
    }

    public String getStepText(String pageId) {
        return this.getWizardPage(pageId).getStepText();
    }

    public String[] getStepHelp(String pageId) {
        return this.getWizardPage(pageId).getStepHelp();
    }

    public boolean isFinishPageId(String pageId) {
        return this.pageIdToPage(pageId) == this.getWizardPages().size() - 1;
    }

    public boolean hasPreviousPageId(String pageId) {
        return !this.getFirstPageId().equals(pageId);
    }

    public String getCancelPrompt(String pageId) {
        return this.getWizardPage(pageId).getCancelPrompt();
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.getName() + ") with " + this.getWizardPages().size() + " pages.";
    }

    public boolean done(String wizardName) {
        RequestContext rc = this.getRequestContext();
        WizardEvent event = new WizardEvent(rc, null, null, null, wizardName);
        try {
            return DescriptorViewHelper.endWizard(this.getViewDescriptor(), event);
        }
        catch (Exception ex) {
            throw new FrameworkError(ex, this.getViewDescriptor(), event.getView());
        }
    }

    public boolean nextStep(WizardEvent wizardEvent) {
        RequestContext rc = this.getRequestContext();
        try {
            return DescriptorViewHelper.nextWizardStep((DescriptorContainerView)wizardEvent.getView(), wizardEvent);
        }
        catch (Exception ex) {
            throw new FrameworkError(ex, this.getViewDescriptor(), wizardEvent.getView());
        }
    }

    public boolean previousStep(WizardEvent wizardEvent) {
        RequestContext rc = this.getRequestContext();
        try {
            return DescriptorViewHelper.prevWizardStep((DescriptorContainerView)wizardEvent.getView(), wizardEvent);
        }
        catch (Exception ex) {
            throw new FrameworkError(ex, this.getViewDescriptor(), wizardEvent.getView());
        }
    }

    public boolean gotoStep(WizardEvent wizardEvent) {
        RequestContext rc = this.getRequestContext();
        try {
            return DescriptorViewHelper.goToWizardStep((DescriptorContainerView)wizardEvent.getView(), wizardEvent);
        }
        catch (Exception ex) {
            throw new FrameworkError(ex, this.getViewDescriptor(), wizardEvent.getView());
        }
    }

    public boolean finishStep(WizardEvent wizardEvent) {
        RequestContext rc = this.getRequestContext();
        try {
            boolean result = DescriptorViewHelper.finishWizardStep((DescriptorContainerView)wizardEvent.getView(), wizardEvent);
            if (!result) {
                this.stopWizardFromClosing(wizardEvent.getView().getParent());
            }
            return result;
        }
        catch (Throwable ex) {
            this.stopWizardFromClosing(wizardEvent.getView().getParent());
            throw new FrameworkError(ex, this.getViewDescriptor(), wizardEvent.getView());
        }
    }

    private void stopWizardFromClosing(View view) {
        if (!(view instanceof CCWizard)) {
            return;
        }
        try {
            int idx;
            Field[] fields = view.getClass().getDeclaredFields();
            for (idx = 0; idx < fields.length && !fields[idx].getName().equals("isFinishRequest"); ++idx) {
            }
            fields[idx].setAccessible(true);
            fields[idx].setBoolean(view, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean cancelStep(WizardEvent wizardEvent) {
        RequestContext rc = this.getRequestContext();
        try {
            return DescriptorViewHelper.cancelWizardStep((DescriptorContainerView)wizardEvent.getView(), wizardEvent);
        }
        catch (Exception ex) {
            throw new FrameworkError(ex, this.getViewDescriptor(), wizardEvent.getView());
        }
    }

    public boolean warnOnRevisitStep() {
        return false;
    }

    private String pageToPageId(int page) {
        return Integer.toString(page + 1);
    }

    private int pageIdToPage(String pageId) {
        return Integer.parseInt(pageId) - 1;
    }

    protected class WizardPage
    implements Serializable {
        public static final String PAGE_NAME = "pageName";
        public static final String CANCEL_PROMPT = "cancelPrompt";
        public static final String STEP_HELP = "stepHelp";
        public static final String STEP_INSTRUCTIONS = "stepInstructions";
        public static final String STEP_TEXT = "stepText";
        public static final String PAGE_MODEL_CLASS = "wizardPageModelClass";
        public static final String PAGE_MODEL_NAME = "wizardPageModelName";
        private String _cancelPrompt = "";
        private String _name = "";
        private String[] _stepHelp = new String[]{""};
        private String _stepInstructions = "";
        private String _stepText = "";
        private String _modelClass = "com.iplanet.jato.model.DefaultModel";
        private String _modelName = "_wizModel";

        public WizardPage(ViewDescriptor viewDesc) {
            this.initialize(viewDesc);
        }

        protected void initialize(ViewDescriptor viewDesc) {
            this.setName(viewDesc.getName());
            this.setStepText("" + viewDesc.getParameter(STEP_TEXT));
            this.setStepInstructions("" + viewDesc.getParameter(STEP_INSTRUCTIONS));
            this.setCancelPrompt("" + viewDesc.getParameter(CANCEL_PROMPT));
            this.setPageModelName((String)viewDesc.getParameter(PAGE_MODEL_NAME));
            this.setPageModelClass((String)viewDesc.getParameter(PAGE_MODEL_CLASS));
            List stepHelp = (List)viewDesc.getParameter(STEP_HELP);
            if (stepHelp != null) {
                this.setStepHelp(stepHelp.toArray(new String[stepHelp.size()]));
            }
        }

        public void setName(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public void setStepText(String stepText) {
            this._stepText = stepText;
        }

        public String getStepText() {
            return this._stepText;
        }

        public void setStepInstructions(String stepInstructions) {
            this._stepInstructions = stepInstructions;
        }

        public String getStepInstructions() {
            return this._stepInstructions;
        }

        public void setStepHelp(String[] stepHelp) {
            this._stepHelp = stepHelp;
        }

        public String[] getStepHelp() {
            return this._stepHelp;
        }

        public void setCancelPrompt(String cancelPrompt) {
            this._cancelPrompt = cancelPrompt;
        }

        public String getCancelPrompt() {
            return this._cancelPrompt;
        }

        public void setPageModelName(String modelName) {
            if (modelName == null) {
                return;
            }
            this._modelName = modelName;
        }

        public String getPageModelName() {
            return this._modelName;
        }

        public void setPageModelClass(String modelClass) {
            if (modelClass == null) {
                return;
            }
            this._modelClass = modelClass;
        }

        public String getPageModelClass() {
            return this._modelClass;
        }

        public Model getModel() {
            try {
                return DescriptorWizardImpl.this.getRequestContext().getModelManager().getModel(this.getPageModelClass(), this.getPageModelName(), true, true);
            }
            catch (ClassNotFoundException ex) {
                throw new FrameworkException("Unable to get to model for wizard '" + this.getName() + "', page '" + this.getName() + "'.", (Throwable)ex, null, null);
            }
        }
    }
}

