/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.guiframework.util;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Util {
    public static Map _dataSourceMap = new HashMap();
    public static final String ATTRIBUTE = "attribute";
    public static final String PAGE_SESSION = "pageSession";
    public static final String PARAMETER = "parameter";
    public static final String SESSION = "session";
    public static final String REQUEST_PARAMETER = "requestParameter";
    public static final String DISPLAY = "display";
    public static final String THIS = "this";
    public static final String ESCAPE = "escape";
    public static final String SUB_START = "$";
    public static final String SUB_TYPE_DELIM = "(";
    public static final String SUB_END = ")";

    public static Object replaceVariableWithAttribute(RequestContext ctx, ViewDescriptor vd, String string, String startToken, String typeDelim, String endToken) {
        int stringLen = string.length();
        int startTokenLen = startToken.length();
        int delimLen = typeDelim.length();
        int endTokenLen = endToken.length();
        boolean expressionIsWholeString = false;
        char firstEndChar = SUB_END.charAt(0);
        char firstDelimChar = SUB_TYPE_DELIM.charAt(0);
        int startIndex = string.lastIndexOf(startToken);
        while (startIndex != -1) {
            int delimIndex = string.indexOf(typeDelim, startIndex + startTokenLen);
            if (delimIndex != -1) {
                int parenSemi = 0;
                int endIndex = -1;
                int curr = delimIndex + delimLen;
                while (curr < stringLen) {
                    char currChar = string.charAt(curr);
                    if (currChar == firstDelimChar && typeDelim.equals(string.substring(curr, curr + delimLen))) {
                        ++parenSemi;
                        curr += delimLen;
                        continue;
                    }
                    if (currChar == firstEndChar && endToken.equals(string.substring(curr, curr + endTokenLen))) {
                        if (--parenSemi < 0) {
                            endIndex = curr;
                            break;
                        }
                        curr += endTokenLen;
                        continue;
                    }
                    ++curr;
                }
                if (endIndex != -1) {
                    String type;
                    DataSource ds;
                    if (startIndex == 0 && endIndex == string.lastIndexOf(endToken) && string.endsWith(endToken)) {
                        expressionIsWholeString = true;
                    }
                    if ((ds = (DataSource)_dataSourceMap.get(type = string.substring(startIndex + startTokenLen, delimIndex))) == null) {
                        throw new FrameworkException("Invalid type '" + type + "' in attribute value: '" + string + "'.");
                    }
                    Object variable = string.substring(delimIndex + delimLen, endIndex);
                    variable = ds.getValue(ctx, vd, (String)variable);
                    if (expressionIsWholeString) {
                        return variable;
                    }
                    string = string.substring(0, startIndex) + (variable == null ? "" : variable.toString()) + string.substring(endIndex + endTokenLen);
                    stringLen = string.length();
                }
            }
            startIndex = string.lastIndexOf(startToken, startIndex - 1);
        }
        return string;
    }

    public static Object replaceVariablesWithAttributes(Object value, ViewDescriptor vd) {
        if (value == null) {
            return null;
        }
        return Util.replaceVariablesWithAttributes(RequestManager.getRequestContext(), vd, value);
    }

    public static Object replaceVariablesWithAttributes(RequestContext ctx, ViewDescriptor vd, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            value = Util.replaceVariableWithAttribute(ctx, vd, (String)value, SUB_START, SUB_TYPE_DELIM, SUB_END);
        } else if (value instanceof List) {
            List list = (List)value;
            int size = list.size();
            ArrayList<Object> newList = new ArrayList<Object>(size);
            Iterator it = list.iterator();
            while (it.hasNext()) {
                newList.add(Util.replaceVariablesWithAttributes(ctx, vd, it.next()));
            }
            return newList;
        }
        return value;
    }

    public static boolean hasValue(String str) {
        if (str == null) {
            return false;
        }
        return str.length() > 0;
    }

    public static String replace(String src, String toReplace, String replaceWith) {
        int startIndex;
        String str = src;
        while ((startIndex = str.indexOf(toReplace)) >= 0) {
            int length = str.length();
            int endIndex = startIndex + toReplace.length();
            str = str.substring(0, startIndex) + replaceWith + str.substring(endIndex, length);
        }
        return str;
    }

    public static ViewBean getParentViewBean(View view) {
        while (view != null) {
            if (view instanceof ViewBean && view.getParent() == null) {
                return (ViewBean)view;
            }
            view = view.getParent();
        }
        return null;
    }

    public static void main(String[] args) {
        System.out.println("" + Util.replaceVariableWithAttribute(null, null, "$escape($escape(ViewDescriptor))", SUB_START, SUB_TYPE_DELIM, SUB_END));
        System.out.println("" + Util.replaceVariableWithAttribute(null, null, "$escape($escape(EEPersistenceManager))", SUB_START, SUB_TYPE_DELIM, SUB_END));
        System.out.println("" + Util.replaceVariableWithAttribute(null, null, "$es$cape$escape(EEPersistenceManager))", SUB_START, SUB_TYPE_DELIM, SUB_END));
        System.out.println("" + Util.replaceVariableWithAttribute(null, null, "$escape($escapeEEP$ersistenceManager))", SUB_START, SUB_TYPE_DELIM, SUB_END));
        System.out.println("" + Util.replaceVariableWithAttribute(null, null, "$escape($escape(EEPersistenceManager)))", SUB_START, SUB_TYPE_DELIM, SUB_END));
        System.out.println("" + Util.replaceVariableWithAttribute(null, null, "$escape($escape(EEPersistenceManager())", SUB_START, SUB_TYPE_DELIM, SUB_END));
        System.out.println("" + Util.replaceVariableWithAttribute(null, null, "$escape($escape($escape(EEPersistenceManager()))==$escape(EEPersistenceManager()))", SUB_START, SUB_TYPE_DELIM, SUB_END));
        System.out.println("" + Util.replaceVariableWithAttribute(null, null, "$escape($escape($escape(EEPersistenceManager()))==$escape(EEPersistenceManager()))", SUB_START, SUB_TYPE_DELIM, SUB_END));
        for (int x = 0; x < 100000; ++x) {
            System.out.println("" + Util.replaceVariableWithAttribute(null, null, "$escape($escape(EEPers" + x + "istenceManager()))==$escape(EEPersistenceManager())", SUB_START, SUB_TYPE_DELIM, SUB_END));
        }
    }

    static {
        AttributeDataSource attrDS = new AttributeDataSource();
        _dataSourceMap.put(ATTRIBUTE, attrDS);
        _dataSourceMap.put("", attrDS);
        _dataSourceMap.put(PAGE_SESSION, new PageSessionDataSource());
        _dataSourceMap.put(PARAMETER, new ParameterDataSource());
        _dataSourceMap.put(SESSION, new SessionDataSource());
        _dataSourceMap.put(REQUEST_PARAMETER, new RequestParameterDataSource());
        _dataSourceMap.put(DISPLAY, new DisplayFieldDataSource());
        _dataSourceMap.put(THIS, new ThisDataSource());
        _dataSourceMap.put(ESCAPE, new EscapeDataSource());
    }

    public static class ThisDataSource
    implements DataSource {
        public static final String THIS_VIEW = "View";
        public static final String THIS_PARENT_VIEW = "ParentView";
        public static final String THIS_VIEWBEAN = "ViewBean";
        public static final String THIS_VIEW_DESCRIPTOR = "ViewDescriptor";
        public static final String THIS_PARENT_VIEW_DESCRIPTOR = "ParentViewDescriptor";
        public static final String THIS_TOP_VIEW_DESCRIPTOR = "TopViewDescriptor";
        public static final String THIS_VIEW_BEAN_NAME = "ViewBeanName";
        public static final String THIS_DEFAULT_MODEL = "DefaultModel";

        public Object getValue(RequestContext ctx, ViewDescriptor vd, String key) {
            Object value = null;
            if (key.equalsIgnoreCase(THIS_VIEW) || key.length() == 0) {
                value = vd.getView(ctx);
            } else if (key.equalsIgnoreCase(THIS_VIEW_DESCRIPTOR)) {
                value = vd;
            } else if (key.equalsIgnoreCase(THIS_PARENT_VIEW_DESCRIPTOR)) {
                value = vd.getParent();
            } else if (key.equalsIgnoreCase(THIS_TOP_VIEW_DESCRIPTOR)) {
                while (vd.getParent() != null) {
                    vd = vd.getParent();
                }
                value = vd;
            } else if (key.equalsIgnoreCase(THIS_PARENT_VIEW)) {
                value = (vd = vd.getParent()) == null ? null : vd.getView(ctx);
            } else if (key.equalsIgnoreCase(THIS_VIEWBEAN)) {
                while (vd.getParent() != null) {
                    vd = vd.getParent();
                }
                value = vd.getView(ctx);
                while (value.getParent() != null) {
                    value = value.getParent();
                }
            } else if (key.equalsIgnoreCase(THIS_VIEW_BEAN_NAME)) {
                while (vd.getParent() != null) {
                    vd = vd.getParent();
                }
                value = vd.getName();
            } else if (key.equalsIgnoreCase(THIS_DEFAULT_MODEL)) {
                View view;
                for (view = vd.getView(ctx); view != null && !(view instanceof ContainerView); view = view.getParent()) {
                }
                value = ((ContainerView)view).getDefaultModel();
            } else {
                throw new FrameworkException("'" + key + "' is not valid in $this(" + key + ").  This was found on '" + vd.getName() + "'.");
            }
            return value;
        }
    }

    public static class DisplayFieldDataSource
    implements DataSource {
        public Object getValue(RequestContext ctx, ViewDescriptor vd, String key) {
            while (vd != null) {
                View view = vd.getView(ctx);
                if (view instanceof ContainerView) {
                    View child = null;
                    try {
                        child = ((ContainerView)view).getChild(key);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    if (child != null) {
                        return ((ContainerView)view).getDisplayFieldValue(key);
                    }
                }
                vd = vd.getParent();
            }
            return null;
        }
    }

    public static class SessionDataSource
    implements DataSource {
        public Object getValue(RequestContext ctx, ViewDescriptor vd, String key) {
            return ctx.getRequest().getSession().getAttribute(key);
        }
    }

    public static class EscapeDataSource
    implements DataSource {
        public Object getValue(RequestContext ctx, ViewDescriptor vd, String key) {
            return key;
        }
    }

    public static class ParameterDataSource
    implements DataSource {
        public Object getValue(RequestContext ctx, ViewDescriptor vd, String key) {
            Object value = null;
            while (value == null && vd != null) {
                value = vd.getParameter(key);
                vd = vd.getParent();
            }
            return value;
        }
    }

    public static class RequestParameterDataSource
    implements DataSource {
        public Object getValue(RequestContext ctx, ViewDescriptor vd, String key) {
            return ctx.getRequest().getParameter(key);
        }
    }

    public static class PageSessionDataSource
    implements DataSource {
        public Object getValue(RequestContext ctx, ViewDescriptor vd, String key) {
            while (vd.getParent() != null) {
                vd = vd.getParent();
            }
            return ((ViewBean)vd.getView(ctx)).getPageSessionAttribute(key);
        }
    }

    public static class AttributeDataSource
    implements DataSource {
        public Object getValue(RequestContext ctx, ViewDescriptor vd, String key) {
            return ctx.getRequest().getAttribute(key);
        }
    }

    public static interface DataSource {
        public Object getValue(RequestContext var1, ViewDescriptor var2, String var3);
    }
}

