/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.guiframework.event.handlers;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.ChildContentDisplayEvent;
import com.iplanet.jato.view.event.JspDisplayEvent;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import com.sun.enterprise.tools.guiframework.view.event.ErrorEvent;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;

public class ErrorHandler {
    public static final String EXCEPTION = "EXCEPTION";
    public static final String EXCEPTION_MESSAGE = "EXCEPTION_MESSAGE";
    public static final String EXCEPTION_CLASS_NAME = "EXCEPTION_CLASS_NAME";
    public static final String EXCEPTION_VIEW = "EXCEPTION_VIEW";
    public static final String EXCEPTION_VIEW_NAME = "EXCEPTION_VIEW_NAME";
    public static final String EXCEPTION_VIEW_DESCRIPTOR = "EXCEPTION_VIEW_DESCRIPTOR";
    public static final String EXCEPTION_VIEW_DESCRIPTOR_NAME = "EXCEPTION_VIEW_DESCRIPTOR_NAME";
    public static final String EXCEPTION_VIEW_BEAN = "EXCEPTION_VIEW_BEAN";
    public static final String EXCEPTION_VIEW_BEAN_NAME = "EXCEPTION_VIEW_BEAN_NAME";
    public static final String EXCEPTION_STACK_TRACE = "EXCEPTION_STACK_TRACE";
    public static final String EXCEPTION_CAUSE_VIEW = "EXCEPTION_CAUSE_VIEW";
    public static final String EXCEPTION_CAUSE_VIEW_DESCRIPTOR = "EXCEPTION_CAUSE_VIEW_DESCRIPTOR";
    public static final String EXCEPTION_CAUSE_MESSAGE = "EXCEPTION_CAUSE_MESSAGE";
    public static final String EXCEPTION_CAUSE_CLASS_NAME = "EXCEPTION_CAUSE_CLASS_NAME";
    public static final String EXCEPTION_CAUSE_FULL_TRACE = "EXCEPTION_CAUSE_FULL_TRACE";
    public static final String REQUEST_PARAMETERS = "REQUEST_PARAMETERS";

    public void handleError(RequestContext reqCtx, HandlerContext handlerCtx) {
        ErrorEvent errEvent = (ErrorEvent)handlerCtx.getEvent();
        HttpServletRequest request = RequestManager.getRequestContext().getRequest();
        handlerCtx.setOutputValue(EXCEPTION, errEvent.getException());
        handlerCtx.setOutputValue(EXCEPTION_MESSAGE, errEvent.getExceptionMessage());
        handlerCtx.setOutputValue(EXCEPTION_CLASS_NAME, errEvent.getExceptionClassName());
        View vw = errEvent.getView();
        handlerCtx.setOutputValue(EXCEPTION_VIEW, vw);
        handlerCtx.setOutputValue(EXCEPTION_VIEW_NAME, vw == null ? "(Null View)" : vw.getName());
        ViewDescriptor desc = errEvent.getViewDescriptor();
        handlerCtx.setOutputValue(EXCEPTION_VIEW_DESCRIPTOR, desc);
        handlerCtx.setOutputValue(EXCEPTION_VIEW_DESCRIPTOR_NAME, desc == null ? "(Null ViewDescriptor)" : desc.getName());
        vw = errEvent.getViewBean();
        handlerCtx.setOutputValue(EXCEPTION_VIEW_BEAN, vw);
        handlerCtx.setOutputValue(EXCEPTION_VIEW_BEAN_NAME, vw == null ? "(Null ViewBean)" : vw.getName());
        handlerCtx.setOutputValue(EXCEPTION_STACK_TRACE, errEvent.getRegularTrace());
        handlerCtx.setOutputValue(EXCEPTION_CAUSE_VIEW, errEvent.getCauseView());
        handlerCtx.setOutputValue(EXCEPTION_CAUSE_VIEW_DESCRIPTOR, errEvent.getCauseViewDescriptor());
        handlerCtx.setOutputValue(EXCEPTION_CAUSE_MESSAGE, errEvent.getCauseMessage());
        handlerCtx.setOutputValue(EXCEPTION_CAUSE_CLASS_NAME, errEvent.getCauseClassName());
        handlerCtx.setOutputValue(EXCEPTION_CAUSE_FULL_TRACE, errEvent.getFullTrace());
        Enumeration names = request.getParameterNames();
        String name = null;
        String nvps = "";
        while (names.hasMoreElements()) {
            name = names.nextElement().toString();
            nvps = nvps + "\t'" + name + "'='" + request.getParameter(name) + "'\n";
        }
        handlerCtx.setOutputValue(REQUEST_PARAMETERS, nvps);
    }

    public void printTag(RequestContext reqCtx, HandlerContext handlerCtx) {
        System.out.println("#######");
        System.out.println("The tag object = " + ((JspDisplayEvent)handlerCtx.getEvent()).getSourceTag());
        System.out.println("#######");
    }

    public String addErrorInfo(RequestContext reqCtx, HandlerContext handlerCtx) {
        if (!(handlerCtx.getEvent() instanceof ChildContentDisplayEvent)) {
            return null;
        }
        ChildContentDisplayEvent dispEvent = (ChildContentDisplayEvent)handlerCtx.getEvent();
        HttpServletRequest request = RequestManager.getRequestContext().getRequest();
        StringBuffer buf = new StringBuffer(dispEvent.getContent());
        buf.append("\n\n<!--\n\n");
        buf.append("    Exception Info:\n");
        buf.append("===================\n\n");
        buf.append("    Exception Type: " + request.getAttribute(EXCEPTION_CLASS_NAME) + "\n");
        buf.append(" Exception Message: " + request.getAttribute(EXCEPTION_MESSAGE) + "\n");
        buf.append("        Root Cause: " + request.getAttribute(EXCEPTION_CAUSE_CLASS_NAME) + "\n");
        buf.append("      Root Message: " + request.getAttribute(EXCEPTION_CAUSE_MESSAGE) + "\n\n");
        buf.append("===================\n\n");
        buf.append("         View Info:\n");
        buf.append("===================\n\n");
        buf.append("          ViewBean: " + request.getAttribute(EXCEPTION_VIEW_BEAN_NAME) + "\n");
        buf.append("              View: " + request.getAttribute(EXCEPTION_VIEW_NAME) + "\n");
        buf.append("    ViewDescriptor: " + request.getAttribute(EXCEPTION_VIEW_DESCRIPTOR_NAME) + "\n");
        buf.append("Request Parameters:\n" + request.getAttribute(REQUEST_PARAMETERS) + "\n\n");
        buf.append("==================\n\n");
        buf.append("Below are 2 stack traces to help diagnose the problem.\n");
        buf.append("The first is the traditional stack trace, the second is\n");
        buf.append("a full stack trace to the root cause.\n\n");
        buf.append("       Stack Trace:\n");
        buf.append("===================\n\n");
        buf.append("" + request.getAttribute(EXCEPTION_STACK_TRACE) + "\n\n");
        buf.append("        Full Trace:\n");
        buf.append("===================\n\n");
        buf.append("" + request.getAttribute(EXCEPTION_CAUSE_FULL_TRACE) + "\n\n");
        buf.append("===================\n\n");
        buf.append("-->\n\n");
        return buf.toString();
    }
}

