/*
 * Decompiled with CFR 0.152.
 */
package com.sun.connector.jaxr;

import com.sun.connector.jaxr.JaxrConnectionManager;
import com.sun.connector.jaxr.JaxrConnectionRequestInfo;
import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.xml.registry.Connection;
import javax.xml.registry.ConnectionFactory;
import javax.xml.registry.FederatedConnection;
import javax.xml.registry.JAXRException;
import javax.xml.registry.UnsupportedCapabilityException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JaxrConnectionFactory
extends ConnectionFactory
implements Serializable,
Referenceable {
    private ManagedConnectionFactory mcf;
    private ConnectionManager cm;
    private Reference reference;
    private Properties properties;
    Log log = LogFactory.getLog((String)"com.sun.connector.jaxr");

    public JaxrConnectionFactory(ManagedConnectionFactory managedConnectionFactory, ConnectionManager connectionManager) {
        this.mcf = managedConnectionFactory;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"JAXRConnectionFactory constructor - ManagedConnectionFactory and ConnectionManager are parameters");
        }
        this.cm = new JaxrConnectionManager();
    }

    public Connection getConnection() throws JAXRException {
        try {
            JaxrConnectionRequestInfo jaxrConnectionRequestInfo = null;
            if (this.properties != null) {
                jaxrConnectionRequestInfo = new JaxrConnectionRequestInfo(this.properties);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"JAXRConnectionFactory getConnection - ConnectionManager calling allocateConnection");
            }
            return (Connection)this.cm.allocateConnection(this.mcf, (ConnectionRequestInfo)jaxrConnectionRequestInfo);
        }
        catch (ResourceException resourceException) {
            throw new JAXRException(resourceException.getMessage());
        }
    }

    public Connection getConnection(String string, String string2) throws JAXRException {
        throw new JAXRException(ResourceBundle.getBundle("com/sun/connector/jaxr/LocalStrings").getString("Getting_a_connection_with_username,_password_parameters_is_not_supported"));
    }

    Connection getConnection(Properties properties) throws JAXRException {
        try {
            JaxrConnectionRequestInfo jaxrConnectionRequestInfo = new JaxrConnectionRequestInfo(properties);
            return (Connection)this.cm.allocateConnection(this.mcf, (ConnectionRequestInfo)jaxrConnectionRequestInfo);
        }
        catch (ResourceException resourceException) {
            throw new JAXRException(resourceException.getMessage());
        }
    }

    public void setProperties(Properties properties) throws JAXRException {
        this.properties = properties;
    }

    public Properties getProperties() throws JAXRException {
        return this.properties;
    }

    public Connection createConnection() throws JAXRException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"JAXRConnectionFactory createConnection calling getConnection -");
        }
        return this.getConnection();
    }

    public FederatedConnection createFederatedConnection(Collection collection) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }

    public Reference getReference() {
        return this.reference;
    }
}

