/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.tools.admingui.handlers;

import com.iplanet.jato.RequestContext;
import com.sun.enterprise.ee.admin.PortReplacedException;
import com.sun.enterprise.tools.admingui.handlers.ServerInstGeneralHandlers;
import com.sun.enterprise.tools.admingui.util.MBeanUtil;
import com.sun.enterprise.tools.admingui.util.Util;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import java.util.Enumeration;
import java.util.Properties;
import javax.management.ObjectName;

public class EEServerInstGeneralHandlers
extends ServerInstGeneralHandlers {
    public void createServerInstance(RequestContext ctx, HandlerContext handlerCtx) {
        String objectName = (String)handlerCtx.getInputValue("objectName");
        String methodName = (String)handlerCtx.getInputValue("methodName");
        String nodeAgentName = (String)handlerCtx.getInputValue("nodeAgentName");
        String serverName = (String)handlerCtx.getInputValue("serverName");
        String configName = (String)handlerCtx.getInputValue("configName");
        String clusterName = (String)handlerCtx.getInputValue("clusterName");
        String copyFlag = (String)handlerCtx.getInputValue("copyFlag");
        Properties systemProps = (Properties)handlerCtx.getInputValue("systemProps");
        boolean configCopied = false;
        if ("true".equals(copyFlag)) {
            configCopied = true;
            configName = this.copyConfig(configName, serverName);
        }
        try {
            this.createInstance(objectName, methodName, nodeAgentName, serverName, configName, clusterName, systemProps);
        }
        catch (Exception ex) {
            if (configCopied) {
                this.removeConfig(configName);
            }
            throw new FrameworkException((Throwable)ex);
        }
    }

    private void createInstance(String objectName, String methodName, String nodeAgentName, String serverName, String configName, String clusterName, Properties systemProps) {
        block2: {
            String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.util.Properties"};
            Object[] params = new Object[]{nodeAgentName, serverName, configName, clusterName, systemProps};
            try {
                Object obj = MBeanUtil.getMBeanServer().invoke(new ObjectName(objectName), methodName, params, signature);
            }
            catch (Exception ex) {
                if (ex.getCause() instanceof PortReplacedException) break block2;
                throw new FrameworkException((Throwable)ex);
            }
        }
    }

    public void createInstancesForCluster(RequestContext ctx, HandlerContext handlerCtx) {
        String clusterName = (String)handlerCtx.getInputValue("clusterName");
        Properties instances = (Properties)handlerCtx.getInputValue("instanceNameList");
        String objectName = (String)handlerCtx.getInputValue("objectName");
        String methodName = (String)handlerCtx.getInputValue("methodName");
        StringBuffer err = new StringBuffer();
        String error = null;
        Enumeration<?> enumeration = instances.propertyNames();
        while (enumeration.hasMoreElements()) {
            String instanceName = (String)enumeration.nextElement();
            String nodeAgentName = instances.getProperty(instanceName);
            try {
                this.createInstance(objectName, methodName, nodeAgentName, instanceName, null, clusterName, null);
            }
            catch (Exception ex) {
                err.append(" ");
                err.append(instanceName);
            }
        }
        if (err.length() != 0) {
            String defaultGif = "<img src=\"/com_sun_web_ui/images/other/dot.gif\" border=\"0\" width=\"11\" height=\"11\" alt=\"\" >";
            String errorGif = Util.getMessage((String)"clusterCreated.errorGif");
            String img = null;
            img = "<img src=\"" + (errorGif == null ? defaultGif : errorGif) + "\" border=\"0\" alt=\"\"  />&nbsp;";
            error = img + Util.getMessage((String)"clusterCreated.errorFound") + err.toString();
        }
        handlerCtx.setOutputValue("errorMsg", error);
    }

    public void createCluster(RequestContext ctx, HandlerContext handlerCtx) {
        String clusterName = (String)handlerCtx.getInputValue("clusterName");
        String configName = (String)handlerCtx.getInputValue("configName");
        String copyFlag = (String)handlerCtx.getInputValue("copyFlag");
        boolean configCopied = false;
        if (Util.isEmpty((String)configName)) {
            throw new IllegalArgumentException("The parameter map did not contain " + configName);
        }
        if (Util.isEmpty((String)clusterName)) {
            throw new IllegalArgumentException("The parameter map did not contain " + clusterName);
        }
        if (Util.isEmpty((String)copyFlag)) {
            throw new IllegalArgumentException("The parameter map did not contain " + copyFlag);
        }
        String errorKey = this.testUnique(clusterName);
        if (errorKey != null) {
            String bundle = "com.sun.enterprise.tools.admingui.resources.Resources";
            String mesg = Util.getMessage((String)"com.sun.enterprise.tools.admingui.resources.Resources", (String)errorKey, (Object[])new String[]{clusterName});
            throw new FrameworkException(mesg);
        }
        if ("true".equals(copyFlag)) {
            configCopied = true;
            configName = this.copyConfig(configName, clusterName);
        }
        String objectName = "com.sun.appserv:type=clusters,category=config";
        String methodName = "createCluster";
        Object[] params = new String[]{clusterName, configName, null};
        String[] types = new String[]{"java.lang.String", "java.lang.String", "java.util.Properties"};
        try {
            MBeanUtil.invoke((String)objectName, (String)methodName, (Object[])params, (String[])types);
        }
        catch (Exception ex) {
            if (configCopied) {
                this.removeConfig(configName);
            }
            throw new FrameworkException((Throwable)ex);
        }
    }

    public void testUnique(RequestContext ctx, HandlerContext handlerCtx) {
        String testName = (String)handlerCtx.getInputValue("testName");
        String errorKey = this.testUnique(testName);
        if (errorKey != null) {
            String bundle = "com.sun.enterprise.tools.admingui.resources.Resources";
            String mesg = Util.getMessage((String)"com.sun.enterprise.tools.admingui.resources.Resources", (String)errorKey, (Object[])new String[]{testName});
            throw new FrameworkException(mesg);
        }
    }

    private String copyConfig(String source, String targetName) {
        String dest = targetName + "-config";
        String configBean = "com.sun.appserv:type=config,category=config,name=" + dest;
        if (MBeanUtil.isValidMBean((String)configBean)) {
            for (int i = 2; i < 500; ++i) {
                if (MBeanUtil.isValidMBean((String)("com.sun.appserv:type=config,category=config,name=" + dest + i))) continue;
                dest = dest + i;
                break;
            }
        }
        String objectName = "com.sun.appserv:type=configs,category=config";
        String methodName = "copyConfiguration";
        Object[] params = new String[]{source, dest, null};
        String[] types = new String[]{"java.lang.String", "java.lang.String", "java.util.Properties"};
        MBeanUtil.invoke((String)objectName, (String)methodName, (Object[])params, (String[])types);
        return dest;
    }

    private void removeConfig(String configName) {
        String objectName = "com.sun.appserv:type=configs,category=config";
        String methodName = "deleteConfiguration";
        Object[] params = new String[]{configName};
        String[] types = new String[]{"java.lang.String"};
        MBeanUtil.invoke((String)objectName, (String)methodName, (Object[])params, (String[])types);
    }

    private String testUnique(String testName) {
        if (MBeanUtil.isValidMBean((String)("com.sun.appserv:type=server,category=config,name=" + testName))) {
            return "create.error.server_exist";
        }
        if (MBeanUtil.isValidMBean((String)("com.sun.appserv:type=cluster,category=config,name=" + testName))) {
            return "create.error.cluster_exist";
        }
        if (MBeanUtil.isValidMBean((String)("com.sun.appserv:type=node-agent,category=config,name=" + testName))) {
            return "create.error.node-agent_exist";
        }
        if (MBeanUtil.isValidMBean((String)("com.sun.appserv:type=config,category=config,name=" + testName))) {
            return "create.error.config_exist";
        }
        return null;
    }
}

