/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.gui;

import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.common.LogMessageEvent;
import com.sun.enterprise.tools.upgrade.common.LogMessageListener;
import com.sun.enterprise.tools.upgrade.common.UpgradeConstants;
import com.sun.enterprise.tools.upgrade.common.UpgradeUpdateEvent;
import com.sun.enterprise.tools.upgrade.common.UpgradeUpdateListener;
import com.sun.enterprise.tools.upgrade.common.UpgradeUtils;
import com.sun.enterprise.tools.upgrade.gui.CertificatePanel;
import com.sun.enterprise.tools.upgrade.gui.ClusterDetailsPanel;
import com.sun.enterprise.tools.upgrade.gui.DataCollectionPanel;
import com.sun.enterprise.tools.upgrade.gui.DomainPathSelectionDialog;
import com.sun.enterprise.tools.upgrade.gui.ImagePanel;
import com.sun.enterprise.tools.upgrade.gui.ProgressPanel;
import com.sun.enterprise.tools.upgrade.gui.util.DialogEvent;
import com.sun.enterprise.tools.upgrade.gui.util.DialogListener;
import com.sun.enterprise.tools.upgrade.gui.util.Utils;
import com.sun.enterprise.util.i18n.StringManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.help.CSH;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class MainFrame
extends JFrame
implements LogMessageListener,
UpgradeUpdateListener {
    private JButton backButton = null;
    private JPanel buttonsPanel = null;
    private JButton cancelButton = null;
    private JButton helpButton = null;
    private JPanel JDialogContentPane = null;
    private JButton nextButton = null;
    private ProgressPanel progressPanel = null;
    private DataCollectionPanel dataCollectionPanel = null;
    private CertificatePanel certificatePanel = null;
    private ClusterDetailsPanel clusterDetailsPanel = null;
    EventHandler eventHandler = new EventHandler();
    private JPanel navigationPanel = null;
    private static final int DETAILS_COLLECTION_PANEL = 1;
    private static final int CERTIFICATE_PANEL = 2;
    private static final int PROGRESS_PANEL = 3;
    private static final int CLUSTER_DETAILS_PANEL = 4;
    private int currentNavigationPanel = 1;
    private static int UPGRADE_STARTED = 1;
    private static int UPGRADE_FINISHED = 2;
    private static int DATA_COLLECTION_PENDING = 3;
    private static int CRTIFICATION_PENDING = 4;
    private static int CLUSTER_DETAILS_PENDING = 5;
    private CommonInfoModel commonInfoModel;
    private DomainPathSelectionDialog domainPathSelectionDialog;
    private Vector dialogListeners = new Vector();
    private StringManager stringManager = StringManager.getManager((String)"com.sun.enterprise.tools.upgrade.gui");
    private static Logger logger = CommonInfoModel.getDefaultLogger();

    public void addDialogListener(DialogListener listener) {
        this.dialogListeners.addElement(listener);
    }

    public void removeDialogListener(DialogListener listener) {
        this.dialogListeners.removeElement(listener);
    }

    public MainFrame(CommonInfoModel coInfoModel) {
        if (coInfoModel.getTargetEdition().equals("pe")) {
            super.setTitle(this.stringManager.getString("upgrade.gui.mainframe.titleMessage"));
        } else {
            super.setTitle(this.stringManager.getString("upgrade.gui.mainframe.eetitleMessage"));
        }
        this.commonInfoModel = coInfoModel;
        this.initialize();
    }

    private void processCancelAction() {
        int option = JOptionPane.showConfirmDialog(this, this.stringManager.getString("upgrade.gui.mainframe.exitMessage"), this.stringManager.getString("upgrade.gui.mainframe.exitMessageTitle"), 0, 3);
        if (option == 1) {
            return;
        }
        DialogEvent de = new DialogEvent(this, 2);
        for (int i = 0; i < this.dialogListeners.size(); ++i) {
            ((DialogListener)this.dialogListeners.elementAt(i)).dialogProcessed(de);
        }
        this.dispose();
    }

    private JButton getbackButton() {
        if (this.backButton == null) {
            this.backButton = new JButton();
            this.backButton.setName("backButton");
            this.backButton.setText(this.stringManager.getString("upgrade.gui.mainframe.backbutton"));
        }
        return this.backButton;
    }

    private JPanel getProgressPanel() {
        if (this.progressPanel == null) {
            this.progressPanel = new ProgressPanel();
        }
        return this.progressPanel;
    }

    private JPanel getbuttonsPanel() {
        if (this.buttonsPanel == null) {
            this.buttonsPanel = new JPanel();
            this.buttonsPanel.setName("buttonsPanel");
            this.buttonsPanel.setLayout(new GridBagLayout());
            JPanel placeHolderPanel1 = new JPanel();
            JPanel placeHolderPanel2 = new JPanel();
            placeHolderPanel1.add(this.getbackButton());
            placeHolderPanel1.add(this.getnextButton());
            placeHolderPanel2.add(this.getcancelButton());
            placeHolderPanel2.add(this.gethelpButton());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.anchor = 17;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 1.0;
            constraints.fill = 2;
            constraints.insets = new Insets(5, 10, 10, 20);
            this.getbuttonsPanel().add((Component)placeHolderPanel1, constraints);
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = 0;
            constraints.anchor = 13;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 1.0;
            constraints.fill = 2;
            constraints.insets = new Insets(5, 10, 10, 20);
            this.getbuttonsPanel().add((Component)placeHolderPanel2, constraints);
        }
        return this.buttonsPanel;
    }

    private JButton getcancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setName("cancelButton");
            this.cancelButton.setText(this.stringManager.getString("upgrade.gui.mainframe.cancelbutton"));
        }
        return this.cancelButton;
    }

    private JButton gethelpButton() {
        if (this.helpButton == null) {
            this.helpButton = new JButton();
            this.helpButton.setName("helpButton");
            this.helpButton.setText(this.stringManager.getString("upgrade.gui.mainframe.helpbutton"));
            if (Utils.getHelpBroker() != null) {
                Utils.getHelpBroker().enableHelpOnButton((Component)this.helpButton, "WIZARD_FIRST", null);
            }
        }
        return this.helpButton;
    }

    public JPanel getJDialogContentPane() {
        if (this.JDialogContentPane == null) {
            this.JDialogContentPane = new JPanel();
            this.JDialogContentPane.setName("JDialogContentPane");
            this.JDialogContentPane.setLayout(new GridBagLayout());
            GridBagConstraints imageconstraintsPanel = new GridBagConstraints();
            imageconstraintsPanel.gridx = 0;
            imageconstraintsPanel.gridy = 0;
            imageconstraintsPanel.fill = 1;
            imageconstraintsPanel.weightx = 0.0;
            imageconstraintsPanel.weighty = 0.0;
            ImagePanel imagePanel = new ImagePanel(new Insets(5, 10, 5, 10));
            Image image = this.getUpgradeToolImage();
            imagePanel.setImage(image);
            this.getJDialogContentPane().add((Component)imagePanel, imageconstraintsPanel);
            GridBagConstraints constraintsnavigationPanel = new GridBagConstraints();
            constraintsnavigationPanel.gridx = 1;
            constraintsnavigationPanel.gridy = 0;
            constraintsnavigationPanel.fill = 1;
            constraintsnavigationPanel.weightx = 1.0;
            constraintsnavigationPanel.weighty = 1.0;
            this.getJDialogContentPane().add((Component)this.getnavigationPanel(), constraintsnavigationPanel);
            GridBagConstraints constraintsSeparator = new GridBagConstraints();
            constraintsSeparator.gridx = 0;
            constraintsSeparator.gridy = 1;
            constraintsSeparator.gridwidth = 2;
            constraintsSeparator.gridheight = 1;
            constraintsSeparator.fill = 2;
            constraintsSeparator.weightx = 1.0;
            constraintsSeparator.insets = new Insets(5, 0, 0, 0);
            JSeparator separatorPanel = new JSeparator();
            this.getJDialogContentPane().add((Component)separatorPanel, constraintsSeparator);
            GridBagConstraints constraintsbuttonsPanel = new GridBagConstraints();
            constraintsbuttonsPanel.gridx = 0;
            constraintsbuttonsPanel.gridy = 2;
            constraintsbuttonsPanel.gridwidth = 2;
            constraintsbuttonsPanel.gridheight = 1;
            constraintsbuttonsPanel.fill = 2;
            constraintsbuttonsPanel.weightx = 1.0;
            constraintsbuttonsPanel.insets = new Insets(5, 0, 0, 0);
            this.getJDialogContentPane().add((Component)this.getbuttonsPanel(), constraintsbuttonsPanel);
        }
        return this.JDialogContentPane;
    }

    private Image getUpgradeToolImage() {
        URL imageURL = ClassLoader.getSystemClassLoader().getResource("com/sun/enterprise/tools/upgrade/gui/Appserv_upgrade_wizard.gif");
        return imageURL != null ? Toolkit.getDefaultToolkit().getImage(imageURL) : null;
    }

    private JPanel getnavigationPanel() {
        if (this.navigationPanel == null) {
            this.navigationPanel = new JPanel();
            this.navigationPanel.setName("navigationPanel");
            this.navigationPanel.setLayout(new GridBagLayout());
            GridBagConstraints constraintsbeanNameBeanTypePanel = new GridBagConstraints();
            constraintsbeanNameBeanTypePanel.gridx = 0;
            constraintsbeanNameBeanTypePanel.gridy = 0;
            constraintsbeanNameBeanTypePanel.fill = 1;
            constraintsbeanNameBeanTypePanel.weightx = 1.0;
            constraintsbeanNameBeanTypePanel.weighty = 1.0;
            this.getnavigationPanel().add((Component)this.getDataCollectionPanel(), constraintsbeanNameBeanTypePanel);
        }
        return this.navigationPanel;
    }

    private JButton getnextButton() {
        if (this.nextButton == null) {
            this.nextButton = new JButton();
            this.nextButton.setName("nextButton");
            this.nextButton.setText(this.stringManager.getString("upgrade.gui.mainframe.nextbutton"));
            this.nextButton.setActionCommand("next");
        }
        return this.nextButton;
    }

    private void initConnections() {
        this.getcancelButton().addActionListener(this.eventHandler);
        this.getbackButton().addActionListener(this.eventHandler);
        this.getnextButton().addActionListener(this.eventHandler);
        this.gethelpButton().addActionListener(this.eventHandler);
        this.dataCollectionPanel.addDialogListener(new DialogListener(){

            public void dialogProcessed(DialogEvent evt) {
                MainFrame.this.setNextButtonStateForDataCollectionPanel();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MainFrame.this.processCancelAction();
            }
        });
    }

    private void initialize() {
        this.setName("MainFrame");
        this.setDefaultCloseOperation(0);
        this.setSize(725, 545);
        this.setContentPane(this.getJDialogContentPane());
        this.initConnections();
        this.setFrameNavigationState(DATA_COLLECTION_PENDING);
        this.setBounds(new Rectangle(100, 100, this.getWidth(), this.getHeight()));
    }

    public static void main(String[] args) {
        try {
            MainFrame wiz = new MainFrame(new CommonInfoModel());
            wiz.show();
        }
        catch (Throwable th) {
            logger.severe(th.getMessage());
        }
    }

    public void processBackAction() {
        if (this.currentNavigationPanel == 3) {
            this.currentNavigationPanel = 2;
            CSH.setHelpIDString((Component)this.gethelpButton(), (String)"WIZARD_CERT");
        } else if (this.currentNavigationPanel == 2) {
            this.currentNavigationPanel = 1;
            CSH.setHelpIDString((Component)this.gethelpButton(), (String)"WIZARD_FIRST");
        } else if (this.currentNavigationPanel == 4) {
            if (this.commonInfoModel.getCertificateConversionFlag()) {
                this.currentNavigationPanel = 2;
                CSH.setHelpIDString((Component)this.gethelpButton(), (String)"WIZARD_CERT");
            } else {
                this.currentNavigationPanel = 1;
                CSH.setHelpIDString((Component)this.gethelpButton(), (String)"WIZARD_FIRST");
            }
        } else if (this.currentNavigationPanel == 1) {
            // empty if block
        }
        this.setCurrentNavigationPanel();
    }

    public void processHelpAction() {
    }

    public void processNextAction() {
        DialogEvent de = null;
        if (this.getnextButton().getActionCommand().equals("finish")) {
            de = new DialogEvent(this, 5);
            this.dispose();
        } else if (this.currentNavigationPanel == 1) {
            if (!this.validateInputs()) {
                return;
            }
            this.commonInfoModel.setSourceInstallDir(this.dataCollectionPanel.getSourceDirectoryPath());
            if (this.commonInfoModel.checkSourceInputAsDomainRoot(this.commonInfoModel.getSourceInstallDir())) {
                this.commonInfoModel.setSourceDomainRoot(this.commonInfoModel.getSourceInstallDir());
            }
            this.commonInfoModel.setTargetInstallDir(this.dataCollectionPanel.getDestinationDirectoryPath());
            this.commonInfoModel.setAdminUserName(this.dataCollectionPanel.getAdminUserName());
            this.commonInfoModel.setAdminPassword(this.dataCollectionPanel.getAdminPassword());
            this.commonInfoModel.setCertificateConversionFlag(this.dataCollectionPanel.isUpgradeCertificatesSelected());
            if (!this.commonInfoModel.getTargetVersionAndEdition().equals("as81pe")) {
                this.commonInfoModel.setMasterPassword(this.dataCollectionPanel.getMasterPassword());
            }
            this.commonInfoModel.enlistDomainsFromSource();
            if (this.dataCollectionPanel.isUpgradeCertificatesSelected()) {
                this.commonInfoModel.setCertificateConversionFlag(true);
                this.currentNavigationPanel = 2;
                CSH.setHelpIDString((Component)this.gethelpButton(), (String)"WIZARD_CERT");
            } else if (this.commonInfoModel.getSourceVersionAndEdition().equals("as7xee")) {
                this.currentNavigationPanel = 4;
                CSH.setHelpIDString((Component)this.gethelpButton(), (String)"WIZARD_CLUSTER");
            } else {
                de = new DialogEvent(this, 4);
                this.currentNavigationPanel = 3;
                CSH.setHelpIDString((Component)this.gethelpButton(), (String)"WIZARD_RESULT");
            }
            this.setCurrentNavigationPanel();
        } else if (this.currentNavigationPanel == 2) {
            if (this.commonInfoModel.getSourceVersionAndEdition().equals("as7xee")) {
                this.currentNavigationPanel = 4;
                CSH.setHelpIDString((Component)this.gethelpButton(), (String)"WIZARD_CLUSTER");
            } else {
                de = new DialogEvent(this, 4);
                this.currentNavigationPanel = 3;
                CSH.setHelpIDString((Component)this.gethelpButton(), (String)"WIZARD_RESULT");
            }
            this.setCurrentNavigationPanel();
        } else if (this.currentNavigationPanel == 4) {
            Vector clusterFileNames = this.clusterDetailsPanel.getClusterFilesTableModel().getClusterFiles();
            if (clusterFileNames != null && !clusterFileNames.isEmpty() && !this.commonInfoModel.processClinstnceConfFiles(clusterFileNames)) {
                JOptionPane.showMessageDialog(this, this.stringManager.getString("upgrade.gui.mainframe.clusterListInvalidMsg"), this.stringManager.getString("upgrade.gui.mainframe.lusterListInvalidTitle"), 0);
                return;
            }
            de = new DialogEvent(this, 4);
            this.currentNavigationPanel = 3;
            this.setCurrentNavigationPanel();
            CSH.setHelpIDString((Component)this.gethelpButton(), (String)"WIZARD_RESULT");
        } else if (this.currentNavigationPanel == 3) {
            de = new DialogEvent(this, 5);
            this.dispose();
        }
        if (de != null) {
            new UpgradeActionThread(this.dialogListeners, de).start();
        }
    }

    private List getUserDefinedSourceDomains(CommonInfoModel commonInfoModel) {
        int returnedOption = JOptionPane.showConfirmDialog(this, this.stringManager.getString("upgrade.gui.mainframe.multiplDomainsMsg"), this.stringManager.getString("upgrade.gui.mainframe.multiplDomainsTitle"), 0, 3);
        if (returnedOption == 1) {
            return null;
        }
        this.getDomainPathSelectionDialog().show();
        if (this.getDomainPathSelectionDialog().USER_ACTION == 1) {
            return null;
        }
        return this.getDomainPathSelectionDialog().getDomainPathTableModel().getDomainPaths();
    }

    private DomainPathSelectionDialog getDomainPathSelectionDialog() {
        if (this.domainPathSelectionDialog == null) {
            this.domainPathSelectionDialog = new DomainPathSelectionDialog();
            this.centerDialog(this.domainPathSelectionDialog);
            this.domainPathSelectionDialog.addDialogListener(new DialogListener(){

                public void dialogProcessed(DialogEvent evt) {
                }
            });
        }
        return this.domainPathSelectionDialog;
    }

    public void centerDialog(JDialog dialog) {
        Rectangle bounds = this.getBounds();
        Rectangle dialogLocation = new Rectangle();
        dialogLocation.x = bounds.x + (bounds.width - dialog.getWidth()) / 2;
        dialogLocation.y = bounds.y + (bounds.height - dialog.getHeight()) / 2;
        dialogLocation.setSize(dialog.getWidth(), dialog.getHeight());
        dialog.setBounds(dialogLocation);
    }

    public void setCurrentNavigationPanel() {
        this.getnavigationPanel().removeAll();
        this.getJDialogContentPane().invalidate();
        GridBagConstraints constraintsPanel = new GridBagConstraints();
        constraintsPanel.gridx = 0;
        constraintsPanel.gridy = 0;
        constraintsPanel.fill = 1;
        constraintsPanel.weightx = 1.0;
        constraintsPanel.weighty = 1.0;
        if (3 == this.currentNavigationPanel) {
            this.getnavigationPanel().add((Component)this.getProgressPanel(), constraintsPanel);
            this.setFrameNavigationState(UPGRADE_STARTED);
        } else if (2 == this.currentNavigationPanel) {
            this.getnavigationPanel().add((Component)this.getCertificatePanel(), constraintsPanel);
            this.setFrameNavigationState(CRTIFICATION_PENDING);
            ((CertificatePanel)this.getCertificatePanel()).reInitializeAddDomainDialog();
        } else if (1 == this.currentNavigationPanel) {
            this.getnavigationPanel().add((Component)this.getDataCollectionPanel(), constraintsPanel);
            this.setFrameNavigationState(DATA_COLLECTION_PENDING);
        } else if (4 == this.currentNavigationPanel) {
            this.getnavigationPanel().add((Component)this.getClusterDetailsPanel(), constraintsPanel);
            this.setFrameNavigationState(CLUSTER_DETAILS_PENDING);
        }
        this.getJDialogContentPane().validate();
        this.repaint();
    }

    private void setFrameNavigationState(int state) {
        if (UPGRADE_FINISHED == state) {
            this.getcancelButton().setEnabled(false);
            this.getnextButton().setEnabled(true);
            this.getnextButton().setActionCommand("finish");
            this.getnextButton().setText(this.stringManager.getString("upgrade.gui.mainframe.finishbutton"));
            this.getbackButton().setEnabled(false);
        } else if (UPGRADE_STARTED == state) {
            this.getnextButton().setEnabled(false);
            this.getbackButton().setEnabled(false);
        } else if (CRTIFICATION_PENDING == state) {
            this.getnextButton().setEnabled(true);
            this.getbackButton().setEnabled(true);
        } else if (CLUSTER_DETAILS_PENDING == state) {
            this.getnextButton().setEnabled(true);
            this.getbackButton().setEnabled(true);
        } else {
            this.getcancelButton().setEnabled(true);
            this.setNextButtonStateForDataCollectionPanel();
            this.getnextButton().setActionCommand("next");
            this.getbackButton().setEnabled(false);
        }
    }

    private void setNextButtonStateForDataCollectionPanel() {
        String sourcePath = this.dataCollectionPanel.getSourceDirectoryPath();
        String destPath = this.dataCollectionPanel.getDestinationDirectoryPath();
        String adminUserName = this.dataCollectionPanel.getAdminUserName();
        String adminPassword = this.dataCollectionPanel.getAdminPassword();
        if (this.commonInfoModel.getTargetVersionAndEdition().equals("as81pe")) {
            if (sourcePath == null || destPath == null || adminUserName == null || adminPassword == null || "".equals(adminUserName) || "".equals(adminPassword) || "".equals(sourcePath) || "".equals(destPath)) {
                this.getnextButton().setEnabled(false);
            } else {
                this.getnextButton().setEnabled(true);
            }
        } else {
            String masterPassword = this.dataCollectionPanel.getMasterPassword();
            if (sourcePath == null || destPath == null || adminUserName == null || adminPassword == null || masterPassword == null || "".equals(adminUserName) || "".equals(adminPassword) || "".equals(sourcePath) || "".equals(masterPassword) || "".equals(destPath)) {
                this.getnextButton().setEnabled(false);
            } else {
                this.getnextButton().setEnabled(true);
            }
        }
    }

    private void setNextButtonStateForClusterDetailsPanel() {
        if (this.clusterDetailsPanel.getClusterFilesTableModel().getClusterFiles().size() == 0) {
            this.getnextButton().setEnabled(false);
        } else {
            this.getnextButton().setEnabled(true);
        }
    }

    private boolean validateInputs() {
        if (this.currentNavigationPanel == 1) {
            String sourceDir = this.dataCollectionPanel.getSourceDirectoryPath();
            String destDir = this.dataCollectionPanel.getDestinationDirectoryPath();
            if (!(UpgradeUtils.getUpgradeUtils(this.commonInfoModel).isValidSourcePath(sourceDir) || this.commonInfoModel.checkSourceInputAsDomainRoot(this.dataCollectionPanel.getSourceDirectoryPath()) && !this.commonInfoModel.getSourceVersion().equals("7x"))) {
                JOptionPane.showMessageDialog(this, this.stringManager.getString("upgrade.gui.mainframe.invalidSourceMsg"), this.stringManager.getString("upgrade.gui.mainframe.invalidSourceTitle"), 0);
                return false;
            }
            if (!UpgradeUtils.getUpgradeUtils(this.commonInfoModel).isValidTargetPath(destDir)) {
                JOptionPane.showMessageDialog(this, this.stringManager.getString("upgrade.gui.mainframe.invalidTargetMsg"), this.stringManager.getString("upgrade.gui.mainframe.invalidTargetTitle"), 0);
                return false;
            }
            this.commonInfoModel.setSourceInstallDir(sourceDir);
            this.commonInfoModel.setTargetInstallDir(destDir);
            if (this.commonInfoModel.checkSourceInputAsDomainRoot(this.commonInfoModel.getSourceInstallDir())) {
                this.commonInfoModel.setSourceDomainRoot(this.commonInfoModel.getSourceInstallDir());
            }
            if (!this.commonInfoModel.isUpgradeSupported()) {
                JOptionPane.showMessageDialog(this, this.stringManager.getString("upgrade.gui.mainframe.versionNotSupportedMsg1") + UpgradeConstants.readableString(this.commonInfoModel.getSourceVersionAndEdition()) + this.stringManager.getString("upgrade.gui.mainframe.versionNotSupportedMsg2") + UpgradeConstants.readableString(this.commonInfoModel.getTargetVersionAndEdition()), this.stringManager.getString("upgrade.gui.mainframe.versionNotSupportedTitle"), 0);
                this.commonInfoModel.clearSourceAndTargetVersions();
                return false;
            }
            String userName = this.dataCollectionPanel.getAdminUserName();
            String adminPasswd = this.dataCollectionPanel.getAdminPassword();
            String masterPwd = null;
            if (!this.commonInfoModel.getTargetVersionAndEdition().equals("as81pe")) {
                masterPwd = this.dataCollectionPanel.getMasterPassword();
            }
            if (!UpgradeUtils.getUpgradeUtils(this.commonInfoModel).validateUserDetails(userName, adminPasswd, masterPwd)) {
                JOptionPane.showMessageDialog(this, this.stringManager.getString("upgrade.gui.mainframe.invalidUserDetailsMsg"), this.stringManager.getString("upgrade.gui.mainframe.invalidUserDetailsTitle"), 0);
                return false;
            }
            this.commonInfoModel.clearSourceAndTargetVersions();
            return true;
        }
        return true;
    }

    private JPanel getDataCollectionPanel() {
        if (this.dataCollectionPanel == null) {
            this.dataCollectionPanel = new DataCollectionPanel(this.commonInfoModel);
        }
        return this.dataCollectionPanel;
    }

    private JPanel getClusterDetailsPanel() {
        if (this.clusterDetailsPanel == null) {
            this.clusterDetailsPanel = new ClusterDetailsPanel();
            this.clusterDetailsPanel.addDialogListener(new DialogListener(){

                public void dialogProcessed(DialogEvent evt) {
                }
            });
        }
        return this.clusterDetailsPanel;
    }

    private JPanel getCertificatePanel() {
        if (this.certificatePanel == null) {
            this.certificatePanel = new CertificatePanel(this.commonInfoModel, this);
        }
        return this.certificatePanel;
    }

    public void logMessageReceived(LogMessageEvent evt) {
        if (this.progressPanel != null) {
            this.progressPanel.updateLog(evt);
        }
    }

    public void upgradeProcessUpdate(UpgradeUpdateEvent evt) {
        if (this.progressPanel != null) {
            this.progressPanel.updateProgress(evt);
            if (evt.getProgressState() == 100) {
                this.setFrameNavigationState(UPGRADE_FINISHED);
            }
        }
    }

    class UpgradeActionThread
    extends Thread {
        private Vector dialogListeners;
        private DialogEvent de;

        public UpgradeActionThread(Vector listeners, DialogEvent d) {
            this.dialogListeners = listeners;
            this.de = d;
        }

        public void run() {
            for (int i = 0; i < this.dialogListeners.size(); ++i) {
                ((DialogListener)this.dialogListeners.elementAt(i)).dialogProcessed(this.de);
            }
        }
    }

    class EventHandler
    implements ActionListener {
        EventHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == MainFrame.this.getcancelButton()) {
                MainFrame.this.processCancelAction();
            }
            if (e.getSource() == MainFrame.this.getbackButton()) {
                MainFrame.this.processBackAction();
            }
            if (e.getSource() == MainFrame.this.getnextButton()) {
                MainFrame.this.processNextAction();
            }
            if (e.getSource() == MainFrame.this.gethelpButton()) {
                MainFrame.this.processHelpAction();
            }
        }
    }
}

