/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.common;

import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.tools.upgrade.cluster.ClusterInfo;
import com.sun.enterprise.tools.upgrade.cluster.ClusteredInstance;
import com.sun.enterprise.tools.upgrade.cluster.ClustersInfoManager;
import com.sun.enterprise.tools.upgrade.common.Commands;
import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.common.DomainInfo;
import com.sun.enterprise.tools.upgrade.common.HarnessException;
import com.sun.enterprise.tools.upgrade.common.UpdateProgressManager;
import com.sun.enterprise.tools.upgrade.common.UpgradeUtils;
import com.sun.enterprise.tools.upgrade.logging.LogService;
import com.sun.enterprise.util.ASenvPropertyReader;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.net.NetUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.helpers.DefaultHandler;

public class DomainsProcessor {
    private static CommonInfoModel commonInfo;
    private Vector httpSSLPorts;
    private Vector iiopSSLPorts;
    private Vector iiopMutualAuthPorts;
    private Vector sourceXMLCorePorts;
    private static int adminPortToStartWith;
    private static Logger logger;
    private static StringManager stringManager;

    public DomainsProcessor(CommonInfoModel ci) {
        String sampleDomainFile;
        File samplesDir;
        commonInfo = ci;
        this.httpSSLPorts = new Vector();
        this.iiopSSLPorts = new Vector();
        this.iiopMutualAuthPorts = new Vector();
        this.sourceXMLCorePorts = new Vector();
        File domainDir = new File(ci.getTargetDomainRoot() + File.separator + "domain1");
        if (!domainDir.exists()) {
            // empty if block
        }
        String targetDomainFile = ci.getTargetDomainRoot() + File.separator + "domain1" + File.separator + "config" + File.separator + "domain.xml";
        if (domainDir.isDirectory() && !ci.isValid70Domain(ci.getTargetDomainRoot() + File.separator + "domain1") && new File(targetDomainFile).exists()) {
            String iiMAP;
            String iiSSP;
            String htSSP = DomainsProcessor.getPortFromXML(targetDomainFile, "http-listener", "http-listener-2");
            if (htSSP != null) {
                this.httpSSLPorts.add(htSSP);
            }
            if ((iiSSP = DomainsProcessor.getPortFromXML(targetDomainFile, "iiop-listener", "SSL")) != null) {
                this.iiopSSLPorts.add(iiSSP);
            }
            if ((iiMAP = DomainsProcessor.getPortFromXML(targetDomainFile, "iiop-listener", "SSL_MUTUALAUTH")) != null) {
                this.iiopMutualAuthPorts.add(iiMAP);
            }
        }
        if ((samplesDir = new File(ci.getTargetDomainRoot() + File.separator + "samples")).isDirectory() && !ci.isValid70Domain(ci.getTargetDomainRoot() + File.separator + "samples") && new File(sampleDomainFile = ci.getTargetDomainRoot() + File.separator + "samples" + File.separator + "config" + File.separator + "domain.xml").exists()) {
            String siiMAP;
            String siiSSP;
            String shtSSP = DomainsProcessor.getPortFromXML(sampleDomainFile, "http-listener", "http-listener-2");
            if (shtSSP != null) {
                this.httpSSLPorts.add(shtSSP);
            }
            if ((siiSSP = DomainsProcessor.getPortFromXML(sampleDomainFile, "iiop-listener", "SSL")) != null) {
                this.iiopSSLPorts.add(siiSSP);
            }
            if ((siiMAP = DomainsProcessor.getPortFromXML(sampleDomainFile, "iiop-listener", "SSL_MUTUALAUTH")) != null) {
                this.iiopMutualAuthPorts.add(siiMAP);
            }
        }
    }

    private DomainsProcessor(CommonInfoModel ci, boolean nothing) {
    }

    public void processTargetDomains() throws HarnessException {
        List domainNames = commonInfo.getDomainList();
        String target = commonInfo.getTargetInstallDir();
        ASenvPropertyReader reader = new ASenvPropertyReader(System.getProperty("com.sun.aas.configRoot"));
        reader.setSystemProperties();
        for (int i = 0; i < domainNames.size(); ++i) {
            String sourceDomainName;
            String targetDomainName = sourceDomainName = (String)domainNames.get(i);
            if (!new File(commonInfo.getTargetDomainRoot()).isDirectory()) {
                logger.log(Level.INFO, stringManager.getString("enterprise.tools.upgrade.not_valid_target_install"));
                return;
            }
            File targetDomainUpgrade = new File(commonInfo.getTargetDomainRoot() + File.separator + targetDomainName);
            if (!targetDomainUpgrade.isDirectory() || commonInfo.checkSourceInputAsDomainRoot(commonInfo.getSourceInstallDir())) {
                File targetDomainUpgrade80 = new File(commonInfo.getTargetDomainRoot() + File.separator + targetDomainName);
                if (targetDomainUpgrade80.isDirectory()) {
                    this.setAdminPortAndSecurity(sourceDomainName, targetDomainName);
                    continue;
                }
                String[] createDomainCommand = this.getCreateDomainCommand(sourceDomainName, targetDomainName);
                this.executeCommand(createDomainCommand);
                UpdateProgressManager.getProgressManager().processUpgradeUpdateEvent(i * 30 / domainNames.size());
            }
            this.setAdminPortAndSecurity(sourceDomainName, targetDomainName);
        }
    }

    private String[] getCreateDomainCommand(String domainName, String domainName80) {
        String target = commonInfo.getTargetInstallDir();
        String adminPort = DomainsProcessor.getSourceAdminPort(((DomainInfo)commonInfo.getDomainMapping().get(domainName)).getDomainPath());
        String httpPort = "8080";
        String jmsPort = "7676";
        String iiopPort = "3700";
        String httpSSLPort = this.getAFreePort(1044, 10);
        String iiopSSLPort = this.getAFreePort(1090, 10);
        String iiopSSLMutualAuth = this.getAFreePort(1091, 10);
        this.httpSSLPorts.add(httpSSLPort);
        this.iiopSSLPorts.add(iiopSSLPort);
        this.iiopMutualAuthPorts.add(iiopSSLMutualAuth);
        String propertiesString = "http.ssl.port=" + httpSSLPort + ":orb.ssl.port=" + iiopSSLPort + ":orb.mutualauth.port=" + iiopSSLMutualAuth + ":jms.port=" + jmsPort + ":orb.listener.port=" + iiopPort;
        String[] createDomainCommand = new String[]{"create-domain", "--domaindir", "\"" + commonInfo.getTargetDomainRoot() + "\"", "--adminport", adminPort, "--adminuser", commonInfo.getAdminUserName(), "--passwordfile ", "\"" + commonInfo.getPasswordFile() + "\"", "--domainproperties", propertiesString, domainName80};
        return createDomainCommand;
    }

    public static String getSourceAdminPort() {
        return DomainsProcessor.getSourceAdminPort(commonInfo.getSourceDomainPath());
    }

    public static String getSourceAdminPort(String domainPath) {
        if (commonInfo.getSourceVersion().equals("7x")) {
            String adminServerXmlFile = domainPath + File.separator + "admin-server" + File.separator + "config" + File.separator + "server.xml";
            String port = DomainsProcessor.getPortFromXML(adminServerXmlFile, "http-listener", "http-listener-1");
            if (port != null) {
                return port;
            }
        } else {
            String port;
            String domainXmlFile = domainPath + File.separator + "config" + File.separator + "domain.xml";
            if (new File(domainXmlFile).exists() && (port = DomainsProcessor.getPortFromXML(domainXmlFile, "http-listener", "admin-listener")) != null) {
                return port;
            }
        }
        adminPortToStartWith = 10;
        return String.valueOf(adminPortToStartWith);
    }

    public static String getSourceAdminSecurity(String domainPath) {
        if (commonInfo.getSourceVersion().equals("7x")) {
            String adminServerXmlFile = domainPath + File.separator + "admin-server" + File.separator + "config" + File.separator + "server.xml";
            String securityEnabled = DomainsProcessor.getSecurityEnabledFromXML(adminServerXmlFile, "http-listener", "http-listener-1");
            if (securityEnabled != null) {
                return securityEnabled;
            }
        } else {
            String securityEnabled;
            String domainXmlFile = domainPath + File.separator + "config" + File.separator + "domain.xml";
            if (new File(domainXmlFile).exists() && (securityEnabled = DomainsProcessor.getSecurityEnabledFromXML(domainXmlFile, "http-listener", "admin-listener")) != null) {
                return securityEnabled;
            }
        }
        return "true";
    }

    public static String getSourceAdminSecurity() {
        String domainPath = commonInfo.getSourceDomainPath();
        return DomainsProcessor.getSourceAdminSecurity(domainPath);
    }

    private void setAdminPortAndSecurity(String sourceDomainName, String targetDomainName) {
        String domainPath = ((DomainInfo)commonInfo.getDomainMapping().get(sourceDomainName)).getDomainPath();
        String adminPort = DomainsProcessor.getSourceAdminPort(domainPath);
        String securityEnabled = DomainsProcessor.getSourceAdminSecurity(domainPath);
        String domainFileName = commonInfo.getTargetDomainRoot() + File.separator + targetDomainName + File.separator + "config" + File.separator + "domain.xml";
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver((DefaultHandler)Class.forName("com.sun.enterprise.config.serverbeans.ServerValidationHandler").newInstance());
            Document resultDoc = builder.parse(new File(domainFileName));
            NodeList taggedElements = resultDoc.getDocumentElement().getElementsByTagName("http-listener");
            for (int lh = 0; lh < taggedElements.getLength(); ++lh) {
                Element element = (Element)taggedElements.item(lh);
                if (!element.getAttribute("id").equals("admin-listener")) continue;
                element.setAttribute("port", adminPort);
                element.setAttribute("security-enabled", securityEnabled);
                break;
            }
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            if (resultDoc.getDoctype() != null) {
                String systemValue = resultDoc.getDoctype().getSystemId();
                transformer.setOutputProperty("doctype-system", systemValue);
                String pubValue = resultDoc.getDoctype().getPublicId();
                transformer.setOutputProperty("doctype-public", pubValue);
            }
            DOMSource source = new DOMSource(resultDoc);
            StreamResult result = new StreamResult(new FileOutputStream(domainFileName));
            transformer.transform(source, result);
            result.getOutputStream().close();
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, stringManager.getString("domainProcessor.portFromXML"), ex);
        }
    }

    private static String getPortFromXML(String fileName, String tagName, String id) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver((DefaultHandler)Class.forName("com.sun.enterprise.config.serverbeans.ServerValidationHandler").newInstance());
            Document adminServerDoc = builder.parse(new File(fileName));
            NodeList taggedElements = adminServerDoc.getDocumentElement().getElementsByTagName(tagName);
            for (int lh = 0; lh < taggedElements.getLength(); ++lh) {
                Element element = (Element)taggedElements.item(lh);
                if (!element.getAttribute("id").equals(id)) continue;
                return element.getAttribute("port");
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, stringManager.getString("domainProcessor.portFromXML"), ex);
        }
        return null;
    }

    private static String getSecurityEnabledFromXML(String fileName, String tagName, String id) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver((DefaultHandler)Class.forName("com.sun.enterprise.config.serverbeans.ServerValidationHandler").newInstance());
            Document adminServerDoc = builder.parse(new File(fileName));
            NodeList taggedElements = adminServerDoc.getDocumentElement().getElementsByTagName(tagName);
            for (int lh = 0; lh < taggedElements.getLength(); ++lh) {
                Element element = (Element)taggedElements.item(lh);
                if (!element.getAttribute("id").equals(id)) continue;
                return element.getAttribute("security-enabled");
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, stringManager.getString("domainProcessor.adminSecureFromXML"), ex);
        }
        return null;
    }

    private String getTargetNodeAgentName(String domainName, CommonInfoModel commonInfoMod) {
        String configFileName = commonInfoMod.getTargetDomainRoot() + File.separator + domainName + File.separator + "config" + File.separator + "domain.xml";
        return this.getNodeAgentNameFromXML(configFileName);
    }

    private String getNodeAgentNameFromXML(String fileName) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver((DefaultHandler)Class.forName("com.sun.enterprise.config.serverbeans.ServerValidationHandler").newInstance());
            Document adminServerDoc = builder.parse(new File(fileName));
            NodeList taggedElements = adminServerDoc.getDocumentElement().getElementsByTagName("node-agent");
            Element element = (Element)taggedElements.item(0);
            if (null == element) {
                logger.log(Level.WARNING, stringManager.getString("domainProcessor.nodeAgentFromXML"));
                return null;
            }
            return element.getAttribute("name");
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, stringManager.getString("domainProcessor.nodeAgentFromXML"), ex);
            return null;
        }
    }

    private boolean isNodeAgentExists(String agentName, String fileName) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver((DefaultHandler)Class.forName("com.sun.enterprise.config.serverbeans.ServerValidationHandler").newInstance());
            Document adminServerDoc = builder.parse(new File(fileName));
            NodeList taggedElements = adminServerDoc.getDocumentElement().getElementsByTagName("node-agent");
            for (int lh = 0; lh < taggedElements.getLength(); ++lh) {
                Element itElement = (Element)taggedElements.item(lh);
                String attrName = itElement.getAttribute("name");
                if (attrName.equals(agentName)) {
                    return true;
                }
                if (agentName.indexOf(".") == -1 || !agentName.substring(0, agentName.indexOf(".")).equals(attrName)) continue;
                return true;
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, stringManager.getString("domainProcessor.nodeAgentFromXML"), ex);
        }
        return false;
    }

    public static String getTargetDomainPort(String domainName, CommonInfoModel commonInfoMod) {
        String configFileName = commonInfoMod.getTargetDomainRoot() + File.separator + domainName + File.separator + "config" + File.separator + "domain.xml";
        return DomainsProcessor.getPortFromXML(configFileName, "http-listener", "admin-listener");
    }

    public static String getTargetDomainSecurity(String domainName, CommonInfoModel commonInfoMod) {
        String configFileName = commonInfoMod.getTargetDomainRoot() + File.separator + domainName + File.separator + "config" + File.separator + "domain.xml";
        return DomainsProcessor.getSecurityEnabledFromXML(configFileName, "http-listener", "admin-listener");
    }

    private String getAFreePort(int initPortNumber, int increment) {
        int portNumber = initPortNumber;
        for (int i = 0; i < 20; ++i) {
            if (this.isPortNumberUsable(portNumber)) {
                return Integer.toString(portNumber);
            }
            portNumber += increment;
        }
        return Integer.toString(portNumber);
    }

    private boolean isPortNumberUsable(int portNumber) {
        int i;
        String portString = Integer.toString(portNumber);
        for (i = 0; i < this.httpSSLPorts.size(); ++i) {
            if (!((String)this.httpSSLPorts.get(i)).equals(portString)) continue;
            return false;
        }
        for (i = 0; i < this.iiopSSLPorts.size(); ++i) {
            if (!((String)this.iiopSSLPorts.get(i)).equals(portString)) continue;
            return false;
        }
        for (i = 0; i < this.iiopMutualAuthPorts.size(); ++i) {
            if (!((String)this.iiopMutualAuthPorts.get(i)).equals(portString)) continue;
            return false;
        }
        for (i = 0; i < this.sourceXMLCorePorts.size(); ++i) {
            if (!((String)this.sourceXMLCorePorts.get(i)).equals(portString)) continue;
            return false;
        }
        return NetUtils.isPortFree((int)portNumber);
    }

    private List getInstanceNamesWithoutAdminServerAndServer1(List instanceList) {
        ArrayList<String> newList = new ArrayList<String>();
        Iterator it = instanceList.iterator();
        while (it.hasNext()) {
            String serverName = (String)it.next();
            if (serverName.equals("admin-server")) continue;
            newList.add(serverName);
        }
        return newList;
    }

    public void processDomainInstances() throws HarnessException {
        Hashtable domainMapping = commonInfo.getDomainMapping();
        if (commonInfo.getTargetEdition().equals("pe")) {
            return;
        }
        Enumeration domains = domainMapping.keys();
        while (domains.hasMoreElements()) {
            DomainInfo dInfo = (DomainInfo)domainMapping.get((String)domains.nextElement());
            boolean domainStarted = false;
            if (this.getInstanceNamesWithoutAdminServerAndServer1(dInfo.getInstanceNames()).size() <= 0) continue;
            String adminPort = DomainsProcessor.getTargetDomainPort(dInfo.getDomainName(), commonInfo);
            String adminSecurity = DomainsProcessor.getTargetDomainSecurity(dInfo.getDomainName(), commonInfo);
            String agentName = this.getTargetNodeAgentName(dInfo.getDomainName(), commonInfo);
            if (agentName == null) {
                String hostName;
                try {
                    hostName = InetAddress.getLocalHost().getHostName();
                    agentName = hostName + "_" + dInfo.getDomainName();
                }
                catch (UnknownHostException uhe) {
                    hostName = "localhost";
                    agentName = dInfo.getDomainName() + "-agent";
                }
                this.createNodeAgent(agentName, hostName, adminPort, commonInfo.getAdminUserName(), commonInfo.getAdminPassword(), dInfo.getDomainName());
            }
            Iterator instanceNames = dInfo.getInstanceNames().iterator();
            while (instanceNames.hasNext()) {
                String serverName = (String)instanceNames.next();
                if (serverName.equals("admin-server") || commonInfo.getTargetEdition().equals("pe")) continue;
                if (!domainStarted) {
                    if (!this.startDomain(dInfo.getDomainName())) {
                        throw new HarnessException(stringManager.getString("domainProcessor.domainStartFailed", (Object)dInfo.getDomainName()));
                    }
                    domainStarted = true;
                }
                boolean status = this.createServerInstance(serverName, agentName, null, commonInfo.getAdminUserName(), commonInfo.getAdminPassword(), adminPort, adminSecurity);
                if (instanceNames.hasNext() || !domainStarted) continue;
                this.stopDomain(dInfo.getDomainName());
            }
        }
    }

    public boolean createNodeAgent(String agentName, String dasHost, String dasPort, String dasuser, String daspwd, String domainName) {
        String adminSecurity = DomainsProcessor.getTargetDomainSecurity(domainName, commonInfo);
        String[] command = new String[]{"create-node-agent", "--host", dasHost, "--port", dasPort, "--secure=" + adminSecurity, "--user", dasuser, "--passwordfile ", "\"" + commonInfo.getPasswordFile() + "\"", agentName};
        return this.executeCommand(command);
    }

    public boolean createConfig(String configName) {
        return false;
    }

    public boolean createServerInstance(String serverName, String agentName, String configName, String userid, String pwd, String adminPort, String adminSecurity) {
        if (configName != null) {
            String[] command = new String[]{"create-instance", "--nodeagent", agentName, "--port", adminPort, "--secure=" + adminSecurity, "--config", configName, "--user", userid, "--passwordfile ", "\"" + commonInfo.getPasswordFile() + "\"", serverName};
            return this.executeCommand(command);
        }
        String[] command = new String[]{"create-instance", "--nodeagent", agentName, "--user", userid, "--passwordfile ", "\"" + commonInfo.getPasswordFile() + "\"", "--port", adminPort, "--secure=" + adminSecurity, serverName};
        return this.executeCommand(command);
    }

    private boolean startDomain(String domainName) {
        return this.startDomain(domainName, commonInfo);
    }

    public boolean startDomain(String domainName, CommonInfoModel commonInfo) {
        return Commands.startDomain(domainName, commonInfo);
    }

    public boolean stopDomain(String domainName) {
        return Commands.stopDomain(domainName, commonInfo);
    }

    private boolean executeCommand(String[] commandStrings) {
        try {
            return Commands.executeCommand(commandStrings);
        }
        catch (CommandException ce) {
            Throwable t = ce.getCause();
            CommonInfoModel.getDefaultLogger().log(Level.SEVERE, stringManager.getString("enterprise.tools.upgrade.generalException", (Object)ce.getMessage()), ce);
            if (t != null) {
                CommonInfoModel.getDefaultLogger().severe(stringManager.getString("enterprise.tools.upgrade.generalException", (Object)t.getMessage()));
            }
            return false;
        }
    }

    public boolean processClusters() throws HarnessException {
        List clInfoList = ClustersInfoManager.getClusterInfoManager().getClusterInfoList();
        if (clInfoList == null || clInfoList.isEmpty()) {
            return false;
        }
        int clusterNo = 0;
        Iterator it = clInfoList.iterator();
        while (it.hasNext()) {
            Iterator clInstIt;
            String adminSecurity;
            String adminPort;
            ClusterInfo clInfo = (ClusterInfo)it.next();
            String clusterName = "cluster_" + Integer.toString(clusterNo++);
            clInfo.setClusterName(clusterName);
            this.createCluster(clusterName, clInfo.getDomainName());
            List clInstances = clInfo.getClusteredInstanceList();
            ClusteredInstance masterInstance = clInfo.getMasterInstance();
            boolean domainStarted = false;
            String startedDomainName = null;
            String configName = clusterName + "_config";
            if (masterInstance == null) {
                adminPort = null;
                adminSecurity = null;
                clInstIt = clInstances.iterator();
                while (clInstIt.hasNext()) {
                    ClusteredInstance clusteredInstance = (ClusteredInstance)clInstIt.next();
                    if (!domainStarted) {
                        startedDomainName = clusteredInstance.getDomain();
                        if (!this.startDomain(startedDomainName)) {
                            domainStarted = false;
                            throw new HarnessException(stringManager.getString("domainProcessor.domainStartFailed", (Object)startedDomainName));
                        }
                        adminPort = DomainsProcessor.getTargetDomainPort(startedDomainName, commonInfo);
                        adminSecurity = DomainsProcessor.getTargetDomainSecurity(startedDomainName, commonInfo);
                        domainStarted = true;
                    }
                    this.createClusteredInstance(clusteredInstance, clusterName, startedDomainName, configName, adminPort, adminSecurity);
                    if (clInstIt.hasNext() || !domainStarted) continue;
                    this.stopDomain(startedDomainName);
                }
                continue;
            }
            if (this.startDomain(masterInstance.getDomain())) {
                domainStarted = true;
                adminPort = DomainsProcessor.getTargetDomainPort(masterInstance.getDomain(), commonInfo);
                adminSecurity = DomainsProcessor.getTargetDomainSecurity(masterInstance.getDomain(), commonInfo);
                this.createClusteredInstance(masterInstance, clusterName, masterInstance.getDomain(), configName, adminPort, adminSecurity);
                clInstIt = clInstances.iterator();
                while (clInstIt.hasNext()) {
                    ClusteredInstance clInst = (ClusteredInstance)clInstIt.next();
                    if (!clInst.isMaster()) {
                        this.createClusteredInstance(clInst, clusterName, masterInstance.getDomain(), configName, adminPort, adminSecurity);
                    }
                    if (clInstIt.hasNext() || !domainStarted) continue;
                    this.stopDomain(masterInstance.getDomain());
                }
                continue;
            }
            throw new HarnessException(stringManager.getString("domainProcessor.domainStartFailed", (Object)masterInstance.getDomain()));
        }
        commonInfo.setCurrentCluster(null);
        this.processStandAloneInstances();
        return true;
    }

    private boolean createClusteredInstance(ClusteredInstance clInstance, String clusterName, String domainName, String configName, String adminPort, String adminSecurity) {
        String nodeAgentName = clInstance.getHost();
        String dasHostName = null;
        try {
            dasHostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhe) {
            dasHostName = domainName;
        }
        nodeAgentName = nodeAgentName.equals("localhost") ? dasHostName + "_" + domainName : nodeAgentName + "_" + domainName;
        String configFileName = commonInfo.getTargetDomainRoot() + File.separator + domainName + File.separator + "config" + File.separator + "domain.xml";
        if (!this.isNodeAgentExists(nodeAgentName, configFileName)) {
            this.createNodeAgent(nodeAgentName, dasHostName, clInstance.getPort(), commonInfo.getAdminUserName(), commonInfo.getAdminPassword(), domainName);
        }
        String user = commonInfo.getAdminUserName();
        String password = commonInfo.getAdminPassword();
        String[] command = new String[]{"create-instance", "--user", user, "--passwordfile ", "\"" + commonInfo.getPasswordFile() + "\"", "--nodeagent", nodeAgentName, "--port", adminPort, "--secure=" + adminSecurity, "--cluster", clusterName, clInstance.getInstanceName()};
        return this.executeCommand(command);
    }

    private boolean createCluster(String clusterName, String domainName) {
        String adminSecurity = null;
        String adminPort = null;
        if (domainName != null) {
            this.startDomain(domainName);
            adminPort = DomainsProcessor.getTargetDomainPort(domainName, commonInfo);
            adminSecurity = DomainsProcessor.getTargetDomainSecurity(domainName, commonInfo);
        }
        String[] command = new String[]{"create-cluster", "--port", adminPort, "--secure=" + adminSecurity, "--user", commonInfo.getAdminUserName(), "--passwordfile ", "\"" + commonInfo.getPasswordFile() + "\"", clusterName};
        boolean returnStatus = this.executeCommand(command);
        this.stopDomain(domainName);
        return returnStatus;
    }

    public void processStandAloneInstances() throws HarnessException {
        List stdAloneInsts = UpgradeUtils.getUpgradeUtils(commonInfo).getStandAloneInstances(commonInfo.getDomainMapping());
        Iterator it = stdAloneInsts.iterator();
        while (it.hasNext()) {
            Vector instDInfo = (Vector)it.next();
            String serverName = (String)instDInfo.elementAt(0);
            DomainInfo dInfo = (DomainInfo)instDInfo.elementAt(1);
            String adminPort = DomainsProcessor.getTargetDomainPort(dInfo.getDomainName(), commonInfo);
            String adminSecurity = DomainsProcessor.getTargetDomainSecurity(dInfo.getDomainName(), commonInfo);
            String agentName = this.getTargetNodeAgentName(dInfo.getDomainName(), commonInfo);
            if (!this.startDomain(dInfo.getDomainName())) {
                throw new HarnessException(stringManager.getString("domainProcessor.domainStartFailed", (Object)dInfo.getDomainName()));
            }
            if (agentName == null) {
                String hostName;
                try {
                    hostName = InetAddress.getLocalHost().getHostName();
                    agentName = hostName + "_" + dInfo.getDomainName();
                }
                catch (UnknownHostException uhe) {
                    hostName = "localhost";
                    agentName = dInfo.getDomainName() + "-agent";
                }
                this.createNodeAgent(agentName, hostName, adminPort, commonInfo.getAdminUserName(), commonInfo.getAdminPassword(), dInfo.getDomainName());
            }
            if (!serverName.equals("admin-server")) {
                boolean status = this.createServerInstance(serverName, agentName, null, commonInfo.getAdminUserName(), commonInfo.getAdminPassword(), adminPort, adminSecurity);
            }
            this.stopDomain(dInfo.getDomainName());
        }
    }

    static {
        adminPortToStartWith = 4858;
        logger = LogService.getLogger("com.sun.enterprise.tools.upgrade");
        stringManager = StringManager.getManager((String)"com.sun.enterprise.tools.upgrade");
    }
}

