/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.certconversion;

import com.sun.enterprise.tools.upgrade.certconversion.CertificateException;
import com.sun.enterprise.tools.upgrade.certconversion.NSStoJKSConversionModule;
import com.sun.enterprise.tools.upgrade.certconversion.ProcessAdaptor;
import com.sun.enterprise.tools.upgrade.common.BaseModule;
import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.common.UpdateProgressManager;
import com.sun.enterprise.tools.upgrade.logging.LogService;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NSStoNSSConversionModule
implements BaseModule {
    private static Logger _logger = LogService.getLogger("com.sun.enterprise.tools.upgrade");
    private StringManager sm = StringManager.getManager((String)"com.sun.enterprise.tools.upgrade.certconversion");
    private static final String PKCS12_OUTPUTFILE_OPTION = "-o";
    private static final String PKCS12_INPUTFILE_OPTION = "-i";
    private static final String NSS_DB_LOCATION_OPTION = "-d";
    private static final String ALIAS_OPTION = "-n";
    private static final String NSS_PWD_OPTION = "-K";
    private static final String NSS_DB_PREFIX = "-P";
    private static final String KEYSTORE_PWD_OPTION = "-W";
    private static final String LIST_KEY_ID = "-K";
    private static final String CREATE_NSS_DB = "-N";
    private static final String CERT_NSS_PWD_OPTION = "-f";
    private static final String CERT_UTIL_UNIX = "certutil.sh";
    private static final String PK12_UTIL_UNIX = "pk12util.sh";
    private static final String CERT_UTIL_WIN = "certutil.bat";
    private static final String PK12_UTIL_WIN = "pk12util.bat";
    private static final String CONFIG = "config";
    private static final String BIN = "bin";
    private static final String LIB = "lib";
    private static final String UPGRADE = "upgrade";
    String pathOfNSSDbFiles;
    private List pkcs12PathList;
    private List keyList;
    private CommonInfoModel commonInfo;

    public boolean upgrade(CommonInfoModel commonInfo) {
        try {
            String currentDomain = commonInfo.getCurrentDomain();
            if (!commonInfo.getDomainOptionList().contains(currentDomain)) {
                return true;
            }
            this.pkcs12PathList = new ArrayList();
            this.keyList = new ArrayList();
            this.commonInfo = commonInfo;
            _logger.log(Level.INFO, this.sm.getString("enterprise.tools.upgrade.certconversion.start_certificate_migration", (Object)currentDomain));
            this.doBackup(commonInfo);
            this.listAllKeysFromSourceInstall();
            this.generatePKCS12Certificates();
            this.migratePkcs12ToNss("");
            this.deletePKCS12Files();
            _logger.log(Level.INFO, this.sm.getString("enterprise.tools.upgrade.certconversion.finished_certificate_migration", (Object)currentDomain));
        }
        catch (CertificateException ce) {
            _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.certconversion.could_not_migrate_certificates", (Object)ce));
            UpdateProgressManager.getProgressManager().setContinueUpgrade(false);
            return false;
        }
        return true;
    }

    private void doBackup(CommonInfoModel commonInfo) throws CertificateException {
    }

    private void doCACertificateBackup() {
    }

    private void doKeyPairBackup() {
    }

    public void recovery(CommonInfoModel commonInfo) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void listAllKeysFromSourceInstall() throws CertificateException {
        String nssPwdFile;
        StringWriter result;
        String certutilLocation;
        String certUtilPath;
        String source70Bin;
        String source70Lib;
        String configDir;
        block12: {
            String osName = this.commonInfo.getOSName();
            String sourceDomainDir = this.commonInfo.getSourceInstancePath();
            configDir = sourceDomainDir + File.separator + CONFIG;
            source70Lib = this.commonInfo.getSourceInstallDir() + File.separator + LIB;
            source70Bin = this.commonInfo.getSourceInstallDir() + File.separator + BIN;
            certUtilPath = "";
            certutilLocation = this.commonInfo.getTargetInstallDir() + File.separator + LIB + File.separator + UPGRADE;
            certUtilPath = osName.indexOf("Windows") == -1 ? this.commonInfo.getTargetInstallDir() + File.separator + LIB + File.separator + CERT_UTIL_UNIX : this.commonInfo.getTargetInstallDir() + File.separator + LIB + File.separator + CERT_UTIL_WIN;
            result = new StringWriter();
            String nssPwd = this.commonInfo.getCertDbPassword();
            String domainPath = this.commonInfo.getDestinationDomainPath();
            nssPwdFile = domainPath + File.separator + "pwdfile";
            PrintWriter pw = null;
            pw = new PrintWriter(new FileOutputStream(nssPwdFile));
            pw.println(nssPwd);
            pw.flush();
            pw.close();
            Object var15_13 = null;
            try {
                if (pw != null) {
                    pw.close();
                }
                break block12;
            }
            catch (Exception e) {}
            break block12;
            {
                catch (FileNotFoundException fe) {
                    _logger.log(Level.INFO, this.sm.getString("enterprise.tools.upgrade.certconversion.unknownError "), fe);
                    var15_13 = null;
                    try {
                        if (pw != null) {
                            pw.close();
                        }
                        break block12;
                    }
                    catch (Exception e) {}
                }
            }
            catch (Throwable throwable) {
                Object var15_14 = null;
                try {
                    if (pw != null) {
                        pw.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        String commandString = certUtilPath + " " + "-K" + " " + NSS_DB_LOCATION_OPTION + " " + configDir + " " + CERT_NSS_PWD_OPTION + " " + nssPwdFile + " " + source70Lib + " " + source70Bin + " " + certutilLocation;
        int exitVal = ProcessAdaptor.executeProcess(commandString, (Writer)result);
        result.flush();
        String resultString = result.toString();
        if (exitVal != 0) {
            _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.certconversion.error_executing_certutil", (Object)resultString));
            throw new CertificateException(this.sm.getString("enterprise.tools.upgrade.certconversion.error_executing_certutil", (Object)resultString));
        }
        this.parseAndGetKeys(resultString);
    }

    private void parseAndGetKeys(String input) {
        try {
            BufferedReader reader = new BufferedReader(new StringReader(input));
            String readString = reader.readLine();
            while (readString != null) {
                String marker = readString.substring(0, 1);
                String anotherMarker = readString.substring(2, 3);
                if (!marker.equals("<") || !anotherMarker.equals(">")) {
                    _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.certconversion.error_executing_certutil", (Object)input));
                    return;
                }
                String alias = readString.substring(4);
                this.keyList.add(alias);
                _logger.log(Level.INFO, this.sm.getString("enterprise.tools.upgrade.certconversion.alias_info", (Object)this.commonInfo.getCurrentDomain(), (Object)alias));
                readString = reader.readLine();
            }
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.certconversion.unknownError"), e);
        }
    }

    private void generatePKCS12Certificates() throws CertificateException {
        String osName = this.commonInfo.getOSName();
        int size = this.keyList.size();
        for (int i = 0; i < size; ++i) {
            String pkcsFile = this.removeWhiteSpace("" + this.keyList.get(i));
            String pkcsFilePath = this.commonInfo.getDestinationDomainPath() + File.separator + pkcsFile + ".pkcs12";
            String sourceDomainDir = this.commonInfo.getSourceInstancePath();
            String configDir = sourceDomainDir + File.separator + CONFIG;
            String source70Lib = this.commonInfo.getSourceInstallDir() + File.separator + LIB;
            String source70Bin = this.commonInfo.getSourceInstallDir() + File.separator + BIN;
            String pk12UtilPath = "";
            pk12UtilPath = osName.indexOf("Windows") == -1 ? this.commonInfo.getTargetInstallDir() + File.separator + LIB + File.separator + PK12_UTIL_UNIX : this.commonInfo.getTargetInstallDir() + File.separator + LIB + File.separator + PK12_UTIL_WIN;
            String pk12utilLocation = this.commonInfo.getTargetInstallDir() + File.separator + LIB + File.separator + UPGRADE;
            String[] commandArray = new String[]{pk12UtilPath, source70Lib, source70Bin, pk12utilLocation, PKCS12_OUTPUTFILE_OPTION, pkcsFilePath, NSS_DB_LOCATION_OPTION, configDir, ALIAS_OPTION, "" + this.keyList.get(i) + "", "-K", this.commonInfo.getCertDbPassword(), KEYSTORE_PWD_OPTION, this.commonInfo.getCertDbPassword()};
            StringWriter result = new StringWriter();
            int exitVal = ProcessAdaptor.executeProcess(commandArray, (Writer)result);
            result.flush();
            if (exitVal != 0) {
                _logger.log(Level.INFO, this.sm.getString("enterprise.tools.upgrade.certconversion.certificateError", this.keyList.get(i), (Object)this.commonInfo.getCurrentDomain(), (Object)result.toString()));
                throw new CertificateException(this.sm.getString("enterprise.tools.upgrade.certconversion.certificateError", this.keyList.get(i), (Object)this.commonInfo.getCurrentDomain(), (Object)result.toString()));
            }
            this.pkcs12PathList.add(pkcsFilePath);
        }
    }

    private void migratePkcs12ToNss(String certPrefix) throws CertificateException {
        String osName = this.commonInfo.getOSName();
        int size = this.keyList.size();
        String configDir = this.commonInfo.getTargetConfig();
        String source70Lib = this.commonInfo.getTargetInstallDir() + File.separator + LIB;
        String source70Bin = this.commonInfo.getTargetInstallDir() + File.separator + BIN;
        String pk12UtilPath = "";
        pk12UtilPath = osName.indexOf("Windows") == -1 ? this.commonInfo.getTargetInstallDir() + File.separator + LIB + File.separator + PK12_UTIL_UNIX : this.commonInfo.getTargetInstallDir() + File.separator + LIB + File.separator + PK12_UTIL_WIN;
        String pk12utilLocation = this.commonInfo.getTargetInstallDir() + File.separator + LIB;
        Iterator itr = this.pkcs12PathList.iterator();
        while (itr.hasNext()) {
            String alias = (String)itr.next();
            _logger.log(Level.INFO, this.sm.getString("enterprise.tools.upgrade.certconversion.processing_keypair", (Object)alias));
            String[] commandArray = new String[]{pk12UtilPath, source70Lib, source70Bin, pk12utilLocation, PKCS12_INPUTFILE_OPTION, alias, NSS_DB_LOCATION_OPTION, configDir, "-K", this.commonInfo.getTargetCertDbPassword(), KEYSTORE_PWD_OPTION, this.commonInfo.getCertDbPassword()};
            StringWriter result = new StringWriter();
            int exitVal = ProcessAdaptor.executeProcess(commandArray, (Writer)result);
            result.flush();
            if (exitVal == 0) {
                _logger.log(Level.INFO, this.sm.getString("enterprise.tools.upgrade.certconversion.alias_transferred", (Object)alias));
                continue;
            }
            _logger.log(Level.INFO, this.sm.getString("enterprise.tools.upgrade.certconversion.certificateError", (Object)alias, (Object)this.commonInfo.getCurrentDomain(), (Object)result.toString()));
            throw new CertificateException(this.sm.getString("enterprise.tools.upgrade.certconversion.certificateError", (Object)alias, (Object)this.commonInfo.getCurrentDomain(), (Object)result.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void initializeNSSDB(String certPrefix) throws CertificateException {
        String nssPwdFile;
        StringWriter result;
        String certUtilPath;
        String certutilLocation;
        String source70Bin;
        String source70Lib;
        String configDir;
        block13: {
            String osName = this.commonInfo.getOSName();
            String sourceDomainDir = this.commonInfo.getSourceInstancePath();
            configDir = this.commonInfo.getTargetConfig();
            source70Lib = this.commonInfo.getSourceInstallDir() + File.separator + LIB;
            source70Bin = this.commonInfo.getSourceInstallDir() + File.separator + BIN;
            certutilLocation = this.commonInfo.getTargetInstallDir() + File.separator + LIB;
            certUtilPath = "";
            certUtilPath = osName.indexOf("Windows") == -1 ? this.commonInfo.getTargetInstallDir() + File.separator + LIB + File.separator + CERT_UTIL_UNIX : this.commonInfo.getTargetInstallDir() + File.separator + LIB + File.separator + CERT_UTIL_WIN;
            File key3db = new File(configDir + File.separator + certPrefix + "key3.db");
            if (key3db.exists()) {
                return;
            }
            result = new StringWriter();
            String nssPwd = this.commonInfo.getTargetCertDbPassword();
            String domainPath = this.commonInfo.getDestinationDomainPath();
            nssPwdFile = domainPath + File.separator + "pwdfile";
            PrintWriter pw = null;
            pw = new PrintWriter(new FileOutputStream(nssPwdFile));
            pw.println(nssPwd);
            pw.flush();
            pw.close();
            Object var17_15 = null;
            try {
                if (pw != null) {
                    pw.close();
                }
                break block13;
            }
            catch (Exception e) {}
            break block13;
            {
                catch (FileNotFoundException fe) {
                    _logger.log(Level.INFO, this.sm.getString("enterprise.tools.upgrade.certconversion.unknownError "), fe);
                    var17_15 = null;
                    try {
                        if (pw != null) {
                            pw.close();
                        }
                        break block13;
                    }
                    catch (Exception e) {}
                }
            }
            catch (Throwable throwable) {
                Object var17_16 = null;
                try {
                    if (pw != null) {
                        pw.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        String commandString = certUtilPath + " " + CREATE_NSS_DB + " " + NSS_DB_LOCATION_OPTION + " " + configDir + " " + NSS_DB_PREFIX + " " + certPrefix + " " + CERT_NSS_PWD_OPTION + " " + nssPwdFile + " " + source70Lib + " " + source70Bin + " " + certutilLocation;
        int exitVal = ProcessAdaptor.executeProcess(commandString, (Writer)result);
        result.flush();
        String resultString = result.toString();
        if (exitVal != 0) {
            _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.certconversion.error_executing_certutil", (Object)resultString));
            throw new CertificateException(this.sm.getString("enterprise.tools.upgrade.certconversion.error_executing_certutil", (Object)resultString));
        }
    }

    private String removeWhiteSpace(String str) {
        String concat = "";
        StringTokenizer st = new StringTokenizer(str);
        while (st.hasMoreTokens()) {
            concat = concat + st.nextToken();
        }
        return concat;
    }

    private void deletePKCS12Files() {
        String pkcsFilesPath = this.commonInfo.getDestinationDomainPath();
        String[] fileList = new File(pkcsFilesPath).list();
        for (int i = 0; i < fileList.length; ++i) {
            File pkcsFile = new File(pkcsFilesPath + File.separator + fileList[i]);
            if (!pkcsFile.isFile() || !fileList[i].endsWith(".pkcs12")) continue;
            pkcsFile.delete();
        }
        String domainPath = this.commonInfo.getDestinationDomainPath();
        String nssPwdFile = domainPath + File.separator + "pwdfile";
        File pwdfile = new File(nssPwdFile);
        pwdfile.delete();
    }

    public static void main(String[] args) {
        CommonInfoModel commonInfo = new CommonInfoModel();
        commonInfo.setSourceInstallDir(args[0]);
        commonInfo.setTargetInstallDir(args[1]);
        commonInfo.setCertDbPassword(args[2]);
        commonInfo.setJksKeystorePassword(args[3]);
        NSStoJKSConversionModule convModule = new NSStoJKSConversionModule();
        convModule.upgrade(commonInfo);
    }

    public String getName() {
        return this.sm.getString("enterprise.tools.upgrade.certconversion.moduleName");
    }
}

