/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade;

import com.sun.enterprise.tools.upgrade.UpgradeHarness;
import com.sun.enterprise.tools.upgrade.cli.CLIParser;
import com.sun.enterprise.tools.upgrade.cli.CliLogMessageListener;
import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.common.UpdateProgressManager;
import com.sun.enterprise.tools.upgrade.gui.MainFrame;
import com.sun.enterprise.tools.upgrade.gui.util.DialogEvent;
import com.sun.enterprise.tools.upgrade.gui.util.DialogListener;
import com.sun.enterprise.tools.upgrade.logging.LogService;
import com.sun.enterprise.util.ASenvPropertyReader;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UpgradeToolMain {
    static Logger _logger;
    private CommonInfoModel commonInfo;
    private UpgradeHarness harness;
    private String certDbPassword;
    private String aliasname;
    private String keyStorePassword;
    private StringManager sm;

    public UpgradeToolMain() {
        ASenvPropertyReader reader = new ASenvPropertyReader(System.getProperty("com.sun.aas.configRoot"));
        reader.setSystemProperties();
        this.sm = StringManager.getManager((String)"com.sun.enterprise.tools.upgrade");
        _logger.log(Level.INFO, this.sm.getString("enterprise.tools.upgrade.start_upgrade_tool"));
        this.commonInfo = new CommonInfoModel();
        String targetDomainRoot = System.getProperty("com.sun.aas.domainRoot");
        this.commonInfo.setTargetDomainRoot(targetDomainRoot);
        String targetVersion = System.getProperty("com.sun.aas.utool.targetVersion");
        if (targetVersion != null) {
            this.commonInfo.setTargetVersionAndEdition(targetVersion);
            if (!targetVersion.equalsIgnoreCase("as81pe")) {
                this.commonInfo.setMasterPassword("");
            }
        }
        this.harness = new UpgradeHarness();
        this.commonInfo.setOSName(System.getProperty("os.name"));
    }

    public void startGUI(String[] args) {
        _logger.log(Level.INFO, this.sm.getString("enterprise.tools.upgrade.start_upgrade_tool_gui"));
        if (args.length > 0) {
            CliLogMessageListener l = new CliLogMessageListener();
            LogService.addLogMessageListener(l);
            new CLIParser(this.commonInfo).parseOptions(args);
            LogService.removeLogMessageListener(l);
        }
        MainFrame gui = new MainFrame(this.commonInfo);
        LogService.addLogMessageListener(gui);
        gui.addDialogListener(new DialogListener(){

            public void dialogProcessed(DialogEvent evt) {
                UpgradeToolMain.this.processUIEvent(evt);
            }
        });
        UpdateProgressManager.getProgressManager().addUpgradeUpdateListener(gui);
        gui.setVisible(true);
    }

    public void startCLI(String[] args) {
        _logger.log(Level.INFO, this.sm.getString("enterprise.tools.upgrade.start_upgrade_tool_cli"));
        CLIParser parser = new CLIParser();
        LogService.addLogMessageListener(new CliLogMessageListener());
        parser.setCommonInfoModel(this.commonInfo);
        try {
            parser.parseComandLineArguments(args);
        }
        catch (Exception e) {
            _logger.log(Level.INFO, this.sm.getString("enterprise.tools.upgrade.unexpected_parsing"), e);
            System.exit(1);
        }
        this.upgrade();
    }

    private void processUIEvent(DialogEvent evt) {
        if (evt.getAction() == 5 || evt.getAction() == 2) {
            System.exit(0);
        } else if (evt.getAction() == 4) {
            this.upgrade();
        }
    }

    private void upgrade() {
        this.harness.setCommonInfoModel(this.commonInfo);
        _logger.log(Level.INFO, this.sm.getString("enterprise.tools.upgrade.start_upgrade_harness"));
        this.harness.startUpgrade();
        this.commonInfo.deletePasswordFile();
    }

    private void helpUsage() {
        System.out.println(this.sm.getString("enterprise.tools.upgrade.cli.usage"));
        if (this.commonInfo.checkUpgradefrom7xpeseto8xpe() || this.commonInfo.checkUpgradefrom8xpeto8xse()) {
            System.out.println(this.sm.getString("enterprise.tools.upgrade.cli.command_string"));
            System.out.println();
            return;
        }
        if (this.commonInfo.checkUpgradefrom7xpeseto8xse()) {
            System.out.println(this.sm.getString("enterprise.tools.upgrade.cli.commandfrom7xseto8xse_string"));
            System.out.println();
            return;
        }
        if (this.commonInfo.checkUpgradefrom80peto81pe()) {
            System.out.println(this.sm.getString("enterprise.tools.upgrade.cli.commandfrom80peto81pe_string"));
            System.out.println();
            return;
        }
        System.out.println(this.sm.getString("enterprise.tools.upgrade.cli.command_string"));
        System.out.println();
    }

    public static void main(String[] args) {
        UpgradeToolMain main = new UpgradeToolMain();
        if (args.length == 0) {
            main.startGUI(args);
        } else if (args[0].equals("-c") || args[0].equals("--console") || args[0].equals("-V") || args[0].equals("--version")) {
            main.startCLI(args);
        } else {
            main.startGUI(args);
        }
    }

    static {
        String domainRoot = System.getProperty("com.sun.aas.domainRoot");
        if (domainRoot == null) {
            domainRoot = ".";
        }
        String upgradeLogPath = domainRoot + File.separator + "upgrade.log";
        try {
            File f = new File(domainRoot);
            if (!f.exists()) {
                f.mkdirs();
            }
            LogService.initialize(upgradeLogPath);
        }
        catch (Exception e) {
            System.out.println("Could not create upgrade.log file: " + e.getLocalizedMessage());
        }
        _logger = LogService.getLogger("com.sun.enterprise.tools.upgrade");
    }
}

