/*
 * Decompiled with CFR 0.152.
 */
package jaxrpcmejb;

import com.sun.enterprise.management.agent.ws.LocalNotificationObject;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;
import javax.management.NotificationListener;
import org.exolab.castor.xml.Unmarshaller;

public class HttpListener
implements Runnable {
    private static final String HTTP_OK_RESPONSE = "HTTP/1.1 200 OK\r\n\r\n";
    private static final int CONTENT_LENGTH_SIZE = 16;
    private ServerSocket sSocket = null;
    private Hashtable clientListenerRegistry;
    private String uri;

    public HttpListener(int n) {
        try {
            this.clientListenerRegistry = new Hashtable();
            this.sSocket = new ServerSocket(n);
            this.uri = "http://" + InetAddress.getLocalHost().getHostName() + ":" + this.sSocket.getLocalPort();
            System.out.println("ListenerURI = " + this.uri);
            new Thread(this).start();
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception);
            exception.printStackTrace();
        }
    }

    public void run() {
        try {
            Socket socket = this.sSocket.accept();
            new Thread(this).start();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            this.notify(bufferedReader);
            PrintStream printStream = new PrintStream(new BufferedOutputStream(socket.getOutputStream()));
            printStream.print(HTTP_OK_RESPONSE);
            printStream.flush();
            socket.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean notify(BufferedReader bufferedReader) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        String string = bufferedReader.readLine();
        if (string == null) {
            return false;
        }
        int n2 = string.substring(6).indexOf(" ");
        string = string.substring(6, n2 + 6);
        n2 = string.indexOf("/");
        String string2 = null;
        String string3 = null;
        if (n2 != -1) {
            string2 = string.substring(0, n2);
            string3 = string.substring(n2 + 1);
        } else {
            string2 = string;
        }
        while (!(string = bufferedReader.readLine()).regionMatches(true, 0, "Content-Length:", 0, "Content-Length:".length())) {
        }
        int n3 = new Integer(string.substring(16));
        int n4 = 0;
        for (n = 0; n < n3 + 1; ++n) {
            n4 = bufferedReader.read();
            stringBuffer.append((char)n4);
        }
        n = 0;
        String string4 = stringBuffer.toString();
        n = string4.indexOf("<?xml version");
        n2 = string4.indexOf("</local-notification-object>");
        string4 = string4.substring(n, n2 += new String("</local-notification-object>").length());
        LocalNotificationObject localNotificationObject = new LocalNotificationObject();
        try {
            localNotificationObject = (LocalNotificationObject)Unmarshaller.unmarshal(localNotificationObject.getClass(), (Reader)new StringReader(string4));
            NotificationListener notificationListener = (NotificationListener)this.clientListenerRegistry.get(string2);
            notificationListener.handleNotification(localNotificationObject.getNotificationObject(), string3);
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public void add(NotificationListener notificationListener) {
        this.clientListenerRegistry.put(String.valueOf(notificationListener.hashCode()), notificationListener);
    }

    public String getUri() {
        return this.uri;
    }
}

