/*
 * Decompiled with CFR 0.152.
 */
package tools.com.sun.enterprise.util;

import com.sun.enterprise.deployment.xml.DTDRegistry;
import com.sun.enterprise.logging.LogDomains;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLValidationHandler
extends DefaultHandler {
    protected static Hashtable mapping = null;
    private Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.avk.tools.verifier");
    private boolean throwsException;

    public XMLValidationHandler(boolean thowsException) {
        this.throwsException = thowsException;
        XMLValidationHandler.Init();
    }

    public XMLValidationHandler() {
        this.throwsException = true;
        XMLValidationHandler.Init();
    }

    private static void Init() {
        if (mapping == null) {
            mapping = new Hashtable();
            mapping.put("-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN", "application_1_3.dtd");
            mapping.put("-//Sun Microsystems, Inc.//DTD J2EE Application 1.2//EN", "application_1_2.dtd");
            mapping.put("-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN", "ejb-jar_2_0.dtd");
            mapping.put("-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN", "ejb-jar_1_1.dtd");
            mapping.put("-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.3//EN", "application-client_1_3.dtd");
            mapping.put("-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.2//EN", "application-client_1_2.dtd");
            mapping.put("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", "web-app_2_3.dtd");
            mapping.put("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", "web-app_2_2.dtd");
            mapping.put("-//Sun Microsystems, Inc.//DTD Connector 1.5//EN", "connector_1_5.dtd");
            mapping.put("-//Sun Microsystems, Inc.//DTD Connector 1.0//EN", "connector_1_0.dtd");
            mapping.put("-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 7.0 J2EE Application 1.3//EN", "sun-application_1_3-0.dtd");
            mapping.put("-//Sun Microsystems, Inc.//DTD Application Server 8.0 J2EE Application 1.4//EN", "sun-application_1_4-0.dtd");
            mapping.put("-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 8.0 J2EE Application 1.4//EN", "sun-application_1_4-0.dtd");
            mapping.put("-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 7.0 Application Client 1.3//EN", "sun-application-client_1_3-0.dtd");
            mapping.put("-//Sun Microsystems, Inc.//DTD Application Server 8.0 Application Client 1.4//EN", "sun-application-client_1_4-0.dtd");
            mapping.put("-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 8.0 Application Client 1.4//EN", "sun-application-client_1_4-0.dtd");
            mapping.put("-//Sun Microsystems, Inc.//DTD Application Server 8.1 Application Client 1.4//EN", "sun-application-client_1_4-1.dtd");
            mapping.put("-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 7.0 Servlet 2.3//EN", "sun-web-app_2_3-0.dtd");
            mapping.put("-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 7.1 Servlet 2.3//EN", "sun-web-app_2_3-1.dtd");
            mapping.put("-//Sun Microsystems, Inc.//DTD Application Server 8.0 Servlet 2.4//EN", "sun-web-app_2_4-0.dtd");
            mapping.put("-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 8.0 Servlet 2.4//EN", "sun-web-app_2_4-0.dtd");
            mapping.put("-//Sun Microsystems, Inc.//DTD Application Server 8.1 Servlet 2.4//EN", "sun-web-app_2_4-1.dtd");
            mapping.put("-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 7.0 EJB 2.0//EN", "sun-ejb-jar_2_0-0.dtd");
            mapping.put("-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 7.1 EJB 2.0//EN", "sun-ejb-jar_2_0-1.dtd");
            mapping.put("-//Sun Microsystems, Inc.//DTD Application Server 8.0 EJB 2.1//EN", "sun-ejb-jar_2_1-0.dtd");
            mapping.put("-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 8.0 EJB 2.1//EN", "sun-ejb-jar_2_1-0.dtd");
            mapping.put("-//Sun Microsystems, Inc.//DTD Application Server 8.1 EJB 2.1//EN", "sun-ejb-jar_2_1-1.dtd");
            mapping.put("-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 7.0 Connector 1.0//EN", "sun-connector_1_0-0.dtd");
            mapping.put("-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 7.0 Application Client Container 1.0//EN", "sun-application-client-container_1_0.dtd");
            mapping.put("-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 7.0 OR Mapping //EN", "sun-cmp-mapping_1_0.dtd");
            mapping.put("-//Sun Microsystems, Inc.//DTD Application Server 8.0 OR Mapping//EN", "sun-cmp-mapping_1_1.dtd");
            mapping.put("-//Sun Microsystems, Inc.//DTD Application Server 8.1 OR Mapping//EN", "sun-cmp-mapping_1_2.dtd");
            mapping.put("-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.2//EN", "web-jsptaglibrary_1_2.dtd");
            mapping.put("-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.1//EN", "web-jsptaglibrary_1_1.dtd");
        }
    }

    public InputSource resolveEntity(String publicID, String systemID) throws SAXException {
        try {
            if (mapping.containsKey(publicID)) {
                return new InputSource(new FileInputStream(new File(this.getAbsoluteFilenameForDTD((String)mapping.get(publicID)))));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public void error(SAXParseException spe) throws SAXParseException {
        this.logger.log(Level.FINE, "XML Error line : " + spe.getLineNumber() + " " + spe.getLocalizedMessage());
        if (this.throwsException) {
            throw spe;
        }
    }

    public void fatalError(SAXParseException spe) throws SAXParseException {
        this.logger.log(Level.FINE, spe.toString());
        throw spe;
    }

    protected String getAbsoluteFilenameForDTD(String dtdFilename) {
        String j2ee13 = DTDRegistry.DTD_LOCATION;
        File f = new File(j2ee13 + File.separator + dtdFilename);
        return f.getAbsolutePath();
    }
}

